/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.RemediatingAction;
import com.adyen.model.legalentitymanagement.VerificationErrorRecursive;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VerificationError {
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private List<CapabilitiesEnum> capabilities = null;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REMEDIATING_ACTIONS = "remediatingActions";
    @SerializedName(value="remediatingActions")
    private List<RemediatingAction> remediatingActions = null;
    public static final String SERIALIZED_NAME_SUB_ERRORS = "subErrors";
    @SerializedName(value="subErrors")
    private List<VerificationErrorRecursive> subErrors = null;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VerificationError capabilities(List<CapabilitiesEnum> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public VerificationError addCapabilitiesItem(CapabilitiesEnum capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<CapabilitiesEnum>();
        }
        this.capabilities.add(capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that the legal entity can do in your platform. The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.")
    public List<CapabilitiesEnum> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<CapabilitiesEnum> capabilities) {
        this.capabilities = capabilities;
    }

    public VerificationError code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="The general error code.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public VerificationError message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="The general error message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public VerificationError remediatingActions(List<RemediatingAction> remediatingActions) {
        this.remediatingActions = remediatingActions;
        return this;
    }

    public VerificationError addRemediatingActionsItem(RemediatingAction remediatingActionsItem) {
        if (this.remediatingActions == null) {
            this.remediatingActions = new ArrayList<RemediatingAction>();
        }
        this.remediatingActions.add(remediatingActionsItem);
        return this;
    }

    @ApiModelProperty(value="An object containing possible solutions to fix a verification error.")
    public List<RemediatingAction> getRemediatingActions() {
        return this.remediatingActions;
    }

    public void setRemediatingActions(List<RemediatingAction> remediatingActions) {
        this.remediatingActions = remediatingActions;
    }

    public VerificationError subErrors(List<VerificationErrorRecursive> subErrors) {
        this.subErrors = subErrors;
        return this;
    }

    public VerificationError addSubErrorsItem(VerificationErrorRecursive subErrorsItem) {
        if (this.subErrors == null) {
            this.subErrors = new ArrayList<VerificationErrorRecursive>();
        }
        this.subErrors.add(subErrorsItem);
        return this;
    }

    @ApiModelProperty(value="An array containing more granular information about the cause of the verification error.")
    public List<VerificationErrorRecursive> getSubErrors() {
        return this.subErrors;
    }

    public void setSubErrors(List<VerificationErrorRecursive> subErrors) {
        this.subErrors = subErrors;
    }

    public VerificationError type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of error.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationError verificationError = (VerificationError)o;
        return Objects.equals(this.capabilities, verificationError.capabilities) && Objects.equals(this.code, verificationError.code) && Objects.equals(this.message, verificationError.message) && Objects.equals(this.remediatingActions, verificationError.remediatingActions) && Objects.equals(this.subErrors, verificationError.subErrors) && Objects.equals((Object)this.type, (Object)verificationError.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.code, this.message, this.remediatingActions, this.subErrors, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationError {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    remediatingActions: ").append(this.toIndentedString(this.remediatingActions)).append("\n");
        sb.append("    subErrors: ").append(this.toIndentedString(this.subErrors)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysubErrors;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in VerificationError is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `VerificationError` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITIES) != null && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `capabilities` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPABILITIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
        JsonArray jsonArrayremediatingActions = jsonObj.getAsJsonArray(SERIALIZED_NAME_REMEDIATING_ACTIONS);
        if (jsonArrayremediatingActions != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REMEDIATING_ACTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `remediatingActions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REMEDIATING_ACTIONS).toString()));
            }
            for (int i = 0; i < jsonArrayremediatingActions.size(); ++i) {
                RemediatingAction.validateJsonObject(jsonArrayremediatingActions.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraysubErrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUB_ERRORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUB_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subErrors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArraysubErrors.size(); ++i) {
                VerificationErrorRecursive.validateJsonObject(jsonArraysubErrors.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static VerificationError fromJson(String jsonString) throws IOException {
        return (VerificationError)JSON.getGson().fromJson(jsonString, VerificationError.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_CODE);
        openapiFields.add(SERIALIZED_NAME_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_REMEDIATING_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_SUB_ERRORS);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!VerificationError.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VerificationError.class));
            return new TypeAdapter<VerificationError>(){

                public void write(JsonWriter out, VerificationError value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public VerificationError read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VerificationError.validateJsonObject(jsonObj);
                    return (VerificationError)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DATAMISSING("dataMissing"),
        INVALIDINPUT("invalidInput"),
        PENDINGSTATUS("pendingStatus");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CapabilitiesEnum {
        ACCEPTEXTERNALFUNDING("acceptExternalFunding"),
        ACCEPTPSPFUNDING("acceptPspFunding"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES("acceptTransactionInRestrictedCountries"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL("acceptTransactionInRestrictedCountriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER("acceptTransactionInRestrictedCountriesConsumer"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES("acceptTransactionInRestrictedIndustries"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL("acceptTransactionInRestrictedIndustriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER("acceptTransactionInRestrictedIndustriesConsumer"),
        ACQUIRING("acquiring"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALCOMMERCIAL("atmWithdrawalCommercial"),
        ATMWITHDRAWALCONSUMER("atmWithdrawalConsumer"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIES("atmWithdrawalInRestrictedCountries"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL("atmWithdrawalInRestrictedCountriesCommercial"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER("atmWithdrawalInRestrictedCountriesConsumer"),
        AUTHORISEDPAYMENTINSTRUMENTUSER("authorisedPaymentInstrumentUser"),
        GETGRANTOFFERS("getGrantOffers"),
        ISSUEBANKACCOUNT("issueBankAccount"),
        ISSUECARD("issueCard"),
        ISSUECARDCOMMERCIAL("issueCardCommercial"),
        ISSUECARDCONSUMER("issueCardConsumer"),
        LOCALACCEPTANCE("localAcceptance"),
        PAYOUT("payout"),
        PAYOUTTOTRANSFERINSTRUMENT("payoutToTransferInstrument"),
        PROCESSING("processing"),
        RECEIVEFROMBALANCEACCOUNT("receiveFromBalanceAccount"),
        RECEIVEFROMPLATFORMPAYMENTS("receiveFromPlatformPayments"),
        RECEIVEFROMTHIRDPARTY("receiveFromThirdParty"),
        RECEIVEFROMTRANSFERINSTRUMENT("receiveFromTransferInstrument"),
        RECEIVEGRANTS("receiveGrants"),
        RECEIVEPAYMENTS("receivePayments"),
        SENDTOBALANCEACCOUNT("sendToBalanceAccount"),
        SENDTOTHIRDPARTY("sendToThirdParty"),
        SENDTOTRANSFERINSTRUMENT("sendToTransferInstrument"),
        THIRDPARTYFUNDING("thirdPartyFunding"),
        USECARD("useCard"),
        USECARDCOMMERCIAL("useCardCommercial"),
        USECARDCONSUMER("useCardConsumer"),
        USECARDINRESTRICTEDCOUNTRIES("useCardInRestrictedCountries"),
        USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL("useCardInRestrictedCountriesCommercial"),
        USECARDINRESTRICTEDCOUNTRIESCONSUMER("useCardInRestrictedCountriesConsumer"),
        USECARDINRESTRICTEDINDUSTRIES("useCardInRestrictedIndustries"),
        USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL("useCardInRestrictedIndustriesCommercial"),
        USECARDINRESTRICTEDINDUSTRIESCONSUMER("useCardInRestrictedIndustriesConsumer"),
        WITHDRAWFROMATM("withdrawFromAtm"),
        WITHDRAWFROMATMCOMMERCIAL("withdrawFromAtmCommercial"),
        WITHDRAWFROMATMCONSUMER("withdrawFromAtmConsumer"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIES("withdrawFromAtmInRestrictedCountries"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL("withdrawFromAtmInRestrictedCountriesCommercial"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER("withdrawFromAtmInRestrictedCountriesConsumer");

        private String value;

        private CapabilitiesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CapabilitiesEnum fromValue(String value) {
            for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CapabilitiesEnum> {
            public void write(JsonWriter jsonWriter, CapabilitiesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CapabilitiesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CapabilitiesEnum.fromValue(value);
            }
        }
    }
}

