/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SourceOfFunds;
import com.adyen.model.legalentitymanagement.WebData;
import com.adyen.model.legalentitymanagement.WebDataExemption;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BusinessLineInfo {
    public static final String SERIALIZED_NAME_CAPABILITY = "capability";
    @SerializedName(value="capability")
    private String capability;
    public static final String SERIALIZED_NAME_INDUSTRY_CODE = "industryCode";
    @SerializedName(value="industryCode")
    private String industryCode;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_ID = "legalEntityId";
    @SerializedName(value="legalEntityId")
    private String legalEntityId;
    public static final String SERIALIZED_NAME_SALES_CHANNELS = "salesChannels";
    @SerializedName(value="salesChannels")
    private List<String> salesChannels = null;
    public static final String SERIALIZED_NAME_SOURCE_OF_FUNDS = "sourceOfFunds";
    @SerializedName(value="sourceOfFunds")
    private SourceOfFunds sourceOfFunds;
    public static final String SERIALIZED_NAME_WEB_DATA = "webData";
    @SerializedName(value="webData")
    private List<WebData> webData = null;
    public static final String SERIALIZED_NAME_WEB_DATA_EXEMPTION = "webDataExemption";
    @SerializedName(value="webDataExemption")
    private WebDataExemption webDataExemption;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BusinessLineInfo capability(String capability) {
        this.capability = capability;
        return this;
    }

    @ApiModelProperty(required=true, value="The capability for which you are creating the business line. For example, **receivePayments**.")
    public String getCapability() {
        return this.capability;
    }

    public void setCapability(String capability) {
        this.capability = capability;
    }

    public BusinessLineInfo industryCode(String industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="A code that represents the industry of the legal entity. For example, **4431A** for computer software stores.")
    public String getIndustryCode() {
        return this.industryCode;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    public BusinessLineInfo legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) that owns the business line.")
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public BusinessLineInfo salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        return this;
    }

    public BusinessLineInfo addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the `capability` to **receivePayments** or **receiveFromPlatformPayments**.")
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
    }

    public BusinessLineInfo sourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        return this;
    }

    @ApiModelProperty(value="")
    public SourceOfFunds getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    public void setSourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
    }

    public BusinessLineInfo webData(List<WebData> webData) {
        this.webData = webData;
        return this;
    }

    public BusinessLineInfo addWebDataItem(WebData webDataItem) {
        if (this.webData == null) {
            this.webData = new ArrayList<WebData>();
        }
        this.webData.add(webDataItem);
        return this;
    }

    @ApiModelProperty(value="List of website URLs where your user's goods or services are sold. When this is required for a capability but your user does not have an online presence, provide the reason in the `webDataExemption` object.")
    public List<WebData> getWebData() {
        return this.webData;
    }

    public void setWebData(List<WebData> webData) {
        this.webData = webData;
    }

    public BusinessLineInfo webDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
        return this;
    }

    @ApiModelProperty(value="")
    public WebDataExemption getWebDataExemption() {
        return this.webDataExemption;
    }

    public void setWebDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessLineInfo businessLineInfo = (BusinessLineInfo)o;
        return Objects.equals(this.capability, businessLineInfo.capability) && Objects.equals(this.industryCode, businessLineInfo.industryCode) && Objects.equals(this.legalEntityId, businessLineInfo.legalEntityId) && Objects.equals(this.salesChannels, businessLineInfo.salesChannels) && Objects.equals(this.sourceOfFunds, businessLineInfo.sourceOfFunds) && Objects.equals(this.webData, businessLineInfo.webData) && Objects.equals(this.webDataExemption, businessLineInfo.webDataExemption);
    }

    public int hashCode() {
        return Objects.hash(this.capability, this.industryCode, this.legalEntityId, this.salesChannels, this.sourceOfFunds, this.webData, this.webDataExemption);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessLineInfo {\n");
        sb.append("    capability: ").append(this.toIndentedString(this.capability)).append("\n");
        sb.append("    industryCode: ").append(this.toIndentedString(this.industryCode)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString(this.sourceOfFunds)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("    webDataExemption: ").append(this.toIndentedString(this.webDataExemption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraywebData;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BusinessLineInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BusinessLineInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITY) != null && !jsonObj.get(SERIALIZED_NAME_CAPABILITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `capability` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPABILITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INDUSTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_INDUSTRY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `industryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INDUSTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `legalEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS) != null && !jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `salesChannels` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE_OF_FUNDS) != null) {
            SourceOfFunds.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE_OF_FUNDS));
        }
        if ((jsonArraywebData = jsonObj.getAsJsonArray(SERIALIZED_NAME_WEB_DATA)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_WEB_DATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `webData` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEB_DATA).toString()));
            }
            for (int i = 0; i < jsonArraywebData.size(); ++i) {
                WebData.validateJsonObject(jsonArraywebData.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA_EXEMPTION) != null) {
            WebDataExemption.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA_EXEMPTION));
        }
    }

    public static BusinessLineInfo fromJson(String jsonString) throws IOException {
        return (BusinessLineInfo)JSON.getGson().fromJson(jsonString, BusinessLineInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITY);
        openapiFields.add(SERIALIZED_NAME_INDUSTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_SALES_CHANNELS);
        openapiFields.add(SERIALIZED_NAME_SOURCE_OF_FUNDS);
        openapiFields.add(SERIALIZED_NAME_WEB_DATA);
        openapiFields.add(SERIALIZED_NAME_WEB_DATA_EXEMPTION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CAPABILITY);
        openapiRequiredFields.add(SERIALIZED_NAME_INDUSTRY_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BusinessLineInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BusinessLineInfo.class));
            return new TypeAdapter<BusinessLineInfo>(){

                public void write(JsonWriter out, BusinessLineInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BusinessLineInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BusinessLineInfo.validateJsonObject(jsonObj);
                    return (BusinessLineInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

