/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Installments {
    public static final String SERIALIZED_NAME_PLAN = "plan";
    @SerializedName(value="plan")
    private PlanEnum plan;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Integer value;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Installments plan(PlanEnum plan) {
        this.plan = plan;
        return this;
    }

    @ApiModelProperty(value="The installment plan, used for [card installments in Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan). By default, this is set to **regular**. Possible values: * **regular** * **revolving** ")
    public PlanEnum getPlan() {
        return this.plan;
    }

    public void setPlan(PlanEnum plan) {
        this.plan = plan;
    }

    public Installments value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines the number of installments. Its value needs to be greater than zero.  Usually, the maximum allowed number of installments is capped. For example, it may not be possible to split a payment in more than 24 installments. The acquirer sets this upper limit, so its value may vary.")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Installments installments = (Installments)o;
        return Objects.equals((Object)this.plan, (Object)installments.plan) && Objects.equals(this.value, installments.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Installments {\n");
        sb.append("    plan: ").append(this.toIndentedString((Object)this.plan)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Installments is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Installments` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLAN) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PLAN).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `plan` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLAN).toString()));
            }
            PlanEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PLAN).getAsString());
        }
    }

    public static Installments fromJson(String jsonString) throws IOException {
        return (Installments)JSON.getGson().fromJson(jsonString, Installments.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PLAN);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_VALUE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Installments.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Installments.class));
            return new TypeAdapter<Installments>(){

                public void write(JsonWriter out, Installments value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Installments read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Installments.validateJsonObject(jsonObj);
                    return (Installments)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlanEnum {
        REGULAR("regular"),
        REVOLVING("revolving");

        private String value;

        private PlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlanEnum fromValue(String value) {
            for (PlanEnum b : PlanEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PlanEnum> {
            public void write(JsonWriter jsonWriter, PlanEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlanEnum.fromValue(value);
            }
        }
    }
}

