/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Url;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EventUrl {
    public static final String SERIALIZED_NAME_EVENT_LOCAL_URLS = "eventLocalUrls";
    @SerializedName(value="eventLocalUrls")
    private List<Url> eventLocalUrls = null;
    public static final String SERIALIZED_NAME_EVENT_PUBLIC_URLS = "eventPublicUrls";
    @SerializedName(value="eventPublicUrls")
    private List<Url> eventPublicUrls = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EventUrl eventLocalUrls(List<Url> eventLocalUrls) {
        this.eventLocalUrls = eventLocalUrls;
        return this;
    }

    public EventUrl addEventLocalUrlsItem(Url eventLocalUrlsItem) {
        if (this.eventLocalUrls == null) {
            this.eventLocalUrls = new ArrayList<Url>();
        }
        this.eventLocalUrls.add(eventLocalUrlsItem);
        return this;
    }

    @ApiModelProperty(value="One or more local URLs to send event notifications to when using Terminal API.")
    public List<Url> getEventLocalUrls() {
        return this.eventLocalUrls;
    }

    public void setEventLocalUrls(List<Url> eventLocalUrls) {
        this.eventLocalUrls = eventLocalUrls;
    }

    public EventUrl eventPublicUrls(List<Url> eventPublicUrls) {
        this.eventPublicUrls = eventPublicUrls;
        return this;
    }

    public EventUrl addEventPublicUrlsItem(Url eventPublicUrlsItem) {
        if (this.eventPublicUrls == null) {
            this.eventPublicUrls = new ArrayList<Url>();
        }
        this.eventPublicUrls.add(eventPublicUrlsItem);
        return this;
    }

    @ApiModelProperty(value="One or more public URLs to send event notifications to when using Terminal API.")
    public List<Url> getEventPublicUrls() {
        return this.eventPublicUrls;
    }

    public void setEventPublicUrls(List<Url> eventPublicUrls) {
        this.eventPublicUrls = eventPublicUrls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventUrl eventUrl = (EventUrl)o;
        return Objects.equals(this.eventLocalUrls, eventUrl.eventLocalUrls) && Objects.equals(this.eventPublicUrls, eventUrl.eventPublicUrls);
    }

    public int hashCode() {
        return Objects.hash(this.eventLocalUrls, this.eventPublicUrls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventUrl {\n");
        sb.append("    eventLocalUrls: ").append(this.toIndentedString(this.eventLocalUrls)).append("\n");
        sb.append("    eventPublicUrls: ").append(this.toIndentedString(this.eventPublicUrls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayeventPublicUrls;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EventUrl is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `EventUrl` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArrayeventLocalUrls = jsonObj.getAsJsonArray(SERIALIZED_NAME_EVENT_LOCAL_URLS);
        if (jsonArrayeventLocalUrls != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EVENT_LOCAL_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `eventLocalUrls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_LOCAL_URLS).toString()));
            }
            for (int i = 0; i < jsonArrayeventLocalUrls.size(); ++i) {
                Url.validateJsonObject(jsonArrayeventLocalUrls.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayeventPublicUrls = jsonObj.getAsJsonArray(SERIALIZED_NAME_EVENT_PUBLIC_URLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EVENT_PUBLIC_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `eventPublicUrls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_PUBLIC_URLS).toString()));
            }
            for (int i = 0; i < jsonArrayeventPublicUrls.size(); ++i) {
                Url.validateJsonObject(jsonArrayeventPublicUrls.get(i).getAsJsonObject());
            }
        }
    }

    public static EventUrl fromJson(String jsonString) throws IOException {
        return (EventUrl)JSON.getGson().fromJson(jsonString, EventUrl.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EVENT_LOCAL_URLS);
        openapiFields.add(SERIALIZED_NAME_EVENT_PUBLIC_URLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EventUrl.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EventUrl.class));
            return new TypeAdapter<EventUrl>(){

                public void write(JsonWriter out, EventUrl value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public EventUrl read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EventUrl.validateJsonObject(jsonObj);
                    return (EventUrl)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

