/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Name;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateMerchantUserRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_GROUPS = "accountGroups";
    @SerializedName(value="accountGroups")
    private List<String> accountGroups = null;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private Name name;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = null;
    public static final String SERIALIZED_NAME_TIME_ZONE_CODE = "timeZoneCode";
    @SerializedName(value="timeZoneCode")
    private String timeZoneCode;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateMerchantUserRequest accountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
        return this;
    }

    public CreateMerchantUserRequest addAccountGroupsItem(String accountGroupsItem) {
        if (this.accountGroups == null) {
            this.accountGroups = new ArrayList<String>();
        }
        this.accountGroups.add(accountGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
    public List<String> getAccountGroups() {
        return this.accountGroups;
    }

    public void setAccountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
    }

    public CreateMerchantUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the user.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateMerchantUserRequest name(Name name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public CreateMerchantUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateMerchantUserRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CreateMerchantUserRequest timeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
        return this;
    }

    @ApiModelProperty(value="The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
    public String getTimeZoneCode() {
        return this.timeZoneCode;
    }

    public void setTimeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
    }

    public CreateMerchantUserRequest username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="The username for this user. Allowed length: 255 alphanumeric characters.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMerchantUserRequest createMerchantUserRequest = (CreateMerchantUserRequest)o;
        return Objects.equals(this.accountGroups, createMerchantUserRequest.accountGroups) && Objects.equals(this.email, createMerchantUserRequest.email) && Objects.equals(this.name, createMerchantUserRequest.name) && Objects.equals(this.roles, createMerchantUserRequest.roles) && Objects.equals(this.timeZoneCode, createMerchantUserRequest.timeZoneCode) && Objects.equals(this.username, createMerchantUserRequest.username);
    }

    public int hashCode() {
        return Objects.hash(this.accountGroups, this.email, this.name, this.roles, this.timeZoneCode, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMerchantUserRequest {\n");
        sb.append("    accountGroups: ").append(this.toIndentedString(this.accountGroups)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    timeZoneCode: ").append(this.toIndentedString(this.timeZoneCode)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateMerchantUserRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateMerchantUserRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeZoneCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static CreateMerchantUserRequest fromJson(String jsonString) throws IOException {
        return (CreateMerchantUserRequest)JSON.getGson().fromJson(jsonString, CreateMerchantUserRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_GROUPS);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE_CODE);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateMerchantUserRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateMerchantUserRequest.class));
            return new TypeAdapter<CreateMerchantUserRequest>(){

                public void write(JsonWriter out, CreateMerchantUserRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateMerchantUserRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateMerchantUserRequest.validateJsonObject(jsonObj);
                    return (CreateMerchantUserRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

