/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateCompanyApiCredentialRequest {
    public static final String SERIALIZED_NAME_ALLOWED_ORIGINS = "allowedOrigins";
    @SerializedName(value="allowedOrigins")
    private List<String> allowedOrigins = null;
    public static final String SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    @SerializedName(value="associatedMerchantAccounts")
    private List<String> associatedMerchantAccounts = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateCompanyApiCredentialRequest allowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CreateCompanyApiCredentialRequest addAllowedOriginsItem(String allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List of [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) for the new API credential.")
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public CreateCompanyApiCredentialRequest associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public CreateCompanyApiCredentialRequest addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        if (this.associatedMerchantAccounts == null) {
            this.associatedMerchantAccounts = new ArrayList<String>();
        }
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="List of merchant accounts that the API credential has access to.")
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public CreateCompanyApiCredentialRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCompanyApiCredentialRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateCompanyApiCredentialRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) of the API credential.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCompanyApiCredentialRequest createCompanyApiCredentialRequest = (CreateCompanyApiCredentialRequest)o;
        return Objects.equals(this.allowedOrigins, createCompanyApiCredentialRequest.allowedOrigins) && Objects.equals(this.associatedMerchantAccounts, createCompanyApiCredentialRequest.associatedMerchantAccounts) && Objects.equals(this.description, createCompanyApiCredentialRequest.description) && Objects.equals(this.roles, createCompanyApiCredentialRequest.roles);
    }

    public int hashCode() {
        return Objects.hash(this.allowedOrigins, this.associatedMerchantAccounts, this.description, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCompanyApiCredentialRequest {\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateCompanyApiCredentialRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateCompanyApiCredentialRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowedOrigins` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `associatedMerchantAccounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
    }

    public static CreateCompanyApiCredentialRequest fromJson(String jsonString) throws IOException {
        return (CreateCompanyApiCredentialRequest)JSON.getGson().fromJson(jsonString, CreateCompanyApiCredentialRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ORIGINS);
        openapiFields.add(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateCompanyApiCredentialRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateCompanyApiCredentialRequest.class));
            return new TypeAdapter<CreateCompanyApiCredentialRequest>(){

                public void write(JsonWriter out, CreateCompanyApiCredentialRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateCompanyApiCredentialRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateCompanyApiCredentialRequest.validateJsonObject(jsonObj);
                    return (CreateCompanyApiCredentialRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

