/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IdentificationData {
    public static final String SERIALIZED_NAME_CARD_NUMBER = "cardNumber";
    @SerializedName(value="cardNumber")
    private String cardNumber;
    public static final String SERIALIZED_NAME_EXPIRY_DATE = "expiryDate";
    @SerializedName(value="expiryDate")
    private String expiryDate;
    public static final String SERIALIZED_NAME_ISSUER_COUNTRY = "issuerCountry";
    @SerializedName(value="issuerCountry")
    private String issuerCountry;
    public static final String SERIALIZED_NAME_ISSUER_STATE = "issuerState";
    @SerializedName(value="issuerState")
    private String issuerState;
    public static final String SERIALIZED_NAME_NATIONAL_ID_EXEMPT = "nationalIdExempt";
    @SerializedName(value="nationalIdExempt")
    private Boolean nationalIdExempt;
    public static final String SERIALIZED_NAME_NUMBER = "number";
    @SerializedName(value="number")
    private String number;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IdentificationData cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @ApiModelProperty(value="The card number of the document that was issued (AU only).")
    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public IdentificationData expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The expiry date of the document, in YYYY-MM-DD format.")
    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public IdentificationData issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the document was issued. For example, **US**.")
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public IdentificationData issuerState(String issuerState) {
        this.issuerState = issuerState;
        return this;
    }

    @ApiModelProperty(value="The state or province where the document was issued (AU only).")
    public String getIssuerState() {
        return this.issuerState;
    }

    public void setIssuerState(String issuerState) {
        this.issuerState = issuerState;
    }

    public IdentificationData nationalIdExempt(Boolean nationalIdExempt) {
        this.nationalIdExempt = nationalIdExempt;
        return this;
    }

    @ApiModelProperty(value="Applies only to individuals in the US. Set to **true** if the individual does not have an SSN. To verify their identity, Adyen will require them to upload an ID document.")
    public Boolean getNationalIdExempt() {
        return this.nationalIdExempt;
    }

    public void setNationalIdExempt(Boolean nationalIdExempt) {
        this.nationalIdExempt = nationalIdExempt;
    }

    public IdentificationData number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The number in the document.")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public IdentificationData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of document, used when providing an ID number or uploading a document. The possible values depend on the legal entity type.  When providing ID numbers: * For **individual**, the `type` values can be **driversLicense**, **identityCard**, **nationalIdNumber**, or **passport**.  When uploading documents: * For **organization**, the `type` values can be **proofOfAddress**, **registrationDocument**, **vatDocument**, **proofOfOrganizationTaxInfo**, **proofOfOwnership**, or **proofOfIndustry**.   * For **individual**, the `type` values can be **identityCard**, **driversLicense**, **passport**, **proofOfNationalIdNumber**, **proofOfResidency**, **proofOfIndustry**, or **proofOfIndividualTaxId**.  * For **soleProprietorship**, the `type` values can be **constitutionalDocument**, **proofOfAddress**, or **proofOfIndustry**.  * Use **bankStatement** to upload documents for a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentificationData identificationData = (IdentificationData)o;
        return Objects.equals(this.cardNumber, identificationData.cardNumber) && Objects.equals(this.expiryDate, identificationData.expiryDate) && Objects.equals(this.issuerCountry, identificationData.issuerCountry) && Objects.equals(this.issuerState, identificationData.issuerState) && Objects.equals(this.nationalIdExempt, identificationData.nationalIdExempt) && Objects.equals(this.number, identificationData.number) && Objects.equals((Object)this.type, (Object)identificationData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumber, this.expiryDate, this.issuerCountry, this.issuerState, this.nationalIdExempt, this.number, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentificationData {\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    issuerState: ").append(this.toIndentedString(this.issuerState)).append("\n");
        sb.append("    nationalIdExempt: ").append(this.toIndentedString(this.nationalIdExempt)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IdentificationData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IdentificationData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_CARD_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cardNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRY_DATE) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRY_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiryDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRY_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuerCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_STATE) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuerState` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static IdentificationData fromJson(String jsonString) throws IOException {
        return (IdentificationData)JSON.getGson().fromJson(jsonString, IdentificationData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CARD_NUMBER);
        openapiFields.add(SERIALIZED_NAME_EXPIRY_DATE);
        openapiFields.add(SERIALIZED_NAME_ISSUER_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_ISSUER_STATE);
        openapiFields.add(SERIALIZED_NAME_NATIONAL_ID_EXEMPT);
        openapiFields.add(SERIALIZED_NAME_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IdentificationData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IdentificationData.class));
            return new TypeAdapter<IdentificationData>(){

                public void write(JsonWriter out, IdentificationData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IdentificationData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IdentificationData.validateJsonObject(jsonObj);
                    return (IdentificationData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BANKSTATEMENT("bankStatement"),
        DRIVERSLICENSE("driversLicense"),
        IDENTITYCARD("identityCard"),
        NATIONALIDNUMBER("nationalIdNumber"),
        PASSPORT("passport"),
        PROOFOFADDRESS("proofOfAddress"),
        PROOFOFNATIONALIDNUMBER("proofOfNationalIdNumber"),
        PROOFOFRESIDENCY("proofOfResidency"),
        REGISTRATIONDOCUMENT("registrationDocument"),
        VATDOCUMENT("vatDocument"),
        PROOFOFORGANIZATIONTAXINFO("proofOfOrganizationTaxInfo"),
        PROOFOFINDUSTRY("proofOfIndustry"),
        CONSTITUTIONALDOCUMENT("constitutionalDocument");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

