/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ThreeDSRequestData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AuthenticationData2 {
    public static final String SERIALIZED_NAME_ATTEMPT_AUTHENTICATION = "attemptAuthentication";
    @SerializedName(value="attemptAuthentication")
    private AttemptAuthenticationEnum attemptAuthentication;
    public static final String SERIALIZED_NAME_AUTHENTICATION_ONLY = "authenticationOnly";
    @SerializedName(value="authenticationOnly")
    private Boolean authenticationOnly = false;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUEST_DATA = "threeDSRequestData";
    @SerializedName(value="threeDSRequestData")
    private ThreeDSRequestData threeDSRequestData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AuthenticationData2 attemptAuthentication(AttemptAuthenticationEnum attemptAuthentication) {
        this.attemptAuthentication = attemptAuthentication;
        return this;
    }

    @ApiModelProperty(value="Indicates when 3D Secure authentication should be attempted. This overrides all other rules, including [Dynamic 3D Secure settings](https://docs.adyen.com/risk-management/dynamic-3d-secure).  Possible values:  * **always**: Perform 3D Secure authentication. * **never**: Don't perform 3D Secure authentication. If PSD2 SCA or other national regulations require authentication, the transaction gets declined. * **preferNo**: Do not perform 3D Secure authentication if not required by PSD2 SCA or other national regulations.")
    public AttemptAuthenticationEnum getAttemptAuthentication() {
        return this.attemptAuthentication;
    }

    public void setAttemptAuthentication(AttemptAuthenticationEnum attemptAuthentication) {
        this.attemptAuthentication = attemptAuthentication;
    }

    public AuthenticationData2 authenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
        return this;
    }

    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation. Default: *false**.")
    public Boolean getAuthenticationOnly() {
        return this.authenticationOnly;
    }

    public void setAuthenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
    }

    public AuthenticationData2 threeDSRequestData(ThreeDSRequestData threeDSRequestData) {
        this.threeDSRequestData = threeDSRequestData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSRequestData getThreeDSRequestData() {
        return this.threeDSRequestData;
    }

    public void setThreeDSRequestData(ThreeDSRequestData threeDSRequestData) {
        this.threeDSRequestData = threeDSRequestData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationData2 authenticationData2 = (AuthenticationData2)o;
        return Objects.equals((Object)this.attemptAuthentication, (Object)authenticationData2.attemptAuthentication) && Objects.equals(this.authenticationOnly, authenticationData2.authenticationOnly) && Objects.equals(this.threeDSRequestData, authenticationData2.threeDSRequestData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attemptAuthentication, this.authenticationOnly, this.threeDSRequestData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationData2 {\n");
        sb.append("    attemptAuthentication: ").append(this.toIndentedString((Object)this.attemptAuthentication)).append("\n");
        sb.append("    authenticationOnly: ").append(this.toIndentedString(this.authenticationOnly)).append("\n");
        sb.append("    threeDSRequestData: ").append(this.toIndentedString(this.threeDSRequestData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AuthenticationData2 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AuthenticationData2` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTEMPT_AUTHENTICATION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ATTEMPT_AUTHENTICATION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `attemptAuthentication` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTEMPT_AUTHENTICATION).toString()));
            }
            AttemptAuthenticationEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ATTEMPT_AUTHENTICATION).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S_REQUEST_DATA) != null) {
            ThreeDSRequestData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S_REQUEST_DATA));
        }
    }

    public static AuthenticationData2 fromJson(String jsonString) throws IOException {
        return (AuthenticationData2)JSON.getGson().fromJson(jsonString, AuthenticationData2.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTEMPT_AUTHENTICATION);
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_ONLY);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUEST_DATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AuthenticationData2.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AuthenticationData2.class));
            return new TypeAdapter<AuthenticationData2>(){

                public void write(JsonWriter out, AuthenticationData2 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AuthenticationData2 read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AuthenticationData2.validateJsonObject(jsonObj);
                    return (AuthenticationData2)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AttemptAuthenticationEnum {
        ALWAYS("always"),
        NEVER("never"),
        PREFERNO("preferNo");

        private String value;

        private AttemptAuthenticationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AttemptAuthenticationEnum fromValue(String value) {
            for (AttemptAuthenticationEnum b : AttemptAuthenticationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AttemptAuthenticationEnum> {
            public void write(JsonWriter jsonWriter, AttemptAuthenticationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AttemptAuthenticationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AttemptAuthenticationEnum.fromValue(value);
            }
        }
    }
}

