/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AchDetails {
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_NUMBER = "bankAccountNumber";
    @SerializedName(value="bankAccountNumber")
    private String bankAccountNumber;
    public static final String SERIALIZED_NAME_BANK_LOCATION_ID = "bankLocationId";
    @SerializedName(value="bankLocationId")
    private String bankLocationId;
    public static final String SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    @SerializedName(value="checkoutAttemptId")
    private String checkoutAttemptId;
    public static final String SERIALIZED_NAME_ENCRYPTED_BANK_ACCOUNT_NUMBER = "encryptedBankAccountNumber";
    @SerializedName(value="encryptedBankAccountNumber")
    private String encryptedBankAccountNumber;
    public static final String SERIALIZED_NAME_ENCRYPTED_BANK_LOCATION_ID = "encryptedBankLocationId";
    @SerializedName(value="encryptedBankLocationId")
    private String encryptedBankLocationId;
    public static final String SERIALIZED_NAME_OWNER_NAME = "ownerName";
    @SerializedName(value="ownerName")
    private String ownerName;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.ACH;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AchDetails bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank account number (without separators).")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public AchDetails bankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
        return this;
    }

    @ApiModelProperty(value="The bank routing number of the account. The field value is `nil` in most cases.")
    public String getBankLocationId() {
        return this.bankLocationId;
    }

    public void setBankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
    }

    public AchDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public AchDetails encryptedBankAccountNumber(String encryptedBankAccountNumber) {
        this.encryptedBankAccountNumber = encryptedBankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="Encrypted bank account number. The bank account number (without separators).")
    public String getEncryptedBankAccountNumber() {
        return this.encryptedBankAccountNumber;
    }

    public void setEncryptedBankAccountNumber(String encryptedBankAccountNumber) {
        this.encryptedBankAccountNumber = encryptedBankAccountNumber;
    }

    public AchDetails encryptedBankLocationId(String encryptedBankLocationId) {
        this.encryptedBankLocationId = encryptedBankLocationId;
        return this;
    }

    @ApiModelProperty(value="Encrypted location id. The bank routing number of the account. The field value is `nil` in most cases.")
    public String getEncryptedBankLocationId() {
        return this.encryptedBankLocationId;
    }

    public void setEncryptedBankLocationId(String encryptedBankLocationId) {
        this.encryptedBankLocationId = encryptedBankLocationId;
    }

    public AchDetails ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank account holder. If you submit a name with non-Latin characters, we automatically replace some of them with corresponding Latin characters to meet the FATF recommendations. For example: * \u03c712 is converted to ch12. * \u00fcA is converted to euA. * Peter M\u00f8ller is converted to Peter Mller, because banks don't accept '\u00f8'. After replacement, the ownerName must have at least three alphanumeric characters (A-Z, a-z, 0-9), and at least one of them must be a valid Latin character (A-Z, a-z). For example: * John17 - allowed. * J17 - allowed. * 171 - not allowed. * John-7 - allowed. > If provided details don't match the required format, the response returns the error message: 203 'Invalid bank account holder name'.")
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public AchDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public AchDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public AchDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="**ach**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AchDetails achDetails = (AchDetails)o;
        return Objects.equals(this.bankAccountNumber, achDetails.bankAccountNumber) && Objects.equals(this.bankLocationId, achDetails.bankLocationId) && Objects.equals(this.checkoutAttemptId, achDetails.checkoutAttemptId) && Objects.equals(this.encryptedBankAccountNumber, achDetails.encryptedBankAccountNumber) && Objects.equals(this.encryptedBankLocationId, achDetails.encryptedBankLocationId) && Objects.equals(this.ownerName, achDetails.ownerName) && Objects.equals(this.recurringDetailReference, achDetails.recurringDetailReference) && Objects.equals(this.storedPaymentMethodId, achDetails.storedPaymentMethodId) && Objects.equals((Object)this.type, (Object)achDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankAccountNumber, this.bankLocationId, this.checkoutAttemptId, this.encryptedBankAccountNumber, this.encryptedBankLocationId, this.ownerName, this.recurringDetailReference, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AchDetails {\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankLocationId: ").append(this.toIndentedString(this.bankLocationId)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    encryptedBankAccountNumber: ").append(this.toIndentedString(this.encryptedBankAccountNumber)).append("\n");
        sb.append("    encryptedBankLocationId: ").append(this.toIndentedString(this.encryptedBankLocationId)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AchDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AchDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bankAccountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_LOCATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_BANK_LOCATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bankLocationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_LOCATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checkoutAttemptId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_BANK_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_BANK_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedBankAccountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_BANK_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_BANK_LOCATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_BANK_LOCATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedBankLocationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_BANK_LOCATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ownerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static AchDetails fromJson(String jsonString) throws IOException {
        return (AchDetails)JSON.getGson().fromJson(jsonString, AchDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_BANK_LOCATION_ID);
        openapiFields.add(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_BANK_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_BANK_LOCATION_ID);
        openapiFields.add(SERIALIZED_NAME_OWNER_NAME);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AchDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AchDetails.class));
            return new TypeAdapter<AchDetails>(){

                public void write(JsonWriter out, AchDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AchDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AchDetails.validateJsonObject(jsonObj);
                    return (AchDetails)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ACH("ach");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

