/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StoredPaymentMethod {
    @SerializedName(value="brand")
    private String brand = null;
    @SerializedName(value="expiryMonth")
    private String expiryMonth = null;
    @SerializedName(value="expiryYear")
    private String expiryYear = null;
    @SerializedName(value="holderName")
    private String holderName = null;
    @SerializedName(value="iban")
    private String iban = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="lastFour")
    private String lastFour = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="networkTxReference")
    private String networkTxReference = null;
    @SerializedName(value="ownerName")
    private String ownerName = null;
    @SerializedName(value="shopperEmail")
    private String shopperEmail = null;
    @SerializedName(value="supportedShopperInteractions")
    private List<String> supportedShopperInteractions = null;
    @SerializedName(value="type")
    private String type = null;

    public StoredPaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Schema(description="The brand of the card.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public StoredPaymentMethod expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @Schema(description="The month the card expires.")
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public StoredPaymentMethod expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @Schema(description="The last two digits of the year the card expires. For example, **22** for the year 2022.")
    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public StoredPaymentMethod holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @Schema(description="The unique payment method code.")
    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public StoredPaymentMethod iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Schema(description="The IBAN of the bank account.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public StoredPaymentMethod id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="A unique identifier of this stored payment method.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StoredPaymentMethod lastFour(String lastFour) {
        this.lastFour = lastFour;
        return this;
    }

    @Schema(description="The last four digits of the PAN.")
    public String getLastFour() {
        return this.lastFour;
    }

    public void setLastFour(String lastFour) {
        this.lastFour = lastFour;
    }

    public StoredPaymentMethod name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The display name of the stored payment method.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StoredPaymentMethod networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @Schema(description="Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public StoredPaymentMethod ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Schema(description="The name of the bank account holder.")
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public StoredPaymentMethod shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @Schema(description="The shopper\u2019s email address.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public StoredPaymentMethod supportedShopperInteractions(List<String> supportedShopperInteractions) {
        this.supportedShopperInteractions = supportedShopperInteractions;
        return this;
    }

    public StoredPaymentMethod addSupportedShopperInteractionsItem(String supportedShopperInteractionsItem) {
        if (this.supportedShopperInteractions == null) {
            this.supportedShopperInteractions = new ArrayList<String>();
        }
        this.supportedShopperInteractions.add(supportedShopperInteractionsItem);
        return this;
    }

    @Schema(description="The supported shopper interactions for this stored payment method.")
    public List<String> getSupportedShopperInteractions() {
        return this.supportedShopperInteractions;
    }

    public void setSupportedShopperInteractions(List<String> supportedShopperInteractions) {
        this.supportedShopperInteractions = supportedShopperInteractions;
    }

    public StoredPaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The type of payment method.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredPaymentMethod storedPaymentMethod = (StoredPaymentMethod)o;
        return Objects.equals(this.brand, storedPaymentMethod.brand) && Objects.equals(this.expiryMonth, storedPaymentMethod.expiryMonth) && Objects.equals(this.expiryYear, storedPaymentMethod.expiryYear) && Objects.equals(this.holderName, storedPaymentMethod.holderName) && Objects.equals(this.iban, storedPaymentMethod.iban) && Objects.equals(this.id, storedPaymentMethod.id) && Objects.equals(this.lastFour, storedPaymentMethod.lastFour) && Objects.equals(this.name, storedPaymentMethod.name) && Objects.equals(this.networkTxReference, storedPaymentMethod.networkTxReference) && Objects.equals(this.ownerName, storedPaymentMethod.ownerName) && Objects.equals(this.shopperEmail, storedPaymentMethod.shopperEmail) && Objects.equals(this.supportedShopperInteractions, storedPaymentMethod.supportedShopperInteractions) && Objects.equals(this.type, storedPaymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.expiryMonth, this.expiryYear, this.holderName, this.iban, this.id, this.lastFour, this.name, this.networkTxReference, this.ownerName, this.shopperEmail, this.supportedShopperInteractions, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredPaymentMethod {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastFour: ").append(this.toIndentedString(this.lastFour)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    supportedShopperInteractions: ").append(this.toIndentedString(this.supportedShopperInteractions)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

