/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class ThreeDSRequestData {
    @SerializedName(value="nativeThreeDS")
    private NativeThreeDSEnum nativeThreeDS = null;
    @SerializedName(value="threeDSVersion")
    private ThreeDSVersionEnum threeDSVersion = null;

    public ThreeDSRequestData nativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
        this.nativeThreeDS = nativeThreeDS;
        return this;
    }

    @Schema(description="Indicates if [native 3D Secure authentication](https://docs.adyen.com/online-payments/3d-secure/native-3ds2) should be used when available.  Possible values: * **preferred**: Use native 3D Secure authentication when available.")
    public NativeThreeDSEnum getNativeThreeDS() {
        return this.nativeThreeDS;
    }

    public void setNativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
        this.nativeThreeDS = nativeThreeDS;
    }

    public ThreeDSRequestData threeDSVersion(ThreeDSVersionEnum threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @Schema(description="The version of 3D Secure to use.  Possible values:  * **2.1.0** * **2.2.0**")
    public ThreeDSVersionEnum getThreeDSVersion() {
        return this.threeDSVersion;
    }

    public void setThreeDSVersion(ThreeDSVersionEnum threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSRequestData threeDSRequestData = (ThreeDSRequestData)o;
        return Objects.equals((Object)this.nativeThreeDS, (Object)threeDSRequestData.nativeThreeDS) && Objects.equals((Object)this.threeDSVersion, (Object)threeDSRequestData.threeDSVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nativeThreeDS, this.threeDSVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSRequestData {\n");
        sb.append("    nativeThreeDS: ").append(this.toIndentedString((Object)this.nativeThreeDS)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString((Object)this.threeDSVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThreeDSVersionEnum {
        _1_0("2.1.0"),
        _2_0("2.2.0");

        @JsonValue
        private final String value;

        private ThreeDSVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThreeDSVersionEnum fromValue(String input) {
            for (ThreeDSVersionEnum b : ThreeDSVersionEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ThreeDSVersionEnum> {
            public void write(JsonWriter jsonWriter, ThreeDSVersionEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ThreeDSVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThreeDSVersionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NativeThreeDSEnum {
        PREFERRED("preferred");

        @JsonValue
        private final String value;

        private NativeThreeDSEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NativeThreeDSEnum fromValue(String input) {
            for (NativeThreeDSEnum b : NativeThreeDSEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NativeThreeDSEnum> {
            public void write(JsonWriter jsonWriter, NativeThreeDSEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public NativeThreeDSEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NativeThreeDSEnum.fromValue(value);
            }
        }
    }
}

