/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.Amount;
import com.adyen.model.Split;
import com.adyen.model.checkout.LineItem;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PaymentRefundResource {
    @SerializedName(value="amount")
    private Amount amount = null;
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    @SerializedName(value="merchantAccount")
    private String merchantAccount = null;
    @SerializedName(value="paymentPspReference")
    private String paymentPspReference = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;
    @SerializedName(value="reference")
    private String reference = null;
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="status")
    private StatusEnum status = null;

    public PaymentRefundResource amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @Schema(required=true, description="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentRefundResource lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentRefundResource addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @Schema(description="Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). > This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, Zip and Atome.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentRefundResource merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @Schema(required=true, description="The merchant account that is used to process the payment.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentRefundResource paymentPspReference(String paymentPspReference) {
        this.paymentPspReference = paymentPspReference;
        return this;
    }

    @Schema(required=true, description="The [`pspReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_pspReference) of the payment to refund. ")
    public String getPaymentPspReference() {
        return this.paymentPspReference;
    }

    public void setPaymentPspReference(String paymentPspReference) {
        this.paymentPspReference = paymentPspReference;
    }

    public PaymentRefundResource pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @Schema(required=true, description="Adyen's 16-character reference associated with the refund request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentRefundResource reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Schema(description="Your reference for the refund request.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentRefundResource splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentRefundResource addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @Schema(description="An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/platforms/processing-payments#providing-split-information).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRefundResource status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The status of your request. This will always have the value **received**.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRefundResource paymentRefundResource = (PaymentRefundResource)o;
        return Objects.equals(this.amount, paymentRefundResource.amount) && Objects.equals(this.lineItems, paymentRefundResource.lineItems) && Objects.equals(this.merchantAccount, paymentRefundResource.merchantAccount) && Objects.equals(this.paymentPspReference, paymentRefundResource.paymentPspReference) && Objects.equals(this.pspReference, paymentRefundResource.pspReference) && Objects.equals(this.reference, paymentRefundResource.reference) && Objects.equals(this.splits, paymentRefundResource.splits) && Objects.equals((Object)this.status, (Object)paymentRefundResource.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.lineItems, this.merchantAccount, this.paymentPspReference, this.pspReference, this.reference, this.splits, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRefundResource {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentPspReference: ").append(this.toIndentedString(this.paymentPspReference)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        RECEIVED("received");

        @JsonValue
        private final String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String input) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

