/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import com.adyen.Config;
import com.adyen.constants.ApiConstants;
import com.adyen.enums.Environment;
import com.adyen.httpclient.AdyenResponse;
import com.adyen.httpclient.AdyenResponseHandler;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.RequestOptions;
import com.adyen.terminal.security.TerminalCommonNameValidator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class AdyenHttpClient
implements ClientInterface {
    private static final String CHARSET = "UTF-8";
    private static final String TERMINAL_CERTIFICATE_ALIAS = "TerminalCertificate";
    private static final String SSL = "SSL";
    private static final String TLSV1_2 = "TLSv1.2";
    private Proxy proxy;

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public String request(String endpoint, String requestBody, Config config) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, false);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, isApiKeyRequired, null);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, isApiKeyRequired, requestOptions, ApiConstants.HttpMethod.POST);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, isApiKeyRequired, requestOptions, httpMethod, null);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod, Map<String, String> params) throws IOException, HTTPClientException {
        try (CloseableHttpClient httpclient = this.createCloseableHttpClient(config);){
            HttpRequestBase httpRequest = this.createRequest(endpoint, requestBody, config, isApiKeyRequired, requestOptions, httpMethod, params);
            AdyenResponse response = (AdyenResponse)httpclient.execute((HttpUriRequest)httpRequest, (ResponseHandler)new AdyenResponseHandler());
            if (response.getStatus() < 200 || response.getStatus() >= 300) {
                throw new HTTPClientException(response.getStatus(), "HTTP Exception", response.getHeaders(), response.getBody());
            }
            String string = response.getBody();
            return string;
        }
    }

    private HttpRequestBase createRequest(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod, Map<String, String> params) throws HTTPClientException {
        HttpRequestBase httpRequest = this.createHttpRequestBase(this.createUri(endpoint, params), requestBody, httpMethod);
        RequestConfig.Builder builder = RequestConfig.custom();
        if (config.getReadTimeoutMillis() > 0) {
            builder.setSocketTimeout(config.getReadTimeoutMillis());
        }
        if (config.getConnectionTimeoutMillis() > 0) {
            builder.setConnectTimeout(config.getConnectionTimeoutMillis());
        }
        if (this.proxy != null && this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.proxy.address();
            builder.setProxy(new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort()));
        }
        httpRequest.setConfig(builder.build());
        this.setAuthentication((HttpUriRequest)httpRequest, isApiKeyRequired, config);
        this.setHeaders(config, requestOptions, httpRequest);
        return httpRequest;
    }

    private void setHeaders(Config config, RequestOptions requestOptions, HttpRequestBase httpUriRequest) {
        this.setContentType((HttpUriRequest)httpUriRequest, "application/json");
        httpUriRequest.addHeader("Accept-Charset", CHARSET);
        httpUriRequest.addHeader("User-Agent", String.format("%s %s/%s", config.getApplicationName(), "adyen-java-api-library", "15.1.0"));
        if (requestOptions != null && requestOptions.getIdempotencyKey() != null) {
            httpUriRequest.addHeader("Idempotency-Key", requestOptions.getIdempotencyKey());
        }
    }

    private HttpRequestBase createHttpRequestBase(URI endpoint, String requestBody, ApiConstants.HttpMethod httpMethod) {
        StringEntity requestEntity = null;
        if (requestBody != null && !requestBody.isEmpty()) {
            requestEntity = new StringEntity(requestBody, CHARSET);
        }
        switch (httpMethod) {
            case GET: {
                return new HttpGet(endpoint);
            }
            case PATCH: {
                HttpPatch httpPatch = new HttpPatch(endpoint);
                httpPatch.setEntity((HttpEntity)requestEntity);
                return httpPatch;
            }
            case DELETE: {
                return new HttpDelete(endpoint);
            }
        }
        HttpPost httpPost = new HttpPost(endpoint);
        httpPost.setEntity((HttpEntity)requestEntity);
        return httpPost;
    }

    private URI createUri(String endpoint, Map<String, String> params) throws HTTPClientException {
        try {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            if (params != null && !params.isEmpty()) {
                for (String key : params.keySet()) {
                    uriBuilder.addParameter(key, params.get(key));
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new HTTPClientException("Invalid URI", e);
        }
    }

    private CloseableHttpClient createCloseableHttpClient(Config config) throws HTTPClientException {
        if (config.getClientKeyStore() != null && config.getTrustKeyStore() != null) {
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.getClientCertificateAuthSSLContext(config)).build();
        }
        if (config.getTerminalCertificate() != null) {
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.getTerminalCertificateSocketFactory(config)).build();
        }
        return HttpClients.createDefault();
    }

    private SSLConnectionSocketFactory getTerminalCertificateSocketFactory(Config config) throws HTTPClientException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry(TERMINAL_CERTIFICATE_ALIAS, config.getTerminalCertificate());
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(keyStore);
            TrustManager[] trustManagers = trustFactory.getTrustManagers();
            SSLContext sc = SSLContext.getInstance(SSL);
            sc.init(null, trustManagers, new SecureRandom());
            return new SSLConnectionSocketFactory(sc, this.createHostnameVerifier(config.getEnvironment()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new HTTPClientException("Error loading certificate from path", e);
        }
    }

    private SSLConnectionSocketFactory getClientCertificateAuthSSLContext(Config config) throws HTTPClientException {
        try {
            char[] password = null;
            if (config.getClientKeyStorePassword() != null && !config.getClientKeyStorePassword().isEmpty()) {
                password = config.getClientKeyStorePassword().toCharArray();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(config.getTrustKeyStore());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(config.getClientKeyStore(), password);
            SSLContext context = SSLContext.getInstance(TLSV1_2);
            context.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), null);
            return new SSLConnectionSocketFactory(context);
        }
        catch (Exception e) {
            throw new HTTPClientException("Error creating SSL Context", e);
        }
    }

    private HostnameVerifier createHostnameVerifier(Environment environment) {
        return (host, session) -> {
            try {
                if (session.getPeerCertificates() != null && session.getPeerCertificates().length > 0) {
                    X509Certificate certificate = (X509Certificate)session.getPeerCertificates()[0];
                    return TerminalCommonNameValidator.validateCertificate(certificate, environment);
                }
                return false;
            }
            catch (SSLPeerUnverifiedException e) {
                e.printStackTrace();
                return false;
            }
        };
    }

    private void setAuthentication(HttpUriRequest httpUriRequest, boolean isApiKeyRequired, Config config) {
        String apiKey = config.getApiKey();
        if (isApiKeyRequired || apiKey != null && !apiKey.isEmpty()) {
            this.setApiKey(httpUriRequest, apiKey);
        } else {
            this.setBasicAuthentication(httpUriRequest, config.getUsername(), config.getPassword());
        }
    }

    private void setContentType(HttpUriRequest httpUriRequest, String contentType) {
        httpUriRequest.addHeader("Content-Type", contentType);
    }

    private void setApiKey(HttpUriRequest httpUriRequest, String apiKey) {
        if (apiKey != null && !apiKey.isEmpty()) {
            httpUriRequest.addHeader("x-api-key", apiKey);
        }
    }

    private void setBasicAuthentication(HttpUriRequest httpUriRequest, String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        httpUriRequest.addHeader("Authorization", "Basic " + authStringEnc);
    }
}

