/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.Amount;
import com.adyen.model.FraudResult;
import com.adyen.model.ThreeDS2Result;
import com.adyen.model.checkout.CheckoutOrderResponse;
import com.adyen.model.checkout.PaymentsResponse;
import com.adyen.model.checkout.ServiceError;
import com.adyen.util.DateUtil;
import com.adyen.util.Util;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractPaymentsResponse<T extends AbstractPaymentsResponse<T>> {
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;
    @SerializedName(value="refusalReason")
    private String refusalReason = null;
    @SerializedName(value="refusalReasonCode")
    private String refusalReasonCode = null;
    @SerializedName(value="resultCode")
    private PaymentsResponse.ResultCodeEnum resultCode = null;
    @SerializedName(value="serviceError")
    private ServiceError serviceError;
    @SerializedName(value="authResponse")
    private PaymentsResponse.ResultCodeEnum authResponse;
    @SerializedName(value="merchantReference")
    private String merchantReference;
    @SerializedName(value="threeDS2Result")
    private ThreeDS2Result threeDS2Result;
    @SerializedName(value="amount")
    private Amount amount = null;
    @SerializedName(value="order")
    private CheckoutOrderResponse order = null;
    @SerializedName(value="donationToken")
    private String donationToken;

    public T additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return (T)this;
    }

    public T putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return (T)this;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public String getAdditionalDataByKey(String key) {
        if (this.additionalData == null) {
            return null;
        }
        return this.additionalData.get(key);
    }

    public T fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return (T)this;
    }

    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public T pspReference(String pspReference) {
        this.pspReference = pspReference;
        return (T)this;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public T refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return (T)this;
    }

    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public T refusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        return (T)this;
    }

    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
    }

    public T resultCode(PaymentsResponse.ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return (T)this;
    }

    public PaymentsResponse.ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(PaymentsResponse.ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public ServiceError getServiceError() {
        return this.serviceError;
    }

    public void setServiceError(ServiceError serviceError) {
        this.serviceError = serviceError;
    }

    public PaymentsResponse.ResultCodeEnum getAuthResponse() {
        return this.authResponse;
    }

    public void setAuthResponse(PaymentsResponse.ResultCodeEnum authResponse) {
        this.authResponse = authResponse;
    }

    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
    }

    public T threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        return (T)this;
    }

    public T amount(Amount amount) {
        this.amount = amount;
        return (T)this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public T order(CheckoutOrderResponse order) {
        this.order = order;
        return (T)this;
    }

    public CheckoutOrderResponse getOrder() {
        return this.order;
    }

    public void setOrder(CheckoutOrderResponse order) {
        this.order = order;
    }

    public String getDonationToken() {
        return this.donationToken;
    }

    public void setDonationToken(String donationToken) {
        this.donationToken = donationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPaymentsResponse response = (AbstractPaymentsResponse)o;
        return Objects.equals(this.additionalData, response.additionalData) && Objects.equals(this.fraudResult, response.fraudResult) && Objects.equals(this.pspReference, response.pspReference) && Objects.equals(this.refusalReason, response.refusalReason) && Objects.equals(this.refusalReasonCode, response.refusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)response.resultCode) && Objects.equals(this.serviceError, response.serviceError) && Objects.equals((Object)this.authResponse, (Object)response.authResponse) && Objects.equals(this.merchantReference, response.merchantReference) && Objects.equals(this.threeDS2Result, response.threeDS2Result) && Objects.equals(this.amount, response.amount) && Objects.equals(this.order, response.order) && Objects.equals(this.donationToken, response.donationToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.fraudResult, this.pspReference, this.refusalReason, this.resultCode, this.serviceError, this.authResponse, this.merchantReference, this.threeDS2Result, this.amount, this.order, this.donationToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    additionalData: ").append(Util.toIndentedString(this.additionalData)).append("\n");
        sb.append("    fraudResult: ").append(Util.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    pspReference: ").append(Util.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(Util.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(Util.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(Util.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    serviceError: ").append(Util.toIndentedString(this.serviceError)).append("\n");
        sb.append("    authResponse: ").append(Util.toIndentedString((Object)this.authResponse)).append("\n");
        sb.append("    merchantReference: ").append(Util.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    threeDS2Result: ").append(Util.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    amount: ").append(Util.toIndentedString(this.amount)).append("\n");
        sb.append("    order: ").append(Util.toIndentedString(this.order)).append("\n");
        sb.append("    donationToken: ").append(Util.toIndentedString(this.donationToken)).append("\n");
        return sb.toString();
    }

    public String getCardBin() {
        return this.getAdditionalDataByKey("cardBin");
    }

    public String getCardHolderName() {
        return this.getAdditionalDataByKey("cardHolderName");
    }

    public String getCardSummary() {
        return this.getAdditionalDataByKey("cardSummary");
    }

    public String getPaymentMethod() {
        return this.getAdditionalDataByKey("paymentMethod");
    }

    public String getAvsResult() {
        return this.getAdditionalDataByKey("avsResult");
    }

    public boolean get3DOffered() {
        return "true".equals(this.getAdditionalDataByKey("threeDOffered"));
    }

    public boolean get3DAuthenticated() {
        return "true".equals(this.getAdditionalDataByKey("threeDAuthenticated"));
    }

    public String getAuthCode() {
        return this.getAdditionalDataByKey("authCode");
    }

    public Date getExpiryDate() {
        String expiryDate = this.getAdditionalDataByKey("expiryDate");
        return DateUtil.parseMYDate(expiryDate);
    }
}

