/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.Address;
import com.adyen.model.marketpay.BankAccountDetail;
import com.adyen.model.marketpay.BankAccountDetailContainer;
import com.adyen.model.marketpay.BusinessDetails;
import com.adyen.model.marketpay.IndividualDetails;
import com.adyen.model.marketpay.PhoneNumber;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountHolderDetails {
    @SerializedName(value="metadata")
    private Map<String, String> metadata = new HashMap<String, String>();
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="phoneNumber")
    private PhoneNumber phoneNumber = null;
    @SerializedName(value="bankAccountDetails")
    private List<BankAccountDetailContainer> bankAccountDetailContainers = null;
    private transient List<BankAccountDetail> bankAccountDetails = null;
    @SerializedName(value="individualDetails")
    private IndividualDetails individualDetails = null;
    @SerializedName(value="webAddress")
    private String webAddress = null;
    @SerializedName(value="merchantCategoryCode")
    private String merchantCategoryCode = null;
    @SerializedName(value="fullPhoneNumber")
    private String fullPhoneNumber = null;
    @SerializedName(value="businessDetails")
    private BusinessDetails businessDetails = null;
    @SerializedName(value="email")
    private String email = null;

    public AccountHolderDetails metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public AccountHolderDetails putMetadataItem(String key, String metadataItem) {
        this.metadata.put(key, metadataItem);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public AccountHolderDetails address(Address address) {
        this.address = address;
        return this;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public AccountHolderDetails phoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public List<BankAccountDetail> getBankAccountDetails() {
        if (this.bankAccountDetails == null) {
            this.bankAccountDetails = new ArrayList<BankAccountDetail>();
            if (this.bankAccountDetailContainers != null && !this.bankAccountDetailContainers.isEmpty()) {
                for (BankAccountDetailContainer bankAccountDetailContainer : this.bankAccountDetailContainers) {
                    this.bankAccountDetails.add(bankAccountDetailContainer.getBankAccountDetail());
                }
            }
        }
        return this.bankAccountDetails;
    }

    public void setBankAccountDetails(List<BankAccountDetail> bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
        this.bankAccountDetailContainers = new ArrayList<BankAccountDetailContainer>();
        for (BankAccountDetail bankAccountDetail : bankAccountDetails) {
            BankAccountDetailContainer bankAccountDetailContainer = new BankAccountDetailContainer(bankAccountDetail);
            this.bankAccountDetailContainers.add(bankAccountDetailContainer);
        }
    }

    public AccountHolderDetails addBankAccountDetail(BankAccountDetail bankAccountDetail) {
        BankAccountDetailContainer bankAccountDetailContainer = new BankAccountDetailContainer(bankAccountDetail);
        if (this.bankAccountDetailContainers == null) {
            this.bankAccountDetailContainers = new ArrayList<BankAccountDetailContainer>();
        }
        this.bankAccountDetailContainers.add(bankAccountDetailContainer);
        if (this.bankAccountDetails == null) {
            this.bankAccountDetails = new ArrayList<BankAccountDetail>();
        }
        this.bankAccountDetails.add(bankAccountDetail);
        return this;
    }

    public AccountHolderDetails individualDetails(IndividualDetails individualDetails) {
        this.individualDetails = individualDetails;
        return this;
    }

    public IndividualDetails getIndividualDetails() {
        return this.individualDetails;
    }

    public void setIndividualDetails(IndividualDetails individualDetails) {
        this.individualDetails = individualDetails;
    }

    public AccountHolderDetails webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public AccountHolderDetails merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public AccountHolderDetails fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public AccountHolderDetails businessDetails(BusinessDetails businessDetails) {
        this.businessDetails = businessDetails;
        return this;
    }

    public BusinessDetails getBusinessDetails() {
        return this.businessDetails;
    }

    public void setBusinessDetails(BusinessDetails businessDetails) {
        this.businessDetails = businessDetails;
    }

    public AccountHolderDetails email(String email) {
        this.email = email;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderDetails accountHolderDetails = (AccountHolderDetails)o;
        return Objects.equals(this.metadata, accountHolderDetails.metadata) && Objects.equals(this.address, accountHolderDetails.address) && Objects.equals(this.phoneNumber, accountHolderDetails.phoneNumber) && Objects.equals(this.bankAccountDetailContainers, accountHolderDetails.bankAccountDetailContainers) && Objects.equals(this.individualDetails, accountHolderDetails.individualDetails) && Objects.equals(this.webAddress, accountHolderDetails.webAddress) && Objects.equals(this.merchantCategoryCode, accountHolderDetails.merchantCategoryCode) && Objects.equals(this.fullPhoneNumber, accountHolderDetails.fullPhoneNumber) && Objects.equals(this.businessDetails, accountHolderDetails.businessDetails) && Objects.equals(this.email, accountHolderDetails.email);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.address, this.phoneNumber, this.bankAccountDetailContainers, this.individualDetails, this.webAddress, this.merchantCategoryCode, this.fullPhoneNumber, this.businessDetails, this.email);
    }

    public String toString() {
        this.getBankAccountDetails();
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderDetails {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    bankAccountDetails: ").append(this.toIndentedString(this.bankAccountDetails)).append("\n");
        sb.append("    individualDetails: ").append(this.toIndentedString(this.individualDetails)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    businessDetails: ").append(this.toIndentedString(this.businessDetails)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

