/*
 * Decompiled with CFR 0.152.
 */
package com.adups.trace;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Trace {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = 7;
    private static int s_level;
    private static boolean s_show_code_position;
    private static boolean s_write_file;
    private static int offset;
    private static String m_log_path;
    private static int s_log_size;
    private static String global_tag;

    public static void setShowPosition(boolean showPosition) {
        s_show_code_position = showPosition;
    }

    private static void println(int level, String tag, String message) {
        if (level >= s_level) {
            if (s_write_file) {
                Trace.write_log(tag, message);
            }
            if (s_show_code_position) {
                message = message + Trace.getCodePosition();
            }
            Trace.printAndroidLog(level, global_tag + tag, message);
        }
    }

    private static void printAndroidLog(int level, String tag, String message) {
        switch (level) {
            case 2: {
                Log.v((String)tag, (String)message);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)message);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)message);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)message);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)message);
            }
        }
    }

    public static void setLevel(int level) {
        s_level = level;
    }

    public static void write_file(boolean write_file) {
        s_write_file = write_file;
    }

    public static void setLog_size(int log_size) {
        s_log_size = log_size;
    }

    public static void setLog_path(String m_log_path) {
        Trace.m_log_path = m_log_path;
    }

    public static void v(String tag, String msg) {
        Trace.println(2, tag, msg);
    }

    public static void d(String tag, String msg) {
        Trace.println(3, tag, msg);
    }

    public static void d(String tag, String msg, Object ... args) {
        Trace.println(3, tag, String.format(msg, args));
    }

    public static void i(String tag, String msg) {
        Trace.println(4, tag, msg);
    }

    public static void i(String tag, String msg, Object ... args) {
        Trace.println(4, tag, String.format(msg, args));
    }

    public static void w(String tag, String msg, Object ... args) {
        Trace.println(5, tag, String.format(msg, args));
    }

    public static void w(String tag, String msg) {
        Trace.println(5, tag, msg);
    }

    public static void e(String tag, String msg) {
        Trace.println(6, tag, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Trace.println(6, tag, msg + '\n' + Trace.getStackTraceString(tr));
    }

    public static void e(String tag, Throwable tr) {
        Trace.println(6, tag, Trace.getStackTraceString(tr));
    }

    public static <T> void array(String tag, T[] array) {
        offset = 1;
        if (array == null) {
            Trace.e(tag, "array is null");
        } else {
            Trace.d(tag, Arrays.toString(array));
        }
    }

    public static void list(String tag, List<?> lists) {
        offset = 1;
        if (lists == null) {
            Trace.e(tag, "lists is null");
        } else {
            int iMax = lists.size() - 1;
            if (iMax == -1) {
                Trace.d(tag, "{}");
            }
            StringBuilder b = new StringBuilder();
            b.append('{');
            for (int i = 0; i < lists.size(); ++i) {
                b.append(String.valueOf(lists.get(i)));
                if (i == iMax) {
                    b.append('}');
                }
                b.append(", ");
            }
            Trace.d(tag, b.toString());
        }
    }

    public static void json(String tag, String json) {
        offset = 1;
        if (TextUtils.isEmpty((CharSequence)json)) {
            Trace.e(tag, "Empty/Null json content");
            return;
        }
        try {
            json = json.trim();
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(2);
                Trace.d(tag, message);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(2);
                Trace.d(tag, message);
                return;
            }
            Trace.e(tag, "Invalid Json");
        }
        catch (JSONException e) {
            Trace.e(tag, "Invalid Json");
        }
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static String getCodePosition() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 5 + offset;
        offset = 0;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        return String.format(".(%s:%s) %s()", className, lineNumber, methodName);
    }

    private static boolean check_log_file() {
        File log_file = new File(m_log_path);
        if (!log_file.exists()) {
            boolean mkdirs;
            if (!log_file.getParentFile().exists() && !(mkdirs = log_file.getParentFile().mkdirs())) {
                Log.e((String)global_tag, (String)Trace.getStackTraceString(new IOException("Can't create the directory of trace. Place check the trace path.")));
                return false;
            }
            try {
                log_file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)"Trace", (String)Trace.getStackTraceString(e));
                return false;
            }
        } else if (log_file.length() > (long)(1024 * s_log_size)) {
            log_file.renameTo(new File(m_log_path + "(1)"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write_log(String tag, String msg) {
        File log_file = new File(m_log_path);
        if (!Trace.check_log_file()) {
            return;
        }
        String text = Trace.getFormatLog(tag, msg);
        FileOutputStream fos = null;
        try {
            boolean append = log_file.length() <= (long)(1024 * s_log_size);
            fos = new FileOutputStream(log_file, append);
            fos.write(text.getBytes());
            fos.write("\n".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getFormatLog(String tag, String msg) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String dateStr = sdf.format(new Date());
        return dateStr + " " + String.format("%s ", Trace.convertThreadId((int)Thread.currentThread().getId())) + String.format("%s: ", tag) + msg;
    }

    private static String convertThreadId(int value) {
        int limit = 5;
        String src = String.valueOf(value);
        int i = limit - src.length();
        if (i < 0) {
            src = src.substring(-i, src.length());
        }
        while (i > 0) {
            src = "0" + src;
            --i;
        }
        return src;
    }

    static {
        s_log_size = 500;
        s_level = 7;
        s_show_code_position = false;
        s_write_file = true;
        global_tag = "iport/";
        m_log_path = Environment.getExternalStorageDirectory() + "/iport_log.txt";
    }
}

