/*
 * Decompiled with CFR 0.152.
 */
package com.adups.trace;

import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Trace {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = 7;
    private static int s_level;
    private static boolean s_show_code_position;
    private static boolean s_write_file;
    private static String m_log_path;
    private static int s_log_size;

    public static void setShowPosition(boolean showPosition) {
        s_show_code_position = showPosition;
    }

    private static void println(int level, String tag, String message) {
        if (level >= s_level) {
            if (s_show_code_position) {
                message = message + Trace.getCodePosition();
            }
            Trace.printAndroidLog(level, "iport/" + tag, message);
            if (s_write_file) {
                Trace.write_log(tag, message);
            }
        }
    }

    private static void printAndroidLog(int level, String tag, String message) {
        switch (level) {
            case 2: {
                Log.v((String)tag, (String)message);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)message);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)message);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)message);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)message);
            }
        }
    }

    public static void setLevel(int level) {
        s_level = level;
    }

    public static void write_file(boolean write_file) {
        s_write_file = write_file;
    }

    public static void setLog_size(int log_size) {
        s_log_size = log_size;
    }

    public static void setLog_path(String m_log_path) {
        Trace.m_log_path = m_log_path;
    }

    public static void v(String tag, String msg) {
        Trace.println(2, tag, msg);
    }

    public static void v(String tag, String msg, Throwable tr) {
        Trace.println(2, tag, msg + '\n' + Trace.getStackTraceString(tr));
    }

    public static void d(String tag, String msg) {
        Trace.println(3, tag, msg);
    }

    public static void d(String tag, String msg, Throwable tr) {
        Trace.println(3, tag, msg + '\n' + Trace.getStackTraceString(tr));
    }

    public static void i(String tag, String msg) {
        Trace.println(4, tag, msg);
    }

    public static void i(String tag, String msg, Throwable tr) {
        Trace.println(4, tag, msg + '\n' + Trace.getStackTraceString(tr));
    }

    public static void w(String tag, String msg) {
        Trace.println(5, tag, msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        Trace.println(5, tag, msg + '\n' + Trace.getStackTraceString(tr));
    }

    public static void w(String tag, Throwable tr) {
        Trace.println(5, tag, Trace.getStackTraceString(tr));
    }

    public static void e(String tag, String msg) {
        Trace.println(6, tag, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Trace.println(6, tag, msg + '\n' + Trace.getStackTraceString(tr));
    }

    public static void e(String tag, Throwable tr) {
        Trace.println(6, tag, Trace.getStackTraceString(tr));
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static String getCodePosition() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 5;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        return String.format(".(%s:%s) %s()", className, lineNumber, methodName);
    }

    private static boolean check_log_file() {
        File log_file = new File(m_log_path);
        if (!log_file.exists()) {
            if (!log_file.getParentFile().exists()) {
                log_file.getParentFile().mkdirs();
            }
            try {
                log_file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        } else if (log_file.length() > (long)(1024 * s_log_size)) {
            log_file.renameTo(new File(m_log_path + "(1)"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write_log(String tag, String msg) {
        String text = Trace.getFormatLog(tag, msg);
        File log_file = new File(m_log_path);
        if (!Trace.check_log_file()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            boolean append = log_file.length() <= (long)(1024 * s_log_size);
            fos = new FileOutputStream(log_file, append);
            fos.write(text.getBytes());
            fos.write("\n".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getFormatLog(String tag, String msg) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
        String dateStr = sdf.format(new Date());
        return dateStr + " " + String.format("%s ", Trace.convertThreadId((int)Thread.currentThread().getId())) + String.format("%s: ", tag) + msg;
    }

    private static String convertThreadId(int value) {
        int limit = 5;
        String src = String.valueOf(value);
        int i = limit - src.length();
        if (i < 0) {
            src = src.substring(-i, src.length());
        }
        while (i > 0) {
            src = "0" + src;
            --i;
        }
        return src;
    }

    static {
        s_log_size = 500;
        s_level = 7;
        s_show_code_position = false;
        s_write_file = true;
        m_log_path = Environment.getExternalStorageDirectory() + "/iport_log.txt";
    }
}

