/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.mqtt_service;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.v4.content.LocalBroadcastManager;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.connect.NetUtils;
import com.abupdate.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.abupdate.mqtt_libs.mqtt_service.d;
import com.abupdate.mqtt_libs.mqtt_service.e;
import com.abupdate.mqtt_libs.mqtt_service.f;
import com.abupdate.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.MqttMessage;
import com.abupdate.mqtt_libs.mqttv3.g;
import com.abupdate.mqtt_libs.mqttv3.h;
import com.abupdate.mqtt_libs.mqttv3.j;
import com.abupdate.mqtt_libs.mqttv3.l;
import com.abupdate.trace.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressLint(value={"Registered"})
public class MqttService
extends Service
implements MqttTraceHandler {
    static final String TAG = "MqttService";
    private String traceCallbackId;
    private boolean traceEnabled = false;
    com.abupdate.mqtt_libs.mqtt_service.c messageStore;
    private c networkConnectionMonitor;
    private a backgroundDataPreferenceMonitor;
    private volatile boolean backgroundDataEnabled = true;
    private e mqttServiceBinder;
    private Map<String, d> connections = new ConcurrentHashMap<String, d>();
    private AlarmManager mAm;
    private PendingIntent operation;
    private static final String ACTION_ALARM_KEEP_CONNECT = "ACTION_ALARM_KEEP_CONNECT";
    private b keepConnectReceiver;
    private SimpleDateFormat simpleDateFormat;
    private long keepConnectRepeatTime;

    void callbackToActivity(String string, f f2, Bundle bundle) {
        Intent intent = new Intent("MqttService.callbackToActivity.v0");
        if (string != null) {
            intent.putExtra("MqttService.clientHandle", string);
        }
        intent.putExtra("MqttService.callbackStatus", (Serializable)((Object)f2));
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    public String getClient(String string, String string2, String string3, g g2) {
        String string4 = string + ":" + string2 + ":" + string3;
        if (!this.connections.containsKey(string4)) {
            d d2 = new d(this, string, string2, g2, string4);
            this.connections.put(string4, d2);
        }
        return string4;
    }

    public void connect(String string, h h2, String string2, String string3) throws l, MqttException {
        d d2 = this.getConnection(string);
        d2.a(h2, null, string3);
    }

    void reconnect() {
        this.traceDebug(TAG, "Reconnect to server, client size=" + this.connections.size());
        for (d d2 : this.connections.values()) {
            this.traceDebug("Reconnect Client:", d2.b() + '/' + d2.a());
            if (!this.isOnline()) continue;
            d2.g();
        }
    }

    public void close(String string) {
        d d2 = this.getConnection(string);
        d2.c();
    }

    public void disconnect(String string, String string2, String string3) {
        d d2 = this.getConnection(string);
        d2.a(string2, string3);
        this.connections.remove(string);
        this.stopSelf();
    }

    public void disconnect(String string, long l2, String string2, String string3) {
        d d2 = this.getConnection(string);
        d2.a(l2, string2, string3);
        this.connections.remove(string);
        this.stopSelf();
    }

    public boolean isConnected(String string) {
        d d2 = this.getConnection(string);
        return d2.d();
    }

    public IMqttDeliveryToken publish(String string, String string2, byte[] byArray, int n2, boolean bl, String string3, String string4) throws j, MqttException {
        d d2 = this.getConnection(string);
        return d2.a(string2, byArray, n2, bl, string3, string4);
    }

    public IMqttDeliveryToken publish(String string, String string2, MqttMessage mqttMessage, String string3, String string4) throws j, MqttException {
        d d2 = this.getConnection(string);
        return d2.a(string2, mqttMessage, string3, string4);
    }

    public void subscribe(String string, String string2, int n2, String string3, String string4) {
        d d2 = this.getConnection(string);
        d2.a(string2, n2, string3, string4);
    }

    public void subscribe(String string, String[] stringArray, int[] nArray, String string2, String string3) {
        d d2 = this.getConnection(string);
        d2.a(stringArray, nArray, string2, string3);
    }

    public void subscribe(String string, String[] stringArray, int[] nArray, String string2, String string3, com.abupdate.mqtt_libs.mqttv3.d[] dArray) {
        d d2 = this.getConnection(string);
        d2.a(stringArray, nArray, string2, string3, dArray);
    }

    public void unsubscribe(String string, String string2, String string3, String string4) {
        d d2 = this.getConnection(string);
        d2.a(string2, string3, string4);
    }

    public void unsubscribe(String string, String[] stringArray, String string2, String string3) {
        d d2 = this.getConnection(string);
        d2.a(stringArray, string2, string3);
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens(String string) {
        d d2 = this.getConnection(string);
        return d2.e();
    }

    private d getConnection(String string) {
        d d2 = this.connections.get(string);
        if (d2 == null) {
            throw new IllegalArgumentException("Invalid ClientHandle");
        }
        return d2;
    }

    public f acknowledgeMessageArrival(String string, String string2) {
        if (this.messageStore.a(string, string2)) {
            return f.a;
        }
        return f.b;
    }

    public void stopKeepConnect() {
        if (null == this.mAm || null == this.operation) {
            return;
        }
        this.mAm.cancel(this.operation);
    }

    public AlarmManager startKeepConnect(long l2, long l3) {
        Trace.d((String)TAG, (String)("startKeepConnect() repeat time:" + ((float)l2 + 0.0f) / 1000.0f / 60.0f + "min,next time:" + this.getFormateTime(l3)));
        this.operation = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent(ACTION_ALARM_KEEP_CONNECT), (int)0x10000000);
        this.mAm = (AlarmManager)this.getSystemService("alarm");
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAm.setWindow(0, l3, 5000L, this.operation);
            this.keepConnectRepeatTime = l2;
        } else {
            this.mAm.setRepeating(0, l3, l2, this.operation);
        }
        return this.mAm;
    }

    public void onCreate() {
        super.onCreate();
        this.mqttServiceBinder = new e(this);
        this.messageStore = new com.abupdate.mqtt_libs.mqtt_service.b(this, (Context)this);
    }

    public void onDestroy() {
        for (d d2 : this.connections.values()) {
            d2.a((String)null, (String)null);
        }
        if (this.mqttServiceBinder != null) {
            this.mqttServiceBinder = null;
        }
        this.unregisterBroadcastReceivers();
        if (this.messageStore != null) {
            this.messageStore.a();
        }
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        String string = intent.getStringExtra("MqttService.activityToken");
        this.mqttServiceBinder.a(string);
        return this.mqttServiceBinder;
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        this.registerBroadcastReceivers();
        return 1;
    }

    public void setTraceCallbackId(String string) {
        this.traceCallbackId = string;
    }

    public void setTraceEnabled(boolean bl) {
        this.traceEnabled = bl;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void traceDebug(String string, String string2) {
        this.traceCallback("debug", string, string2);
    }

    @Override
    public void traceError(String string, String string2) {
        this.traceCallback("error", string, string2);
    }

    private void traceCallback(String string, String string2, String string3) {
        if (this.traceCallbackId != null && this.traceEnabled) {
            Bundle bundle = new Bundle();
            bundle.putString("MqttService.callbackAction", "trace");
            bundle.putString("MqttService.traceSeverity", string);
            bundle.putString("MqttService.traceTag", string2);
            bundle.putString("MqttService.errorMessage", string3);
            this.callbackToActivity(this.traceCallbackId, f.b, bundle);
        }
    }

    @Override
    public void traceException(String string, String string2, Exception exception) {
        if (this.traceCallbackId != null) {
            Bundle bundle = new Bundle();
            bundle.putString("MqttService.callbackAction", "trace");
            bundle.putString("MqttService.traceSeverity", "exception");
            bundle.putString("MqttService.errorMessage", string2);
            bundle.putSerializable("MqttService.exception", (Serializable)exception);
            bundle.putString("MqttService.traceTag", string);
            this.callbackToActivity(this.traceCallbackId, f.b, bundle);
        }
    }

    private void registerBroadcastReceivers() {
        if (this.networkConnectionMonitor == null) {
            this.networkConnectionMonitor = new c();
            this.registerReceiver(this.networkConnectionMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
            this.backgroundDataEnabled = connectivityManager.getBackgroundDataSetting();
            if (this.backgroundDataPreferenceMonitor == null) {
                this.backgroundDataPreferenceMonitor = new a();
                this.registerReceiver(this.backgroundDataPreferenceMonitor, new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED"));
            }
        }
        if (this.keepConnectReceiver == null) {
            this.keepConnectReceiver = new b();
            this.registerReceiver(this.keepConnectReceiver, new IntentFilter(ACTION_ALARM_KEEP_CONNECT));
        }
    }

    private void unregisterBroadcastReceivers() {
        if (this.networkConnectionMonitor != null) {
            this.unregisterReceiver(this.networkConnectionMonitor);
            this.networkConnectionMonitor = null;
        }
        if (Build.VERSION.SDK_INT < 14 && this.backgroundDataPreferenceMonitor != null) {
            this.unregisterReceiver(this.backgroundDataPreferenceMonitor);
        }
        if (this.keepConnectReceiver != null) {
            this.unregisterReceiver(this.keepConnectReceiver);
        }
    }

    public boolean isOnline() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected() && this.backgroundDataEnabled;
    }

    private void notifyClientsOffline() {
        for (d d2 : this.connections.values()) {
            d2.f();
        }
    }

    public boolean containClient(String string) {
        return this.connections.containsKey(string);
    }

    public void setBufferOpts(String string, com.abupdate.mqtt_libs.mqttv3.b b2) {
        d d2 = this.getConnection(string);
        d2.a(b2);
    }

    public int getBufferedMessageCount(String string) {
        d d2 = this.getConnection(string);
        return d2.h();
    }

    public MqttMessage getBufferedMessage(String string, int n2) {
        d d2 = this.getConnection(string);
        return d2.a(n2);
    }

    public void deleteBufferedMessage(String string, int n2) {
        d d2 = this.getConnection(string);
        d2.b(n2);
    }

    private String getFormateTime(long l2) {
        if (null == this.simpleDateFormat) {
            this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.simpleDateFormat.format(l2);
    }

    private class b
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "ACTION_ALARM_KEEP_CONNECT": {
                    Trace.d((String)MqttService.TAG, (String)"onReceive() receive alarm_connect_engine's message");
                    if (MqttManager.getInstance().isConnected()) {
                        Trace.d((String)MqttService.TAG, (String)"onReceive() socket have connected");
                        MqttService.this.stopKeepConnect();
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 19 && null != MqttService.this.mAm && null != MqttService.this.operation) {
                        MqttService.this.mAm.setWindow(0, System.currentTimeMillis() + MqttService.this.keepConnectRepeatTime, 5000L, MqttService.this.operation);
                    }
                    if (NetUtils.isNetWorkAvailable()) {
                        Trace.d((String)MqttService.TAG, (String)"onReceive() try to reconnect");
                        MqttService.this.reconnect();
                        break;
                    }
                    Trace.d((String)MqttService.TAG, (String)"onReceive() The current network is not available");
                }
            }
        }
    }

    private class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager connectivityManager = (ConnectivityManager)MqttService.this.getSystemService("connectivity");
            MqttService.this.traceDebug(MqttService.TAG, "Reconnect since BroadcastReceiver.");
            if (connectivityManager.getBackgroundDataSetting()) {
                if (!MqttService.this.backgroundDataEnabled) {
                    MqttService.this.backgroundDataEnabled = true;
                    MqttService.this.reconnect();
                }
            } else {
                MqttService.this.backgroundDataEnabled = false;
                MqttService.this.notifyClientsOffline();
            }
        }
    }

    private class c
    extends BroadcastReceiver {
        private c() {
        }

        @SuppressLint(value={"Wakelock"})
        public void onReceive(Context context, Intent intent) {
            MqttService.this.traceDebug(MqttService.TAG, "Internal network status receive.");
            PowerManager powerManager = (PowerManager)MqttService.this.getSystemService("power");
            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "MQTT");
            wakeLock.acquire();
            MqttService.this.traceDebug(MqttService.TAG, "Reconnect for Network recovery.");
            if (MqttService.this.isOnline()) {
                MqttService.this.traceDebug(MqttService.TAG, "Online,reconnect.");
                MqttService.this.reconnect();
            } else {
                MqttService.this.notifyClientsOffline();
            }
            wakeLock.release();
        }
    }
}

