/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.connect;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.abupdate.mqtt_libs.connect.Command;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.connect.Utils;
import com.abupdate.mqtt_libs.mqtt_service.MqttAndroidClient;
import com.abupdate.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.abupdate.mqtt_libs.mqttv3.IMqttActionListener;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.h;
import com.abupdate.mqtt_libs.mqttv3.l;
import com.abupdate.trace.Trace;
import java.io.InputStream;

public class ConnectCommand
implements Command {
    private static final String TAG = "ConnectCommand";
    private String mServer;
    private int mPort;
    private String lastWillMsg;
    private String lastWillTopic;
    private int mTimeout;
    private int mKeepAlive;
    private String mUserName;
    private String mUserPassword;
    private boolean mCleanSession;
    private String mClientId;
    private String mSslKeyPath;
    private String mSslKeyPassword;
    private MqttAndroidClient client;
    private int lastWillQos;
    private boolean lastWillRetained;
    private MqttCallback mMessageListener;
    private boolean traceEnabled = false;
    private MqttTraceHandler mTraceCallback;
    private static ConnectCommand connectCommand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectCommand getInstance() {
        if (connectCommand != null) return connectCommand;
        Class<ConnectCommand> clazz = ConnectCommand.class;
        synchronized (ConnectCommand.class) {
            if (connectCommand != null) return connectCommand;
            connectCommand = new ConnectCommand();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectCommand;
        }
    }

    public ConnectCommand setClientId(String string) {
        this.mClientId = string;
        return this;
    }

    public ConnectCommand setServer(String string) {
        this.mServer = string;
        return this;
    }

    public ConnectCommand setPort(int n2) {
        this.mPort = n2;
        return this;
    }

    public ConnectCommand setLastWill(String string, String string2, int n2, boolean bl) {
        this.lastWillMsg = string;
        this.lastWillTopic = string2;
        this.lastWillQos = n2;
        this.lastWillRetained = bl;
        return this;
    }

    public ConnectCommand setTimeout(int n2) {
        this.mTimeout = n2;
        return this;
    }

    public ConnectCommand setKeepAlive(int n2) {
        this.mKeepAlive = n2;
        return this;
    }

    public ConnectCommand setCleanSession(boolean bl) {
        this.mCleanSession = bl;
        return this;
    }

    public ConnectCommand setUserNameAndPassword(String string, String string2) {
        this.mUserName = string;
        this.mUserPassword = string2;
        return this;
    }

    public MqttAndroidClient getClient() {
        return this.client;
    }

    public ConnectCommand setSsl(String string, String string2) {
        this.mSslKeyPath = string;
        this.mSslKeyPassword = string2;
        return this;
    }

    public ConnectCommand setTraceEnabled(boolean bl) {
        this.traceEnabled = bl;
        return this;
    }

    public ConnectCommand setTraceCallback(MqttTraceHandler mqttTraceHandler) {
        this.mTraceCallback = mqttTraceHandler;
        return this;
    }

    public void setMessageListener(MqttCallback mqttCallback) {
        this.mMessageListener = mqttCallback;
    }

    public void connect() {
    }

    private String getUri() {
        String string = TextUtils.isEmpty((CharSequence)this.mSslKeyPath) ? "tcp://" : "ssl://";
        string = string + this.mServer + ":" + this.mPort;
        return string;
    }

    private MqttAndroidClient createClient(Context context, String string, String string2) {
        MqttAndroidClient mqttAndroidClient = new MqttAndroidClient(context, string, string2);
        return mqttAndroidClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IMqttActionListener iMqttActionListener) throws MqttException {
        h h2 = new h();
        String string = this.getUri();
        if (null == this.client) {
            this.client = this.createClient(MqttManager.sCx, string, this.mClientId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSslKeyPath)) {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(this.mSslKeyPath);
                h2.a(this.client.getSSLSocketFactory(inputStream, this.mSslKeyPassword));
            }
            catch (l l2) {
                try {
                    Log.e((String)this.getClass().getCanonicalName(), (String)"MqttException Occured: ", (Throwable)l2);
                }
                catch (Throwable throwable) {
                    Utils.closeIO(inputStream);
                    throw throwable;
                }
                Utils.closeIO(inputStream);
            }
            Utils.closeIO(inputStream);
        }
        h2.a(this.mCleanSession);
        h2.b(this.mTimeout);
        h2.a(this.mKeepAlive);
        if (!TextUtils.isEmpty((CharSequence)this.mUserName)) {
            h2.a(this.mUserName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserPassword)) {
            h2.a(this.mUserPassword.toCharArray());
        }
        boolean bl = true;
        if (!TextUtils.isEmpty((CharSequence)this.lastWillMsg) || !TextUtils.isEmpty((CharSequence)this.lastWillTopic)) {
            try {
                h2.a(this.lastWillTopic, this.lastWillMsg.getBytes(), this.lastWillQos, this.lastWillRetained);
            }
            catch (Exception exception) {
                Trace.d((String)TAG, (String)("connect() Exception Occured\uff1a" + exception.toString()));
                bl = false;
            }
        }
        this.client.setCallback(this.mMessageListener);
        if (this.traceEnabled) {
            this.client.setTraceCallback(this.mTraceCallback);
        }
        if (bl) {
            try {
                this.client.connect(h2, null, iMqttActionListener);
            }
            catch (MqttException mqttException) {
                Trace.d((String)TAG, (String)("connect() MqttException Occured:" + mqttException.toString()));
            }
        }
    }
}

