/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.connect;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.connect.ShellUtils;

public class NetUtils {
    public static final String NETWORN_NONE = "no";
    public static final String NETWORN_WIFI = "WIFI";
    public static final String NETWORN_2G = "2G";
    public static final String NETWORN_3G = "3G";
    public static final String NETWORN_4G = "4G";
    public static final String NETWORN_MOBILE = "mobile";

    public static boolean isNetWorkAvailable() {
        boolean bl = NetUtils.isAvailableBySystem() || NetUtils.isAvailableByPing(null);
        return bl;
    }

    private static boolean isAvailableBySystem() {
        boolean bl = false;
        if (null == MqttManager.sCx) {
            return bl;
        }
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)MqttManager.sCx.getSystemService("connectivity");
            if (connectivityManager == null) {
                return bl;
            }
            NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
            if (networkInfoArray == null) {
                return bl;
            }
            for (int i2 = 0; i2 < networkInfoArray.length && networkInfoArray[i2] != null; ++i2) {
                if (!networkInfoArray[i2].isConnected() || !networkInfoArray[i2].isAvailable()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            Log.d((String)"NetUtils", (String)"isNetWorkAvailable: not available");
        }
        return bl;
    }

    private static boolean isAvailableByPing(String string) {
        boolean bl;
        if (string == null || string.length() <= 0) {
            string = "223.5.5.5";
        }
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(String.format("ping -c 1 -w 1 %s", string), false);
        boolean bl2 = bl = commandResult.result == 0;
        if (commandResult.errorMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + commandResult.errorMsg));
        }
        if (commandResult.successMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + commandResult.successMsg));
        }
        return bl;
    }

    public static String getNetworkState(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connectivityManager) {
            return NETWORN_NONE;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isAvailable()) {
            return NETWORN_NONE;
        }
        NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(1);
        if (null != networkInfo2 && null != (state = networkInfo2.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return NETWORN_WIFI;
        }
        state = connectivityManager.getNetworkInfo(0);
        if (null != state) {
            NetworkInfo.State state2 = state.getState();
            String string = state.getSubtypeName();
            if (null != state2 && (state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING)) {
                switch (networkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return NETWORN_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return NETWORN_3G;
                    }
                    case 13: {
                        return NETWORN_4G;
                    }
                }
                if ("TD-SCDMA".equalsIgnoreCase(string) || "WCDMA".equalsIgnoreCase(string) || "CDMA2000".equalsIgnoreCase(string)) {
                    return NETWORN_3G;
                }
                return NETWORN_MOBILE;
            }
        }
        return NETWORN_NONE;
    }
}

