/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.mqtt_service;

import com.abupdate.mqtt_libs.mqtt_service.MqttAndroidClient;
import com.abupdate.mqtt_libs.mqttv3.IMqttActionListener;
import com.abupdate.mqtt_libs.mqttv3.IMqttToken;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.a.c.u;
import com.abupdate.mqtt_libs.mqttv3.c;
import com.abupdate.mqtt_libs.mqttv3.l;

class MqttTokenAndroid
implements IMqttToken {
    private IMqttActionListener listener;
    private volatile boolean isComplete;
    private volatile MqttException lastException;
    private Object waitObject = new Object();
    private MqttAndroidClient client;
    private Object userContext;
    private String[] topics;
    private IMqttToken delegate;
    private MqttException pendingException;

    MqttTokenAndroid(MqttAndroidClient mqttAndroidClient, Object object, IMqttActionListener iMqttActionListener) {
        this(mqttAndroidClient, object, iMqttActionListener, null);
    }

    MqttTokenAndroid(MqttAndroidClient mqttAndroidClient, Object object, IMqttActionListener iMqttActionListener, String[] stringArray) {
        this.client = mqttAndroidClient;
        this.userContext = object;
        this.listener = iMqttActionListener;
        this.topics = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() throws MqttException, l {
        Object object = this.waitObject;
        synchronized (object) {
            try {
                this.waitObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.pendingException != null) {
            throw this.pendingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion(long l2) throws MqttException, l {
        Object object = this.waitObject;
        synchronized (object) {
            try {
                this.waitObject.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isComplete) {
                throw new MqttException(32000);
            }
            if (this.pendingException != null) {
                throw this.pendingException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyComplete() {
        Object object = this.waitObject;
        synchronized (object) {
            this.isComplete = true;
            this.waitObject.notifyAll();
            if (this.listener != null) {
                this.listener.onSuccess(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailure(Throwable throwable) {
        Object object = this.waitObject;
        synchronized (object) {
            this.isComplete = true;
            this.pendingException = throwable instanceof MqttException ? (MqttException)throwable : new MqttException(throwable);
            this.waitObject.notifyAll();
            if (throwable instanceof MqttException) {
                this.lastException = (MqttException)throwable;
            }
            if (this.listener != null) {
                this.listener.onFailure(this, throwable);
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    void setComplete(boolean bl) {
        this.isComplete = bl;
    }

    @Override
    public MqttException getException() {
        return this.lastException;
    }

    void setException(MqttException mqttException) {
        this.lastException = mqttException;
    }

    @Override
    public c getClient() {
        return this.client;
    }

    @Override
    public void setActionCallback(IMqttActionListener iMqttActionListener) {
        this.listener = iMqttActionListener;
    }

    @Override
    public IMqttActionListener getActionCallback() {
        return this.listener;
    }

    @Override
    public String[] getTopics() {
        if (this.topics == null) {
            return this.delegate.getTopics();
        }
        return this.topics;
    }

    @Override
    public void setUserContext(Object object) {
        this.userContext = object;
    }

    @Override
    public Object getUserContext() {
        return this.userContext;
    }

    void setDelegate(IMqttToken iMqttToken) {
        this.delegate = iMqttToken;
    }

    @Override
    public int getMessageId() {
        return this.delegate != null ? this.delegate.getMessageId() : 0;
    }

    @Override
    public u getResponse() {
        return this.delegate.getResponse();
    }

    @Override
    public boolean getSessionPresent() {
        return this.delegate.getSessionPresent();
    }

    @Override
    public int[] getGrantedQos() {
        return this.delegate.getGrantedQos();
    }
}

