/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.mqtt_service;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.v4.content.LocalBroadcastManager;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.connect.NetUtils;
import com.abupdate.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.abupdate.mqtt_libs.mqtt_service.e;
import com.abupdate.mqtt_libs.mqtt_service.g;
import com.abupdate.mqtt_libs.mqtt_service.l;
import com.abupdate.mqtt_libs.mqtt_service.o;
import com.abupdate.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.MqttMessage;
import com.abupdate.mqtt_libs.mqttv3.d;
import com.abupdate.mqtt_libs.mqttv3.h;
import com.abupdate.mqtt_libs.mqttv3.k;
import com.abupdate.mqtt_libs.mqttv3.m;
import com.abupdate.trace.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressLint(value={"Registered"})
public class MqttService
extends Service
implements MqttTraceHandler {
    static final String TAG = "MqttService";
    private String traceCallbackId;
    private boolean traceEnabled = false;
    e messageStore;
    private c networkConnectionMonitor;
    private a backgroundDataPreferenceMonitor;
    private volatile boolean backgroundDataEnabled = true;
    private l mqttServiceBinder;
    private Map<String, g> connections = new ConcurrentHashMap<String, g>();
    private AlarmManager mAm;
    private PendingIntent operation;
    private static final String ACTION_ALARM_KEEP_CONNECT = "ACTION_ALARM_KEEP_CONNECT";
    private b keepConnectReceiver;
    private SimpleDateFormat simpleDateFormat;
    private long keepConnectRepeatTime;

    void callbackToActivity(String string, o o2, Bundle bundle) {
        Intent intent = new Intent("MqttService.callbackToActivity.v0");
        if (string != null) {
            intent.putExtra("MqttService.clientHandle", string);
        }
        intent.putExtra("MqttService.callbackStatus", (Serializable)((Object)o2));
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    public String getClient(String object, String string, String string2, com.abupdate.mqtt_libs.mqttv3.g g2) {
        string2 = (String)object + ":" + string + ":" + string2;
        if (!this.connections.containsKey(string2)) {
            object = new g(this, (String)object, string, g2, string2);
            this.connections.put(string2, (g)object);
        }
        return string2;
    }

    public void connect(String string, h h2, String string2, String string3) throws m, MqttException {
        this.getConnection(string).a(h2, string3);
    }

    void reconnect() {
        this.traceDebug(TAG, "Reconnect to server, client size=" + this.connections.size());
        for (g g2 : this.connections.values()) {
            this.traceDebug("Reconnect Client:", g2.b() + '/' + g2.a());
            if (!this.isOnline()) continue;
            g2.g();
        }
    }

    public void close(String string) {
        this.getConnection(string).c();
    }

    public void disconnect(String string, String string2, String string3) {
        this.getConnection(string).a(string2, string3);
        this.connections.remove(string);
        this.stopSelf();
    }

    public void disconnect(String string, long l2, String string2, String string3) {
        this.getConnection(string).a(l2, string2, string3);
        this.connections.remove(string);
        this.stopSelf();
    }

    public boolean isConnected(String string) {
        return this.getConnection(string).d();
    }

    public IMqttDeliveryToken publish(String string, String string2, byte[] byArray, int n2, boolean bl, String string3, String string4) throws k, MqttException {
        return this.getConnection(string).a(string2, byArray, n2, bl, string3, string4);
    }

    public IMqttDeliveryToken publish(String string, String string2, MqttMessage mqttMessage, String string3, String string4) throws k, MqttException {
        return this.getConnection(string).a(string2, mqttMessage, string3, string4);
    }

    public void subscribe(String string, String string2, int n2, String string3, String string4) {
        this.getConnection(string).a(string2, n2, string3, string4);
    }

    public void subscribe(String string, String[] stringArray, int[] nArray, String string2, String string3) {
        this.getConnection(string).a(stringArray, nArray, string2, string3);
    }

    public void subscribe(String string, String[] stringArray, int[] nArray, String string2, String string3, d[] dArray) {
        this.getConnection(string).a(stringArray, nArray, string2, string3, dArray);
    }

    public void unsubscribe(String string, String string2, String string3, String string4) {
        this.getConnection(string).a(string2, string3, string4);
    }

    public void unsubscribe(String string, String[] stringArray, String string2, String string3) {
        this.getConnection(string).a(stringArray, string2, string3);
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens(String string) {
        return this.getConnection(string).e();
    }

    private g getConnection(String object) {
        if ((object = this.connections.get(object)) == null) {
            throw new IllegalArgumentException("Invalid ClientHandle");
        }
        return object;
    }

    public o acknowledgeMessageArrival(String string, String string2) {
        if (this.messageStore.a(string, string2)) {
            return o.a;
        }
        return o.b;
    }

    public void stopKeepConnect() {
        if (this.mAm == null || this.operation == null) {
            return;
        }
        this.mAm.cancel(this.operation);
    }

    public AlarmManager startKeepConnect(long l2, long l3) {
        Trace.d((String)TAG, (String)("startKeepConnect() repeat time:" + ((float)l2 + 0.0f) / 1000.0f / 60.0f + "min,next time:" + this.getFormateTime(l3)));
        this.operation = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent(ACTION_ALARM_KEEP_CONNECT), (int)0x10000000);
        this.mAm = (AlarmManager)this.getSystemService("alarm");
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAm.setWindow(0, l3, 5000L, this.operation);
            this.keepConnectRepeatTime = l2;
        } else {
            this.mAm.setRepeating(0, l3, l2, this.operation);
        }
        return this.mAm;
    }

    public void onCreate() {
        super.onCreate();
        this.mqttServiceBinder = new l(this);
        this.messageStore = new com.abupdate.mqtt_libs.mqtt_service.c(this, (Context)this);
    }

    public void onDestroy() {
        Iterator<g> iterator = this.connections.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().a((String)null, (String)null);
        }
        if (this.mqttServiceBinder != null) {
            this.mqttServiceBinder = null;
        }
        this.unregisterBroadcastReceivers();
        if (this.messageStore != null) {
            this.messageStore.a();
        }
        super.onDestroy();
    }

    public IBinder onBind(Intent object) {
        object = object.getStringExtra("MqttService.activityToken");
        this.mqttServiceBinder.a((String)object);
        return this.mqttServiceBinder;
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        this.registerBroadcastReceivers();
        return 1;
    }

    public void setTraceCallbackId(String string) {
        this.traceCallbackId = string;
    }

    public void setTraceEnabled(boolean bl) {
        this.traceEnabled = bl;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void traceDebug(String string, String string2) {
        this.traceCallback("debug", string, string2);
    }

    @Override
    public void traceError(String string, String string2) {
        this.traceCallback("error", string, string2);
    }

    private void traceCallback(String string, String string2, String string3) {
        if (this.traceCallbackId != null && this.traceEnabled) {
            Bundle bundle = new Bundle();
            bundle.putString("MqttService.callbackAction", "trace");
            bundle.putString("MqttService.traceSeverity", string);
            bundle.putString("MqttService.traceTag", string2);
            bundle.putString("MqttService.errorMessage", string3);
            this.callbackToActivity(this.traceCallbackId, o.b, bundle);
        }
    }

    @Override
    public void traceException(String string, String string2, Exception exception) {
        if (this.traceCallbackId != null) {
            Bundle bundle = new Bundle();
            bundle.putString("MqttService.callbackAction", "trace");
            bundle.putString("MqttService.traceSeverity", "exception");
            bundle.putString("MqttService.errorMessage", string2);
            bundle.putSerializable("MqttService.exception", (Serializable)exception);
            bundle.putString("MqttService.traceTag", string);
            this.callbackToActivity(this.traceCallbackId, o.b, bundle);
        }
    }

    private void registerBroadcastReceivers() {
        if (this.networkConnectionMonitor == null) {
            this.networkConnectionMonitor = new c(0);
            this.registerReceiver(this.networkConnectionMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
            this.backgroundDataEnabled = connectivityManager.getBackgroundDataSetting();
            if (this.backgroundDataPreferenceMonitor == null) {
                this.backgroundDataPreferenceMonitor = new a(0);
                this.registerReceiver(this.backgroundDataPreferenceMonitor, new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED"));
            }
        }
        if (this.keepConnectReceiver == null) {
            this.keepConnectReceiver = new b();
            this.registerReceiver(this.keepConnectReceiver, new IntentFilter(ACTION_ALARM_KEEP_CONNECT));
        }
    }

    private void unregisterBroadcastReceivers() {
        if (this.networkConnectionMonitor != null) {
            this.unregisterReceiver(this.networkConnectionMonitor);
            this.networkConnectionMonitor = null;
        }
        if (Build.VERSION.SDK_INT < 14 && this.backgroundDataPreferenceMonitor != null) {
            this.unregisterReceiver(this.backgroundDataPreferenceMonitor);
        }
        if (this.keepConnectReceiver != null) {
            this.unregisterReceiver(this.keepConnectReceiver);
        }
    }

    public boolean isOnline() {
        NetworkInfo networkInfo = ((ConnectivityManager)this.getSystemService("connectivity")).getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected() && this.backgroundDataEnabled;
    }

    private void notifyClientsOffline() {
        Iterator<g> iterator = this.connections.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().f();
        }
    }

    public boolean containClient(String string) {
        return this.connections.containsKey(string);
    }

    public void setBufferOpts(String string, com.abupdate.mqtt_libs.mqttv3.b b2) {
        this.getConnection(string).a(b2);
    }

    public int getBufferedMessageCount(String string) {
        return this.getConnection(string).h();
    }

    public MqttMessage getBufferedMessage(String string, int n2) {
        return this.getConnection(string).a(n2);
    }

    public void deleteBufferedMessage(String string, int n2) {
        this.getConnection(string).b(n2);
    }

    private String getFormateTime(long l2) {
        if (this.simpleDateFormat == null) {
            this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.simpleDateFormat.format(l2);
    }

    private final class b
    extends BroadcastReceiver {
        public final void onReceive(Context object, Intent intent) {
            switch (intent.getAction()) {
                case "ACTION_ALARM_KEEP_CONNECT": {
                    Trace.d((String)MqttService.TAG, (String)"onReceive() receive alarm_connect_engine's message");
                    if (MqttManager.getInstance().isConnected()) {
                        Trace.d((String)MqttService.TAG, (String)"onReceive() socket have connected");
                        MqttService.this.stopKeepConnect();
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 19 && null != MqttService.this.mAm && null != MqttService.this.operation) {
                        MqttService.this.mAm.setWindow(0, System.currentTimeMillis() + MqttService.this.keepConnectRepeatTime, 5000L, MqttService.this.operation);
                    }
                    if (NetUtils.isNetWorkAvailable()) {
                        Trace.d((String)MqttService.TAG, (String)"onReceive() try to reconnect");
                        MqttService.this.reconnect();
                        return;
                    }
                    Trace.d((String)MqttService.TAG, (String)"onReceive() The current network is not available");
                }
            }
        }
    }

    private final class a
    extends BroadcastReceiver {
        private a() {
        }

        public final void onReceive(Context context, Intent intent) {
            context = (ConnectivityManager)MqttService.this.getSystemService("connectivity");
            MqttService.this.traceDebug(MqttService.TAG, "Reconnect since BroadcastReceiver.");
            if (context.getBackgroundDataSetting()) {
                if (!MqttService.this.backgroundDataEnabled) {
                    MqttService.this.backgroundDataEnabled = true;
                    MqttService.this.reconnect();
                    return;
                }
            } else {
                MqttService.this.backgroundDataEnabled = false;
                MqttService.this.notifyClientsOffline();
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    private final class c
    extends BroadcastReceiver {
        private c() {
        }

        @SuppressLint(value={"Wakelock"})
        public final void onReceive(Context context, Intent intent) {
            MqttService.this.traceDebug(MqttService.TAG, "Internal network status receive.");
            context = ((PowerManager)MqttService.this.getSystemService("power")).newWakeLock(1, "MQTT");
            context.acquire();
            MqttService.this.traceDebug(MqttService.TAG, "Reconnect for Network recovery.");
            if (MqttService.this.isOnline()) {
                MqttService.this.traceDebug(MqttService.TAG, "Online,reconnect.");
                MqttService.this.reconnect();
            } else {
                MqttService.this.notifyClientsOffline();
            }
            context.release();
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }
}

