/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.mqttv3;

public class MqttMessage {
    private boolean mutable = true;
    private byte[] payload;
    private int qos = 1;
    private boolean retained = false;
    private boolean dup = false;
    private int messageId;

    public static void validateQos(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException();
        }
    }

    public MqttMessage() {
        this.setPayload(new byte[0]);
    }

    public MqttMessage(byte[] byArray) {
        this.setPayload(byArray);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void clearPayload() {
        this.checkMutable();
        this.payload = new byte[0];
    }

    public void setPayload(byte[] byArray) {
        this.checkMutable();
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.payload = byArray;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean bl) {
        this.checkMutable();
        this.retained = bl;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int n2) {
        this.checkMutable();
        MqttMessage.validateQos(n2);
        this.qos = n2;
    }

    public String toString() {
        return new String(this.payload);
    }

    protected void setMutable(boolean bl) {
        this.mutable = bl;
    }

    protected void checkMutable() throws IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
    }

    protected void setDuplicate(boolean bl) {
        this.dup = bl;
    }

    public boolean isDuplicate() {
        return this.dup;
    }

    public void setId(int n2) {
        this.messageId = n2;
    }

    public int getId() {
        return this.messageId;
    }
}

