/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.mqtt_service;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import com.abupdate.mqtt_libs.mqtt_service.MqttService;
import com.abupdate.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.abupdate.mqtt_libs.mqtt_service.ParcelableMqttMessage;
import com.abupdate.mqtt_libs.mqtt_service.f;
import com.abupdate.mqtt_libs.mqtt_service.k;
import com.abupdate.mqtt_libs.mqtt_service.l;
import com.abupdate.mqtt_libs.mqtt_service.m;
import com.abupdate.mqtt_libs.mqtt_service.o;
import com.abupdate.mqtt_libs.mqttv3.IMqttActionListener;
import com.abupdate.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.abupdate.mqtt_libs.mqttv3.IMqttToken;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.MqttMessage;
import com.abupdate.mqtt_libs.mqttv3.c;
import com.abupdate.mqtt_libs.mqttv3.d;
import com.abupdate.mqtt_libs.mqttv3.g;
import com.abupdate.mqtt_libs.mqttv3.h;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class MqttAndroidClient
extends BroadcastReceiver
implements c {
    private static final String SERVICE_NAME = "com.abupdate.mqtt_libs.mqtt_service.MqttService";
    private static final int BIND_SERVICE_FLAG = 0;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private final b serviceConnection = new b(0);
    private MqttService mqttService;
    private String clientHandle;
    private Context myContext;
    private final SparseArray<IMqttToken> tokenMap = new SparseArray();
    private int tokenNumber = 0;
    private final String serverURI;
    private final String clientId;
    private g persistence = null;
    private h connectOptions;
    private IMqttToken connectToken;
    private MqttCallback callback;
    private MqttTraceHandler traceCallback;
    private final a messageAck;
    private boolean traceEnabled = false;
    private volatile boolean receiverRegistered = false;
    private volatile boolean bindedService = false;

    public MqttAndroidClient(Context context, String string, String string2) {
        this(context, string, string2, null, a.a);
    }

    public MqttAndroidClient(Context context, String string, String string2, a a2) {
        this(context, string, string2, null, a2);
    }

    public MqttAndroidClient(Context context, String string, String string2, g g2) {
        this(context, string, string2, g2, a.a);
    }

    public MqttAndroidClient(Context context, String string, String string2, g g2, a a2) {
        this.myContext = context;
        this.serverURI = string;
        this.clientId = string2;
        this.persistence = g2;
        this.messageAck = a2;
    }

    public boolean isConnected() {
        return this.clientHandle != null && this.mqttService != null && this.mqttService.isConnected(this.clientHandle);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        if (this.mqttService != null) {
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.close(this.clientHandle);
        }
    }

    public IMqttToken connect() throws MqttException {
        return this.connect(null, null);
    }

    public IMqttToken connect(h h2) throws MqttException {
        return this.connect(h2, null, null);
    }

    public IMqttToken connect(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        return this.connect(new h(), object, iMqttActionListener);
    }

    public IMqttToken connect(h h2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        object = new m(this, object, iMqttActionListener);
        this.connectOptions = h2;
        this.connectToken = object;
        if (this.mqttService == null) {
            h2 = new Intent();
            h2.setClassName(this.myContext, SERVICE_NAME);
            if (this.myContext.startService((Intent)h2) == null && (iMqttActionListener = object.getActionCallback()) != null) {
                iMqttActionListener.onFailure((IMqttToken)object, new RuntimeException("cannot start service com.abupdate.mqtt_libs.mqtt_service.MqttService"));
            }
            this.myContext.bindService((Intent)h2, (ServiceConnection)this.serviceConnection, 1);
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        } else {
            pool.execute(new f(this));
        }
        return object;
    }

    private void registerReceiver(BroadcastReceiver broadcastReceiver) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("MqttService.callbackToActivity.v0");
        LocalBroadcastManager.getInstance((Context)this.myContext).registerReceiver(broadcastReceiver, intentFilter);
        this.receiverRegistered = true;
    }

    private void doConnect() {
        if (this.clientHandle == null) {
            this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
        }
        this.mqttService.setTraceEnabled(this.traceEnabled);
        this.mqttService.setTraceCallbackId(this.clientHandle);
        String string = this.storeToken(this.connectToken);
        try {
            this.mqttService.connect(this.clientHandle, this.connectOptions, null, string);
            return;
        }
        catch (MqttException mqttException) {
            IMqttActionListener iMqttActionListener = this.connectToken.getActionCallback();
            if (iMqttActionListener != null) {
                iMqttActionListener.onFailure(this.connectToken, mqttException);
            }
            return;
        }
    }

    public IMqttToken disconnect() throws MqttException {
        m m2 = new m(this, null, null);
        String string = this.storeToken(m2);
        this.mqttService.disconnect(this.clientHandle, null, string);
        return m2;
    }

    public IMqttToken disconnect(long l2) throws MqttException {
        m m2 = new m(this, null, null);
        String string = this.storeToken(m2);
        this.mqttService.disconnect(this.clientHandle, l2, null, string);
        return m2;
    }

    public IMqttToken disconnect(Object object, IMqttActionListener object2) throws MqttException {
        object = new m(this, object, (IMqttActionListener)object2);
        object2 = this.storeToken((IMqttToken)object);
        this.mqttService.disconnect(this.clientHandle, null, (String)object2);
        return object;
    }

    public IMqttToken disconnect(long l2, Object object, IMqttActionListener object2) throws MqttException {
        object = new m(this, object, (IMqttActionListener)object2);
        object2 = this.storeToken((IMqttToken)object);
        this.mqttService.disconnect(this.clientHandle, l2, null, (String)object2);
        return object;
    }

    public IMqttDeliveryToken publish(String string, byte[] byArray, int n2, boolean bl) throws MqttException, com.abupdate.mqtt_libs.mqttv3.k {
        return this.publish(string, byArray, n2, bl, null, null);
    }

    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage) throws MqttException, com.abupdate.mqtt_libs.mqttv3.k {
        return this.publish(string, mqttMessage, null, null);
    }

    public IMqttDeliveryToken publish(String object, byte[] byArray, int n2, boolean bl, Object object2, IMqttActionListener object3) throws MqttException, com.abupdate.mqtt_libs.mqttv3.k {
        MqttMessage mqttMessage = new MqttMessage(byArray);
        mqttMessage.setQos(n2);
        mqttMessage.setRetained(bl);
        object2 = new k(this, object2, (IMqttActionListener)object3, mqttMessage);
        object3 = this.storeToken((IMqttToken)object2);
        object = this.mqttService.publish(this.clientHandle, (String)object, byArray, n2, bl, null, (String)object3);
        ((m)object2).a((IMqttToken)object);
        return object2;
    }

    public IMqttDeliveryToken publish(String object, MqttMessage mqttMessage, Object object2, IMqttActionListener object3) throws MqttException, com.abupdate.mqtt_libs.mqttv3.k {
        object2 = new k(this, object2, (IMqttActionListener)object3, mqttMessage);
        object3 = this.storeToken((IMqttToken)object2);
        object = this.mqttService.publish(this.clientHandle, (String)object, mqttMessage, null, (String)object3);
        ((m)object2).a((IMqttToken)object);
        return object2;
    }

    public IMqttToken subscribe(String string, int n2) throws MqttException, com.abupdate.mqtt_libs.mqttv3.m {
        return this.subscribe(string, n2, null, null);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray) throws MqttException, com.abupdate.mqtt_libs.mqttv3.m {
        return this.subscribe(stringArray, nArray, null, null);
    }

    public IMqttToken subscribe(String string, int n2, Object object, IMqttActionListener object2) throws MqttException {
        object = new m(this, object, (IMqttActionListener)object2, new String[]{string});
        object2 = this.storeToken((IMqttToken)object);
        this.mqttService.subscribe(this.clientHandle, string, n2, null, (String)object2);
        return object;
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener object2) throws MqttException {
        object = new m(this, object, (IMqttActionListener)object2, stringArray);
        object2 = this.storeToken((IMqttToken)object);
        this.mqttService.subscribe(this.clientHandle, stringArray, nArray, null, (String)object2);
        return object;
    }

    public IMqttToken subscribe(String string, int n2, Object object, IMqttActionListener iMqttActionListener, d d2) throws MqttException {
        return this.subscribe(new String[]{string}, new int[]{n2}, object, iMqttActionListener, new d[]{d2});
    }

    public IMqttToken subscribe(String string, int n2, d d2) throws MqttException {
        return this.subscribe(string, n2, null, null, d2);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, d[] dArray) throws MqttException {
        return this.subscribe(stringArray, nArray, null, null, dArray);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener, d[] dArray) throws MqttException {
        object = new m(this, object, iMqttActionListener, stringArray);
        object = this.storeToken((IMqttToken)object);
        this.mqttService.subscribe(this.clientHandle, stringArray, nArray, null, (String)object, dArray);
        return null;
    }

    public IMqttToken unsubscribe(String string) throws MqttException {
        return this.unsubscribe(string, null, null);
    }

    public IMqttToken unsubscribe(String[] stringArray) throws MqttException {
        return this.unsubscribe(stringArray, null, null);
    }

    public IMqttToken unsubscribe(String string, Object object, IMqttActionListener object2) throws MqttException {
        object = new m(this, object, (IMqttActionListener)object2);
        object2 = this.storeToken((IMqttToken)object);
        this.mqttService.unsubscribe(this.clientHandle, string, null, (String)object2);
        return object;
    }

    public IMqttToken unsubscribe(String[] stringArray, Object object, IMqttActionListener object2) throws MqttException {
        object = new m(this, object, (IMqttActionListener)object2);
        object2 = this.storeToken((IMqttToken)object);
        this.mqttService.unsubscribe(this.clientHandle, stringArray, null, (String)object2);
        return object;
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.mqttService.getPendingDeliveryTokens(this.clientHandle);
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback = mqttCallback;
    }

    public void setTraceCallback(MqttTraceHandler mqttTraceHandler) {
        this.traceCallback = mqttTraceHandler;
    }

    public void setTraceEnabled(boolean bl) {
        this.traceEnabled = bl;
        if (this.mqttService != null) {
            this.mqttService.setTraceEnabled(bl);
        }
    }

    public void onReceive(Context context, Intent object) {
        context = object.getExtras();
        if ((object = context.getString("MqttService.clientHandle")) == null || !((String)object).equals(this.clientHandle)) {
            return;
        }
        object = context.getString("MqttService.callbackAction");
        if ("connect".equals(object)) {
            this.connectAction((Bundle)context);
            return;
        }
        if ("connectExtended".equals(object)) {
            this.connectExtendedAction((Bundle)context);
            return;
        }
        if ("messageArrived".equals(object)) {
            this.messageArrivedAction((Bundle)context);
            return;
        }
        if ("subscribe".equals(object)) {
            this.subscribeAction((Bundle)context);
            return;
        }
        if ("unsubscribe".equals(object)) {
            this.unSubscribeAction((Bundle)context);
            return;
        }
        if ("send".equals(object)) {
            this.sendAction((Bundle)context);
            return;
        }
        if ("messageDelivered".equals(object)) {
            this.messageDeliveredAction((Bundle)context);
            return;
        }
        if ("onConnectionLost".equals(object)) {
            this.connectionLostAction((Bundle)context);
            return;
        }
        if ("disconnect".equals(object)) {
            this.disconnected((Bundle)context);
            return;
        }
        if ("trace".equals(object)) {
            this.traceAction((Bundle)context);
            return;
        }
        this.mqttService.traceError("MqttService", "Callback action doesn't exist.");
    }

    public boolean acknowledgeMessage(String string) {
        if (this.messageAck == a.b) {
            return this.mqttService.acknowledgeMessageArrival(this.clientHandle, string) == o.a;
        }
        return false;
    }

    public void messageArrivedComplete(int n2, int n3) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void setManualAcks(boolean bl) {
        throw new UnsupportedOperationException();
    }

    private void connectAction(Bundle bundle) {
        IMqttToken iMqttToken = this.connectToken;
        this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void disconnected(Bundle object) {
        this.clientHandle = null;
        if ((object = this.removeMqttToken((Bundle)object)) != null) {
            ((m)object).a();
        }
        if (this.callback != null) {
            this.callback.connectionLost(null);
        }
    }

    private void connectionLostAction(Bundle object) {
        if (this.callback != null) {
            object = (Exception)object.getSerializable("MqttService.exception");
            this.callback.connectionLost((Throwable)object);
        }
    }

    private void connectExtendedAction(Bundle object) {
        if (this.callback instanceof com.abupdate.mqtt_libs.mqttv3.f) {
            boolean bl = object.getBoolean("MqttService.reconnect", false);
            object = object.getString("MqttService.serverURI");
            ((com.abupdate.mqtt_libs.mqttv3.f)this.callback).a(bl, (String)object);
        }
    }

    private void simpleAction(IMqttToken iMqttToken, Bundle object) {
        if (iMqttToken != null) {
            if ((o)((Object)object.getSerializable("MqttService.callbackStatus")) == o.a) {
                ((m)iMqttToken).a();
                return;
            }
            object = (Exception)object.getSerializable("MqttService.exception");
            ((m)iMqttToken).a((Throwable)object);
            return;
        }
        this.mqttService.traceError("MqttService", "simpleAction : token is null");
    }

    private void sendAction(Bundle bundle) {
        IMqttToken iMqttToken = this.getMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void subscribeAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void unSubscribeAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void messageDeliveredAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        if (iMqttToken != null && this.callback != null && (o)((Object)bundle.getSerializable("MqttService.callbackStatus")) == o.a && iMqttToken instanceof IMqttDeliveryToken) {
            this.callback.deliveryComplete((IMqttDeliveryToken)iMqttToken);
        }
    }

    private void messageArrivedAction(Bundle object) {
        if (this.callback != null) {
            String string = object.getString("MqttService.messageId");
            String string2 = object.getString("MqttService.destinationName");
            object = (ParcelableMqttMessage)object.getParcelable("MqttService.PARCEL");
            try {
                if (this.messageAck == a.a) {
                    this.callback.messageArrived(string2, (MqttMessage)object);
                    this.mqttService.acknowledgeMessageArrival(this.clientHandle, string);
                    return;
                }
                object.a = string;
                this.callback.messageArrived(string2, (MqttMessage)object);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private void traceAction(Bundle object) {
        if (this.traceCallback != null) {
            String string = object.getString("MqttService.traceSeverity");
            String string2 = object.getString("MqttService.errorMessage");
            String string3 = object.getString("MqttService.traceTag");
            if ("debug".equals(string)) {
                this.traceCallback.traceDebug(string3, string2);
                return;
            }
            if ("error".equals(string)) {
                this.traceCallback.traceError(string3, string2);
                return;
            }
            object = (Exception)object.getSerializable("MqttService.exception");
            this.traceCallback.traceException(string3, string2, (Exception)object);
        }
    }

    private synchronized String storeToken(IMqttToken iMqttToken) {
        this.tokenMap.put(this.tokenNumber, (Object)iMqttToken);
        return Integer.toString(this.tokenNumber++);
    }

    private synchronized IMqttToken removeMqttToken(Bundle object) {
        if ((object = object.getString("MqttService.activityToken")) != null) {
            int n2 = Integer.parseInt((String)object);
            IMqttToken iMqttToken = (IMqttToken)this.tokenMap.get(n2);
            this.tokenMap.delete(n2);
            return iMqttToken;
        }
        return null;
    }

    private synchronized IMqttToken getMqttToken(Bundle object) {
        object = object.getString("MqttService.activityToken");
        return (IMqttToken)this.tokenMap.get(Integer.parseInt((String)object));
    }

    public void setBufferOpts(com.abupdate.mqtt_libs.mqttv3.b b2) {
        this.mqttService.setBufferOpts(this.clientHandle, b2);
    }

    public int getBufferedMessageCount() {
        return this.mqttService.getBufferedMessageCount(this.clientHandle);
    }

    public MqttMessage getBufferedMessage(int n2) {
        return this.mqttService.getBufferedMessage(this.clientHandle, n2);
    }

    public void deleteBufferedMessage(int n2) {
        this.mqttService.deleteBufferedMessage(this.clientHandle, n2);
    }

    public SSLSocketFactory getSSLSocketFactory(InputStream object, String trustManagerArray) throws com.abupdate.mqtt_libs.mqttv3.m {
        try {
            KeyStore keyStore = KeyStore.getInstance("BKS");
            keyStore.load((InputStream)object, trustManagerArray.toCharArray());
            object = TrustManagerFactory.getInstance("X509");
            ((TrustManagerFactory)object).init(keyStore);
            trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
            object = SSLContext.getInstance("TLSv1");
            ((SSLContext)object).init(null, trustManagerArray, null);
            return ((SSLContext)object).getSocketFactory();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new com.abupdate.mqtt_libs.mqttv3.m(exception);
        }
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long l2) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long l2, long l3) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResources() {
        if (this.myContext != null && this.receiverRegistered) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                LocalBroadcastManager.getInstance((Context)this.myContext).unregisterReceiver((BroadcastReceiver)this);
                this.receiverRegistered = false;
            }
            if (this.bindedService) {
                try {
                    this.myContext.unbindService((ServiceConnection)this.serviceConnection);
                    this.bindedService = false;
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void startKeepConnect(long l2, long l3) {
        if (this.mqttService == null) {
            return;
        }
        this.mqttService.startKeepConnect(l2, l3);
    }

    public void stopKeepConnect() {
        this.mqttService.stopKeepConnect();
    }

    public boolean isKeepConnect() {
        if (this.clientHandle == null) {
            return false;
        }
        if (this.mqttService == null) {
            return false;
        }
        return this.mqttService.containClient(this.clientHandle);
    }

    public void registerResources(Context context) {
        if (context != null) {
            this.myContext = context;
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        }
    }

    static /* synthetic */ boolean access$400(MqttAndroidClient mqttAndroidClient) {
        return mqttAndroidClient.receiverRegistered;
    }

    static /* synthetic */ void access$500(MqttAndroidClient mqttAndroidClient, BroadcastReceiver broadcastReceiver) {
        mqttAndroidClient.registerReceiver(broadcastReceiver);
    }

    private final class b
    implements ServiceConnection {
        private b() {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            MqttAndroidClient.this.mqttService = ((l)iBinder).a();
            MqttAndroidClient.this.bindedService = true;
            MqttAndroidClient.this.doConnect();
        }

        public final void onServiceDisconnected(ComponentName componentName) {
            MqttAndroidClient.this.mqttService = null;
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    public static enum a {
        a,
        b;

    }
}

