/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.connect;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.connect.ShellUtils;

public class NetUtils {
    public static final String NETWORN_NONE = "no";
    public static final String NETWORN_WIFI = "WIFI";
    public static final String NETWORN_2G = "2G";
    public static final String NETWORN_3G = "3G";
    public static final String NETWORN_4G = "4G";
    public static final String NETWORN_MOBILE = "mobile";

    public static boolean isNetWorkAvailable() {
        return NetUtils.isAvailableBySystem() || NetUtils.isAvailableByPing(null);
    }

    private static boolean isAvailableBySystem() {
        boolean bl = false;
        if (MqttManager.sCx == null) {
            return false;
        }
        try {
            NetworkInfo[] networkInfoArray = (NetworkInfo[])MqttManager.sCx.getSystemService("connectivity");
            if (networkInfoArray == null) {
                return false;
            }
            if ((networkInfoArray = networkInfoArray.getAllNetworkInfo()) == null) {
                return false;
            }
            for (int i2 = 0; i2 < networkInfoArray.length && networkInfoArray[i2] != null; ++i2) {
                if (!networkInfoArray[i2].isConnected() || !networkInfoArray[i2].isAvailable()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            Log.d((String)"NetUtils", (String)"isNetWorkAvailable: not available");
        }
        return bl;
    }

    private static boolean isAvailableByPing(String object) {
        boolean bl;
        if (object == null || ((String)object).length() <= 0) {
            object = "223.5.5.5";
        }
        object = ShellUtils.execCmd(String.format("ping -c 1 -w 1 %s", object), false);
        boolean bl2 = bl = ((ShellUtils.CommandResult)object).result == 0;
        if (((ShellUtils.CommandResult)object).errorMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + ((ShellUtils.CommandResult)object).errorMsg));
        }
        if (((ShellUtils.CommandResult)object).successMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + ((ShellUtils.CommandResult)object).successMsg));
        }
        return bl;
    }

    public static String getNetworkState(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return NETWORN_NONE;
        }
        NetworkInfo networkInfo = context.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isAvailable()) {
            return NETWORN_NONE;
        }
        Object object = context.getNetworkInfo(1);
        if (object != null && (object = object.getState()) != null && (object == NetworkInfo.State.CONNECTED || object == NetworkInfo.State.CONNECTING)) {
            return NETWORN_WIFI;
        }
        object = context.getNetworkInfo(0);
        if (object != null) {
            context = object.getState();
            object = object.getSubtypeName();
            if (context != null && (context == NetworkInfo.State.CONNECTED || context == NetworkInfo.State.CONNECTING)) {
                switch (networkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return NETWORN_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return NETWORN_3G;
                    }
                    case 13: {
                        return NETWORN_4G;
                    }
                }
                if ("TD-SCDMA".equalsIgnoreCase((String)object) || "WCDMA".equalsIgnoreCase((String)object) || "CDMA2000".equalsIgnoreCase((String)object)) {
                    return NETWORN_3G;
                }
                return NETWORN_MOBILE;
            }
        }
        return NETWORN_NONE;
    }
}

