/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.mqtt_libs.mqtt_service;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import com.abupdate.mqtt_libs.mqtt_service.MqttService;
import com.abupdate.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.abupdate.mqtt_libs.mqtt_service.ParcelableMqttMessage;
import com.abupdate.mqtt_libs.mqtt_service.e;
import com.abupdate.mqtt_libs.mqtt_service.f;
import com.abupdate.mqtt_libs.mqtt_service.g;
import com.abupdate.mqtt_libs.mqtt_service.h;
import com.abupdate.mqtt_libs.mqttv3.IMqttActionListener;
import com.abupdate.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.abupdate.mqtt_libs.mqttv3.IMqttToken;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.MqttMessage;
import com.abupdate.mqtt_libs.mqttv3.c;
import com.abupdate.mqtt_libs.mqttv3.d;
import com.abupdate.mqtt_libs.mqttv3.k;
import com.abupdate.mqtt_libs.mqttv3.m;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MqttAndroidClient
extends BroadcastReceiver
implements c {
    private static final String SERVICE_NAME = "com.abupdate.mqtt_libs.mqtt_service.MqttService";
    private static final int BIND_SERVICE_FLAG = 0;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private final b serviceConnection = new b();
    private MqttService mqttService;
    private String clientHandle;
    private Context myContext;
    private final SparseArray<IMqttToken> tokenMap = new SparseArray();
    private int tokenNumber = 0;
    private final String serverURI;
    private final String clientId;
    private com.abupdate.mqtt_libs.mqttv3.g persistence = null;
    private com.abupdate.mqtt_libs.mqttv3.h connectOptions;
    private IMqttToken connectToken;
    private MqttCallback callback;
    private MqttTraceHandler traceCallback;
    private final a messageAck;
    private boolean traceEnabled = false;
    private volatile boolean receiverRegistered = false;
    private volatile boolean bindedService = false;

    public MqttAndroidClient(Context context, String string, String string2) {
        this(context, string, string2, null, a.a);
    }

    public MqttAndroidClient(Context context, String string, String string2, a a2) {
        this(context, string, string2, null, a2);
    }

    public MqttAndroidClient(Context context, String string, String string2, com.abupdate.mqtt_libs.mqttv3.g g2) {
        this(context, string, string2, g2, a.a);
    }

    public MqttAndroidClient(Context context, String string, String string2, com.abupdate.mqtt_libs.mqttv3.g g2, a a2) {
        this.myContext = context;
        this.serverURI = string;
        this.clientId = string2;
        this.persistence = g2;
        this.messageAck = a2;
    }

    public boolean isConnected() {
        return this.clientHandle != null && this.mqttService != null && this.mqttService.isConnected(this.clientHandle);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        if (this.mqttService != null) {
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.close(this.clientHandle);
        }
    }

    public IMqttToken connect() throws MqttException {
        return this.connect(null, null);
    }

    public IMqttToken connect(com.abupdate.mqtt_libs.mqttv3.h h2) throws MqttException {
        return this.connect(h2, null, null);
    }

    public IMqttToken connect(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        return this.connect(new com.abupdate.mqtt_libs.mqttv3.h(), object, iMqttActionListener);
    }

    public IMqttToken connect(com.abupdate.mqtt_libs.mqttv3.h h2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        this.connectOptions = h2;
        this.connectToken = g2;
        if (this.mqttService == null) {
            IMqttActionListener iMqttActionListener2;
            Intent intent = new Intent();
            intent.setClassName(this.myContext, SERVICE_NAME);
            ComponentName componentName = this.myContext.startService(intent);
            if (componentName == null && (iMqttActionListener2 = g2.getActionCallback()) != null) {
                iMqttActionListener2.onFailure(g2, new RuntimeException("cannot start service com.abupdate.mqtt_libs.mqtt_service.MqttService"));
            }
            this.myContext.bindService(intent, (ServiceConnection)this.serviceConnection, 1);
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        } else {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MqttAndroidClient.this.doConnect();
                    if (!MqttAndroidClient.this.receiverRegistered) {
                        MqttAndroidClient.this.registerReceiver(MqttAndroidClient.this);
                    }
                }
            });
        }
        return g2;
    }

    private void registerReceiver(BroadcastReceiver broadcastReceiver) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("MqttService.callbackToActivity.v0");
        LocalBroadcastManager.getInstance((Context)this.myContext).registerReceiver(broadcastReceiver, intentFilter);
        this.receiverRegistered = true;
    }

    private void doConnect() {
        block3: {
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.setTraceEnabled(this.traceEnabled);
            this.mqttService.setTraceCallbackId(this.clientHandle);
            String string = this.storeToken(this.connectToken);
            try {
                this.mqttService.connect(this.clientHandle, this.connectOptions, null, string);
            }
            catch (MqttException mqttException) {
                IMqttActionListener iMqttActionListener = this.connectToken.getActionCallback();
                if (iMqttActionListener == null) break block3;
                iMqttActionListener.onFailure(this.connectToken, mqttException);
            }
        }
    }

    public IMqttToken disconnect() throws MqttException {
        g g2 = new g(this, null, null);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, null, string);
        return g2;
    }

    public IMqttToken disconnect(long l2) throws MqttException {
        g g2 = new g(this, null, null);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, l2, null, string);
        return g2;
    }

    public IMqttToken disconnect(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, null, string);
        return g2;
    }

    public IMqttToken disconnect(long l2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, l2, null, string);
        return g2;
    }

    public IMqttDeliveryToken publish(String string, byte[] byArray, int n2, boolean bl) throws MqttException, k {
        return this.publish(string, byArray, n2, bl, null, null);
    }

    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage) throws MqttException, k {
        return this.publish(string, mqttMessage, null, null);
    }

    public IMqttDeliveryToken publish(String string, byte[] byArray, int n2, boolean bl, Object object, IMqttActionListener iMqttActionListener) throws MqttException, k {
        MqttMessage mqttMessage = new MqttMessage(byArray);
        mqttMessage.setQos(n2);
        mqttMessage.setRetained(bl);
        e e2 = new e(this, object, iMqttActionListener, mqttMessage);
        String string2 = this.storeToken(e2);
        IMqttDeliveryToken iMqttDeliveryToken = this.mqttService.publish(this.clientHandle, string, byArray, n2, bl, null, string2);
        e2.a(iMqttDeliveryToken);
        return e2;
    }

    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage, Object object, IMqttActionListener iMqttActionListener) throws MqttException, k {
        e e2 = new e(this, object, iMqttActionListener, mqttMessage);
        String string2 = this.storeToken(e2);
        IMqttDeliveryToken iMqttDeliveryToken = this.mqttService.publish(this.clientHandle, string, mqttMessage, null, string2);
        e2.a(iMqttDeliveryToken);
        return e2;
    }

    public IMqttToken subscribe(String string, int n2) throws MqttException, m {
        return this.subscribe(string, n2, null, null);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray) throws MqttException, m {
        return this.subscribe(stringArray, nArray, null, null);
    }

    public IMqttToken subscribe(String string, int n2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener, new String[]{string});
        String string2 = this.storeToken(g2);
        this.mqttService.subscribe(this.clientHandle, string, n2, null, string2);
        return g2;
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener, stringArray);
        String string = this.storeToken(g2);
        this.mqttService.subscribe(this.clientHandle, stringArray, nArray, null, string);
        return g2;
    }

    public IMqttToken subscribe(String string, int n2, Object object, IMqttActionListener iMqttActionListener, d d2) throws MqttException {
        return this.subscribe(new String[]{string}, new int[]{n2}, object, iMqttActionListener, new d[]{d2});
    }

    public IMqttToken subscribe(String string, int n2, d d2) throws MqttException {
        return this.subscribe(string, n2, null, null, d2);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, d[] dArray) throws MqttException {
        return this.subscribe(stringArray, nArray, null, null, dArray);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener, d[] dArray) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener, stringArray);
        String string = this.storeToken(g2);
        this.mqttService.subscribe(this.clientHandle, stringArray, nArray, null, string, dArray);
        return null;
    }

    public IMqttToken unsubscribe(String string) throws MqttException {
        return this.unsubscribe(string, null, null);
    }

    public IMqttToken unsubscribe(String[] stringArray) throws MqttException {
        return this.unsubscribe(stringArray, null, null);
    }

    public IMqttToken unsubscribe(String string, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string2 = this.storeToken(g2);
        this.mqttService.unsubscribe(this.clientHandle, string, null, string2);
        return g2;
    }

    public IMqttToken unsubscribe(String[] stringArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string = this.storeToken(g2);
        this.mqttService.unsubscribe(this.clientHandle, stringArray, null, string);
        return g2;
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.mqttService.getPendingDeliveryTokens(this.clientHandle);
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback = mqttCallback;
    }

    public void setTraceCallback(MqttTraceHandler mqttTraceHandler) {
        this.traceCallback = mqttTraceHandler;
    }

    public void setTraceEnabled(boolean bl) {
        this.traceEnabled = bl;
        if (this.mqttService != null) {
            this.mqttService.setTraceEnabled(bl);
        }
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        String string = bundle.getString("MqttService.clientHandle");
        if (string == null || !string.equals(this.clientHandle)) {
            return;
        }
        String string2 = bundle.getString("MqttService.callbackAction");
        if ("connect".equals(string2)) {
            this.connectAction(bundle);
        } else if ("connectExtended".equals(string2)) {
            this.connectExtendedAction(bundle);
        } else if ("messageArrived".equals(string2)) {
            this.messageArrivedAction(bundle);
        } else if ("subscribe".equals(string2)) {
            this.subscribeAction(bundle);
        } else if ("unsubscribe".equals(string2)) {
            this.unSubscribeAction(bundle);
        } else if ("send".equals(string2)) {
            this.sendAction(bundle);
        } else if ("messageDelivered".equals(string2)) {
            this.messageDeliveredAction(bundle);
        } else if ("onConnectionLost".equals(string2)) {
            this.connectionLostAction(bundle);
        } else if ("disconnect".equals(string2)) {
            this.disconnected(bundle);
        } else if ("trace".equals(string2)) {
            this.traceAction(bundle);
        } else {
            this.mqttService.traceError("MqttService", "Callback action doesn't exist.");
        }
    }

    public boolean acknowledgeMessage(String string) {
        if (this.messageAck == a.b) {
            h h2 = this.mqttService.acknowledgeMessageArrival(this.clientHandle, string);
            return h2 == h.a;
        }
        return false;
    }

    public void messageArrivedComplete(int n2, int n3) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void setManualAcks(boolean bl) {
        throw new UnsupportedOperationException();
    }

    private void connectAction(Bundle bundle) {
        IMqttToken iMqttToken = this.connectToken;
        this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void disconnected(Bundle bundle) {
        this.clientHandle = null;
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        if (iMqttToken != null) {
            ((g)iMqttToken).a();
        }
        if (this.callback != null) {
            this.callback.connectionLost(null);
        }
    }

    private void connectionLostAction(Bundle bundle) {
        if (this.callback != null) {
            Exception exception = (Exception)bundle.getSerializable("MqttService.exception");
            this.callback.connectionLost(exception);
        }
    }

    private void connectExtendedAction(Bundle bundle) {
        if (this.callback instanceof com.abupdate.mqtt_libs.mqttv3.f) {
            boolean bl = bundle.getBoolean("MqttService.reconnect", false);
            String string = bundle.getString("MqttService.serverURI");
            ((com.abupdate.mqtt_libs.mqttv3.f)this.callback).a(bl, string);
        }
    }

    private void simpleAction(IMqttToken iMqttToken, Bundle bundle) {
        if (iMqttToken != null) {
            h h2 = (h)((Object)bundle.getSerializable("MqttService.callbackStatus"));
            if (h2 == h.a) {
                ((g)iMqttToken).a();
            } else {
                Exception exception = (Exception)bundle.getSerializable("MqttService.exception");
                ((g)iMqttToken).a(exception);
            }
        } else {
            this.mqttService.traceError("MqttService", "simpleAction : token is null");
        }
    }

    private void sendAction(Bundle bundle) {
        IMqttToken iMqttToken = this.getMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void subscribeAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void unSubscribeAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void messageDeliveredAction(Bundle bundle) {
        h h2;
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        if (iMqttToken != null && this.callback != null && (h2 = (h)((Object)bundle.getSerializable("MqttService.callbackStatus"))) == h.a && iMqttToken instanceof IMqttDeliveryToken) {
            this.callback.deliveryComplete((IMqttDeliveryToken)iMqttToken);
        }
    }

    private void messageArrivedAction(Bundle bundle) {
        if (this.callback != null) {
            String string = bundle.getString("MqttService.messageId");
            String string2 = bundle.getString("MqttService.destinationName");
            ParcelableMqttMessage parcelableMqttMessage = (ParcelableMqttMessage)bundle.getParcelable("MqttService.PARCEL");
            try {
                if (this.messageAck == a.a) {
                    this.callback.messageArrived(string2, parcelableMqttMessage);
                    this.mqttService.acknowledgeMessageArrival(this.clientHandle, string);
                } else {
                    parcelableMqttMessage.a = string;
                    this.callback.messageArrived(string2, parcelableMqttMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void traceAction(Bundle bundle) {
        if (this.traceCallback != null) {
            String string = bundle.getString("MqttService.traceSeverity");
            String string2 = bundle.getString("MqttService.errorMessage");
            String string3 = bundle.getString("MqttService.traceTag");
            if ("debug".equals(string)) {
                this.traceCallback.traceDebug(string3, string2);
            } else if ("error".equals(string)) {
                this.traceCallback.traceError(string3, string2);
            } else {
                Exception exception = (Exception)bundle.getSerializable("MqttService.exception");
                this.traceCallback.traceException(string3, string2, exception);
            }
        }
    }

    private synchronized String storeToken(IMqttToken iMqttToken) {
        this.tokenMap.put(this.tokenNumber, (Object)iMqttToken);
        return Integer.toString(this.tokenNumber++);
    }

    private synchronized IMqttToken removeMqttToken(Bundle bundle) {
        String string = bundle.getString("MqttService.activityToken");
        if (string != null) {
            int n2 = Integer.parseInt(string);
            IMqttToken iMqttToken = (IMqttToken)this.tokenMap.get(n2);
            this.tokenMap.delete(n2);
            return iMqttToken;
        }
        return null;
    }

    private synchronized IMqttToken getMqttToken(Bundle bundle) {
        String string = bundle.getString("MqttService.activityToken");
        return (IMqttToken)this.tokenMap.get(Integer.parseInt(string));
    }

    public void setBufferOpts(com.abupdate.mqtt_libs.mqttv3.b b2) {
        this.mqttService.setBufferOpts(this.clientHandle, b2);
    }

    public int getBufferedMessageCount() {
        return this.mqttService.getBufferedMessageCount(this.clientHandle);
    }

    public MqttMessage getBufferedMessage(int n2) {
        return this.mqttService.getBufferedMessage(this.clientHandle, n2);
    }

    public void deleteBufferedMessage(int n2) {
        this.mqttService.deleteBufferedMessage(this.clientHandle, n2);
    }

    public SSLSocketFactory getSSLSocketFactory(InputStream inputStream, String string) throws m {
        try {
            SSLContext sSLContext = null;
            SSLSocketFactory sSLSocketFactory = null;
            KeyStore keyStore = KeyStore.getInstance("BKS");
            keyStore.load(inputStream, string.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            sSLContext = SSLContext.getInstance("TLSv1");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new m(exception);
        }
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long l2) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long l2, long l3) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResources() {
        if (this.myContext != null && this.receiverRegistered) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                LocalBroadcastManager.getInstance((Context)this.myContext).unregisterReceiver((BroadcastReceiver)this);
                this.receiverRegistered = false;
            }
            if (this.bindedService) {
                try {
                    this.myContext.unbindService((ServiceConnection)this.serviceConnection);
                    this.bindedService = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void startKeepConnect(long l2, long l3) {
        if (null == this.mqttService) {
            return;
        }
        this.mqttService.startKeepConnect(l2, l3);
    }

    public void stopKeepConnect() {
        this.mqttService.stopKeepConnect();
    }

    public boolean isKeepConnect() {
        return this.clientHandle == null ? false : (this.mqttService == null ? false : this.mqttService.containClient(this.clientHandle));
    }

    public void registerResources(Context context) {
        if (context != null) {
            this.myContext = context;
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        }
    }

    private final class b
    implements ServiceConnection {
        private b() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            MqttAndroidClient.this.mqttService = ((f)iBinder).a();
            MqttAndroidClient.this.bindedService = true;
            MqttAndroidClient.this.doConnect();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            MqttAndroidClient.this.mqttService = null;
        }
    }

    public static enum a {
        a,
        b;

    }
}

