/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal.wire;

import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MqttUnsubscribe
extends MqttWireMessage {
    private String[] names;
    private int count;

    public MqttUnsubscribe(String[] names) {
        super((byte)10);
        this.names = names;
    }

    public MqttUnsubscribe(byte info, byte[] data) throws IOException {
        super((byte)10);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.msgId = dis.readUnsignedShort();
        this.count = 0;
        this.names = new String[10];
        boolean end = false;
        while (!end) {
            try {
                this.names[this.count] = this.decodeUTF8(dis);
            }
            catch (Exception e) {
                end = true;
            }
        }
        dis.close();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" names:[");
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"" + this.names[i] + "\"");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (int i = 0; i < this.names.length; ++i) {
                this.encodeUTF8(dos, this.names[i]);
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

