/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal.wire;

import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.internal.ClientState;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MqttOutputStream
extends OutputStream {
    private static final String CLASS_NAME = MqttOutputStream.class.getName();
    private ClientState clientState = null;
    private BufferedOutputStream out;

    public MqttOutputStream(ClientState clientState, OutputStream out) {
        this.clientState = clientState;
        this.out = new BufferedOutputStream(out);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.clientState.notifySentBytes(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.clientState.notifySentBytes(len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(MqttWireMessage message) throws IOException, MqttException {
        String methodName = "write";
        byte[] bytes = message.getHeader();
        byte[] pl = message.getPayload();
        this.out.write(bytes, 0, bytes.length);
        this.clientState.notifySentBytes(bytes.length);
        int chunckSize = 1024;
        for (int offset = 0; offset < pl.length; offset += chunckSize) {
            int length = Math.min(chunckSize, pl.length - offset);
            this.out.write(pl, offset, length);
            this.clientState.notifySentBytes(length);
        }
    }
}

