/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal.wire;

import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.internal.ClientState;
import com.adups.mqtt_libs.mqttv3.internal.ExceptionHelper;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class MqttInputStream
extends InputStream {
    private static final String CLASS_NAME = MqttInputStream.class.getName();
    private ClientState clientState = null;
    private DataInputStream in;
    private ByteArrayOutputStream bais;
    private long remLen;
    private long packetLen;
    private byte[] packet;

    public MqttInputStream(ClientState clientState, InputStream in) {
        this.clientState = clientState;
        this.in = new DataInputStream(in);
        this.bais = new ByteArrayOutputStream();
        this.remLen = -1L;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() throws IOException, MqttException {
        String methodName = "readMqttWireMessage";
        MqttWireMessage message = null;
        try {
            if (this.remLen < 0L) {
                this.bais.reset();
                byte first = this.in.readByte();
                this.clientState.notifyReceivedBytes(1);
                byte type = (byte)(first >>> 4 & 0xF);
                if (type < 1 || type > 14) {
                    throw ExceptionHelper.createMqttException(32108);
                }
                this.remLen = MqttWireMessage.readMBI(this.in).getValue();
                this.bais.write(first);
                this.bais.write(MqttWireMessage.encodeMBI(this.remLen));
                this.packet = new byte[(int)((long)this.bais.size() + this.remLen)];
                this.packetLen = 0L;
            }
            if (this.remLen >= 0L) {
                this.readFully();
                this.remLen = -1L;
                byte[] header = this.bais.toByteArray();
                System.arraycopy(header, 0, this.packet, 0, header.length);
                message = MqttWireMessage.createWireMessage(this.packet);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return message;
    }

    private void readFully() throws IOException {
        int count;
        int off = this.bais.size() + (int)this.packetLen;
        int len = (int)(this.remLen - this.packetLen);
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = -1;
            try {
                count = this.in.read(this.packet, off + n, len - n);
            }
            catch (SocketTimeoutException e) {
                this.packetLen += (long)n;
                throw e;
            }
            this.clientState.notifyReceivedBytes(count);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

