/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal;

import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.internal.TCPNetworkModule;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLNetworkModule
extends TCPNetworkModule {
    private static final String CLASS_NAME = SSLNetworkModule.class.getName();
    private String[] enabledCiphers;
    private int handshakeTimeoutSecs;
    private HostnameVerifier hostnameVerifier;
    private String host;
    private int port;

    public SSLNetworkModule(SSLSocketFactory factory, String host, int port, String resourceContext) {
        super(factory, host, port, resourceContext);
        this.host = host;
        this.port = port;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        String methodName = "setEnabledCiphers";
        this.enabledCiphers = enabledCiphers;
        if (this.socket != null && enabledCiphers != null) {
            ((SSLSocket)this.socket).setEnabledCipherSuites(enabledCiphers);
        }
    }

    public void setSSLhandshakeTimeout(int timeout) {
        super.setConnectTimeout(timeout);
        this.handshakeTimeoutSecs = timeout;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        this.setEnabledCiphers(this.enabledCiphers);
        int soTimeout = this.socket.getSoTimeout();
        this.socket.setSoTimeout(this.handshakeTimeoutSecs * 1000);
        ((SSLSocket)this.socket).startHandshake();
        if (this.hostnameVerifier != null) {
            SSLSession session = ((SSLSocket)this.socket).getSession();
            this.hostnameVerifier.verify(this.host, session);
        }
        this.socket.setSoTimeout(soTimeout);
    }

    @Override
    public String getServerURI() {
        return "ssl://" + this.host + ":" + this.port;
    }
}

