/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal;

import com.adups.mqtt_libs.mqttv3.internal.ExceptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;

public class FileLock {
    private File lockFile;
    private RandomAccessFile file;
    private Object fileLock;

    public FileLock(File clientDir, String lockFilename) throws Exception {
        this.lockFile = new File(clientDir, lockFilename);
        if (ExceptionHelper.isClassAvailable("java.nio.channels.FileLock")) {
            try {
                this.file = new RandomAccessFile(this.lockFile, "rw");
                Method m = this.file.getClass().getMethod("getChannel", new Class[0]);
                Object channel = m.invoke((Object)this.file, new Object[0]);
                m = channel.getClass().getMethod("tryLock", new Class[0]);
                this.fileLock = m.invoke(channel, new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
                this.fileLock = null;
            }
            catch (IllegalArgumentException iae) {
                this.fileLock = null;
            }
            catch (IllegalAccessException iae) {
                this.fileLock = null;
            }
            if (this.fileLock == null) {
                this.release();
                throw new Exception("Problem obtaining file lock");
            }
        }
    }

    public void release() {
        try {
            if (this.fileLock != null) {
                Method m = this.fileLock.getClass().getMethod("release", new Class[0]);
                m.invoke(this.fileLock, new Object[0]);
                this.fileLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = null;
        }
        if (this.lockFile != null && this.lockFile.exists()) {
            this.lockFile.delete();
        }
        this.lockFile = null;
    }
}

