/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal;

import com.adups.mqtt_libs.mqttv3.MqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttToken;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPublish;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CommsTokenStore {
    private static final String CLASS_NAME = CommsTokenStore.class.getName();
    private Hashtable tokens;
    private String logContext;
    private MqttException closedResponse = null;

    public CommsTokenStore(String logContext) {
        String methodName = "<Init>";
        this.tokens = new Hashtable();
        this.logContext = logContext;
    }

    public MqttToken getToken(MqttWireMessage message) {
        String key = message.getKey();
        return (MqttToken)this.tokens.get(key);
    }

    public MqttToken getToken(String key) {
        return (MqttToken)this.tokens.get(key);
    }

    public MqttToken removeToken(MqttWireMessage message) {
        if (message != null) {
            return this.removeToken(message.getKey());
        }
        return null;
    }

    public MqttToken removeToken(String key) {
        String methodName = "removeToken";
        if (null != key) {
            return (MqttToken)this.tokens.remove(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttDeliveryToken restoreToken(MqttPublish message) {
        MqttDeliveryToken token;
        String methodName = "restoreToken";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            String key = new Integer(message.getMessageId()).toString();
            if (this.tokens.containsKey(key)) {
                token = (MqttDeliveryToken)this.tokens.get(key);
            } else {
                token = new MqttDeliveryToken(this.logContext);
                token.internalTok.setKey(key);
                this.tokens.put(key, token);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToken(MqttToken token, MqttWireMessage message) throws MqttException {
        String methodName = "saveToken";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            if (this.closedResponse != null) {
                throw this.closedResponse;
            }
            String key = message.getKey();
            this.saveToken(token, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToken(MqttToken token, String key) {
        String methodName = "saveToken";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            token.internalTok.setKey(key);
            this.tokens.put(key, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quiesce(MqttException quiesceResponse) {
        String methodName = "quiesce";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.closedResponse = quiesceResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        String methodName = "open";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.closedResponse = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttDeliveryToken[] getOutstandingDelTokens() {
        String methodName = "getOutstandingDelTokens";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            Vector<MqttToken> list = new Vector<MqttToken>();
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken token = (MqttToken)enumeration.nextElement();
                if (token == null || !(token instanceof MqttDeliveryToken) || token.internalTok.isNotified()) continue;
                list.addElement(token);
            }
            MqttDeliveryToken[] result = new MqttDeliveryToken[list.size()];
            return list.toArray(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOutstandingTokens() {
        String methodName = "getOutstandingTokens";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            Vector<MqttToken> list = new Vector<MqttToken>();
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken token = (MqttToken)enumeration.nextElement();
                if (token == null) continue;
                list.addElement(token);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        String methodName = "clear";
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.tokens.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            return this.tokens.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String lineSep = System.getProperty("line.separator", "\n");
        StringBuffer toks = new StringBuffer();
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken token = (MqttToken)enumeration.nextElement();
                toks.append("{" + token.internalTok + "}" + lineSep);
            }
            return toks.toString();
        }
    }
}

