/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal;

import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttToken;
import com.adups.mqtt_libs.mqttv3.internal.ClientComms;
import com.adups.mqtt_libs.mqttv3.internal.ClientState;
import com.adups.mqtt_libs.mqttv3.internal.CommsTokenStore;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttAck;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttDisconnect;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttOutputStream;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Thread sendThread = null;
    private String threadName;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private Future senderFuture;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out) {
        this.out = new MqttOutputStream(clientState, out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.senderFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.senderFuture != null) {
                this.senderFuture.cancel(true);
            }
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.sendThread)) {
                    try {
                        while (this.running) {
                            this.clientState.notifyQueueLock();
                            this.runningSemaphore.tryAcquire(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.runningSemaphore.release();
                    }
                }
            }
            this.sendThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.sendThread = Thread.currentThread();
        this.sendThread.setName(this.threadName);
        String methodName = "run";
        MqttWireMessage message = null;
        try {
            this.runningSemaphore.acquire();
        }
        catch (InterruptedException e) {
            this.running = false;
            return;
        }
        try {
            while (this.running && this.out != null) {
                try {
                    message = this.clientState.get();
                    if (message != null) {
                        if (message instanceof MqttAck) {
                            this.out.write(message);
                            this.out.flush();
                            continue;
                        }
                        MqttToken token = this.tokenStore.getToken(message);
                        if (token == null) continue;
                        MqttToken mqttToken = token;
                        synchronized (mqttToken) {
                            block15: {
                                this.out.write(message);
                                try {
                                    this.out.flush();
                                }
                                catch (IOException ex) {
                                    if (message instanceof MqttDisconnect) break block15;
                                    throw ex;
                                }
                            }
                            this.clientState.notifySent(message);
                            continue;
                        }
                    }
                    this.running = false;
                }
                catch (MqttException me) {
                    this.handleRunException(message, me);
                }
                catch (Exception ex) {
                    this.handleRunException(message, ex);
                }
            }
            return;
        }
        finally {
            this.running = false;
            this.runningSemaphore.release();
        }
    }

    private void handleRunException(MqttWireMessage message, Exception ex) {
        String methodName = "handleRunException";
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.running = false;
        this.clientComms.shutdownConnection(null, mex);
    }
}

