/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal;

import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttToken;
import com.adups.mqtt_libs.mqttv3.internal.ClientComms;
import com.adups.mqtt_libs.mqttv3.internal.ClientState;
import com.adups.mqtt_libs.mqttv3.internal.CommsTokenStore;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttAck;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttInputStream;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPubAck;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPubComp;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPubRec;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private volatile boolean receiving;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private String threadName;
    private Future receiverFuture;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(clientState, in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        String methodName = "start";
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.receiverFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.receiverFuture != null) {
                this.receiverFuture.cancel(true);
            }
            if (this.running) {
                this.running = false;
                this.receiving = false;
                if (!Thread.currentThread().equals(this.recThread)) {
                    try {
                        this.runningSemaphore.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.runningSemaphore.release();
                    }
                }
            }
        }
        this.recThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        String methodName = "run";
        MqttToken token = null;
        try {
            this.runningSemaphore.acquire();
        }
        catch (InterruptedException e) {
            this.running = false;
            return;
        }
        while (this.running && this.in != null) {
            try {
                this.receiving = this.in.available() > 0;
                MqttWireMessage message = this.in.readMqttWireMessage();
                this.receiving = false;
                if (message instanceof MqttAck) {
                    token = this.tokenStore.getToken(message);
                    if (token != null) {
                        MqttToken mqttToken = token;
                        synchronized (mqttToken) {
                            this.clientState.notifyReceivedAck((MqttAck)message);
                            continue;
                        }
                    }
                    if (message instanceof MqttPubRec || message instanceof MqttPubComp || message instanceof MqttPubAck) continue;
                    throw new MqttException(6);
                }
                if (message == null) continue;
                this.clientState.notifyReceivedMsg(message);
            }
            catch (MqttException ex) {
                this.running = false;
                this.clientComms.shutdownConnection(token, ex);
            }
            catch (IOException ioe) {
                this.running = false;
                if (this.clientComms.isDisconnecting()) continue;
                this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
            }
            finally {
                this.receiving = false;
                this.runningSemaphore.release();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }
}

