/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3.internal;

import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.IMqttMessageListener;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttCallbackExtended;
import com.adups.mqtt_libs.mqttv3.MqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttMessage;
import com.adups.mqtt_libs.mqttv3.MqttToken;
import com.adups.mqtt_libs.mqttv3.MqttTopic;
import com.adups.mqtt_libs.mqttv3.internal.ClientComms;
import com.adups.mqtt_libs.mqttv3.internal.ClientState;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPubAck;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPubComp;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPublish;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME = CommsCallback.class.getName();
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private MqttCallbackExtended reconnectInternalCallback;
    private Hashtable callbacks;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    private boolean manualAcks = false;
    private String threadName;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private Future callbackFuture;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        this.callbacks = new Hashtable();
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.callbackFuture != null) {
                this.callbackFuture.cancel(true);
            }
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.callbackThread)) {
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            this.workAvailable.notifyAll();
                        }
                        this.runningSemaphore.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.runningSemaphore.release();
                    }
                }
            }
            this.callbackThread = null;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    public void setReconnectCallback(MqttCallbackExtended callback) {
        this.reconnectInternalCallback = callback;
    }

    public void setManualAcks(boolean manualAcks) {
        this.manualAcks = manualAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        this.callbackThread = Thread.currentThread();
        this.callbackThread.setName(this.threadName);
        try {
            this.runningSemaphore.acquire();
        }
        catch (InterruptedException e) {
            this.running = false;
            return;
        }
        while (this.running) {
            Object token;
            try {
                try {
                    Object e = this.workAvailable;
                    synchronized (e) {
                        if (this.running && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.running) {
                    token = null;
                    Vector vector = this.completeQueue;
                    synchronized (vector) {
                        if (!this.completeQueue.isEmpty()) {
                            token = (MqttToken)this.completeQueue.elementAt(0);
                            this.completeQueue.removeElementAt(0);
                        }
                    }
                    if (null != token) {
                        this.handleActionComplete((MqttToken)token);
                    }
                    MqttPublish message = null;
                    Vector vector2 = this.messageQueue;
                    synchronized (vector2) {
                        if (!this.messageQueue.isEmpty()) {
                            message = (MqttPublish)this.messageQueue.elementAt(0);
                            this.messageQueue.removeElementAt(0);
                        }
                    }
                    if (null != message) {
                        this.handleMessage(message);
                    }
                }
                if (!this.quiescing) continue;
                this.clientState.checkQuiesceLock();
            }
            catch (Throwable ex) {
                this.running = false;
                this.clientComms.shutdownConnection(null, new MqttException(ex));
            }
            finally {
                this.runningSemaphore.release();
                token = this.spaceAvailable;
                synchronized (token) {
                    this.spaceAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        String methodName = "handleActionComplete";
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token.isComplete() && (token instanceof MqttDeliveryToken || token.getActionCallback() instanceof IMqttActionListener)) {
                token.internalTok.setNotified(true);
            }
        }
    }

    public void connectionLost(MqttException cause) {
        String methodName = "connectionLost";
        try {
            if (this.mqttCallback != null && cause != null) {
                this.mqttCallback.connectionLost(cause);
            }
            if (this.reconnectInternalCallback != null && cause != null) {
                this.reconnectInternalCallback.connectionLost(cause);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        String methodName = "fireActionEvent";
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                asyncCB.onSuccess(token);
            } else {
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(MqttPublish sendMessage) {
        String methodName = "messageArrived";
        if (this.mqttCallback != null || this.callbacks.size() > 0) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                while (this.running && !this.quiescing && this.messageQueue.size() >= 10) {
                    try {
                        this.spaceAvailable.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.quiescing) {
                this.messageQueue.addElement(sendMessage);
                object = this.workAvailable;
                synchronized (object) {
                    this.workAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        String methodName = "quiesce";
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        String methodName = "handleMessage";
        String destName = publishMessage.getTopicName();
        this.deliverMessage(destName, publishMessage.getMessageId(), publishMessage.getMessage());
        if (!this.manualAcks) {
            if (publishMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        if (qos == 1) {
            this.clientComms.internalSend(new MqttPubAck(messageId), new MqttToken(this.clientComms.getClient().getClientId()));
        } else if (qos == 2) {
            this.clientComms.deliveryComplete(messageId);
            MqttPubComp pubComp = new MqttPubComp(messageId);
            this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token) {
        String methodName = "asyncOperationComplete";
        if (this.running) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    public void setMessageListener(String topicFilter, IMqttMessageListener messageListener) {
        this.callbacks.put(topicFilter, messageListener);
    }

    public void removeMessageListener(String topicFilter) {
        this.callbacks.remove(topicFilter);
    }

    public void removeMessageListeners() {
        this.callbacks.clear();
    }

    protected boolean deliverMessage(String topicName, int messageId, MqttMessage aMessage) throws Exception {
        boolean delivered = false;
        Enumeration keys = this.callbacks.keys();
        while (keys.hasMoreElements()) {
            String topicFilter = (String)keys.nextElement();
            if (!MqttTopic.isMatched(topicFilter, topicName)) continue;
            aMessage.setId(messageId);
            ((IMqttMessageListener)this.callbacks.get(topicFilter)).messageArrived(topicName, aMessage);
            delivered = true;
        }
        if (this.mqttCallback != null && !delivered) {
            aMessage.setId(messageId);
            this.mqttCallback.messageArrived(topicName, aMessage);
            delivered = true;
        }
        return delivered;
    }
}

