/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3;

import com.adups.mqtt_libs.mqttv3.MqttPingSender;
import com.adups.mqtt_libs.mqttv3.internal.ClientComms;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorPingSender
implements MqttPingSender {
    private static final String CLASS_NAME = ScheduledExecutorPingSender.class.getName();
    private ClientComms comms;
    private ScheduledExecutorService executorService;
    private ScheduledFuture scheduledFuture;
    private String clientid;

    public ScheduledExecutorPingSender(ScheduledExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException("ExecutorService cannot be null.");
        }
        this.executorService = executorService;
    }

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
        this.clientid = comms.getClient().getClientId();
    }

    @Override
    public void start() {
        String methodName = "start";
        this.schedule(this.comms.getKeepAlive());
    }

    @Override
    public void stop() {
        String methodName = "stop";
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        this.scheduledFuture = this.executorService.schedule(new PingRunnable(), delayInMilliseconds, TimeUnit.MILLISECONDS);
    }

    private class PingRunnable
    implements Runnable {
        private static final String methodName = "PingTask.run";

        private PingRunnable() {
        }

        @Override
        public void run() {
            String originalThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("MQTT Ping: " + ScheduledExecutorPingSender.this.clientid);
            ScheduledExecutorPingSender.this.comms.checkForActivity();
            Thread.currentThread().setName(originalThreadName);
        }
    }
}

