/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3;

import com.adups.mqtt_libs.mqttv3.DisconnectedBufferOptions;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.IMqttAsyncClient;
import com.adups.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.IMqttMessageListener;
import com.adups.mqtt_libs.mqttv3.IMqttToken;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttCallbackExtended;
import com.adups.mqtt_libs.mqttv3.MqttClientPersistence;
import com.adups.mqtt_libs.mqttv3.MqttConnectOptions;
import com.adups.mqtt_libs.mqttv3.MqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttMessage;
import com.adups.mqtt_libs.mqttv3.MqttPersistenceException;
import com.adups.mqtt_libs.mqttv3.MqttPingSender;
import com.adups.mqtt_libs.mqttv3.MqttSecurityException;
import com.adups.mqtt_libs.mqttv3.MqttToken;
import com.adups.mqtt_libs.mqttv3.MqttTopic;
import com.adups.mqtt_libs.mqttv3.TimerPingSender;
import com.adups.mqtt_libs.mqttv3.internal.ClientComms;
import com.adups.mqtt_libs.mqttv3.internal.ConnectActionListener;
import com.adups.mqtt_libs.mqttv3.internal.DisconnectedMessageBuffer;
import com.adups.mqtt_libs.mqttv3.internal.ExceptionHelper;
import com.adups.mqtt_libs.mqttv3.internal.NetworkModule;
import com.adups.mqtt_libs.mqttv3.internal.SSLNetworkModule;
import com.adups.mqtt_libs.mqttv3.internal.TCPNetworkModule;
import com.adups.mqtt_libs.mqttv3.internal.security.SSLSocketFactoryFactory;
import com.adups.mqtt_libs.mqttv3.internal.websocket.WebSocketNetworkModule;
import com.adups.mqtt_libs.mqttv3.internal.websocket.WebSocketSecureNetworkModule;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttDisconnect;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttPublish;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttSubscribe;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttUnsubscribe;
import com.adups.mqtt_libs.mqttv3.persist.MemoryPersistence;
import com.adups.mqtt_libs.mqttv3.persist.MqttDefaultFilePersistence;
import com.adups.mqtt_libs.mqttv3.util.Debug;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final String CLASS_NAME = MqttAsyncClient.class.getName();
    private static final String CLIENT_ID_PREFIX = "paho";
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private String clientId;
    private String serverURI;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    private MqttCallback mqttCallback;
    private MqttConnectOptions connOpts;
    private Object userContext;
    private Timer reconnectTimer;
    private static int reconnectDelay = 1000;
    private boolean reconnecting = false;
    private static Object clientLock = new Object();
    private ScheduledExecutorService executorService;

    public MqttAsyncClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(serverURI, clientId, persistence, new TimerPingSender());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender) throws MqttException {
        this(serverURI, clientId, persistence, pingSender, null);
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender, ScheduledExecutorService executorService) throws MqttException {
        String methodName = "MqttAsyncClient";
        if (clientId == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int clientIdLength = 0;
        for (int i = 0; i < clientId.length() - 1; ++i) {
            if (MqttAsyncClient.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
        }
        if (clientIdLength > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        MqttConnectOptions.validateURI(serverURI);
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.executorService = executorService;
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(10);
        }
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence, pingSender, this.executorService);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        String methodName = "createNetworkModules";
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        for (int i = 0; i < array.length; ++i) {
            networkModules[i] = this.createNetworkModule(array[i], options);
        }
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        TCPNetworkModule netModule;
        URI uri;
        int serverURIType;
        SocketFactory factory;
        block28: {
            String methodName = "createNetworkModule";
            factory = options.getSocketFactory();
            serverURIType = MqttConnectOptions.validateURI(address);
            try {
                uri = new URI(address);
                if (uri.getHost() != null || !address.contains("_")) break block28;
                try {
                    Field hostField = URI.class.getDeclaredField("host");
                    hostField.setAccessible(true);
                    String shortAddress = address.substring(uri.getScheme().length() + 3);
                    hostField.set(uri, this.getHostName(shortAddress));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    throw ExceptionHelper.createMqttException(e.getCause());
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Malformed URI: " + address + ", " + e.getMessage());
            }
        }
        String host = uri.getHost();
        int port = uri.getPort();
        switch (serverURIType) {
            case 0: {
                if (port == -1) {
                    port = 1883;
                }
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(factory, host, port, this.clientId);
                netModule.setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 1: {
                String[] enabledCiphers;
                if (port == -1) {
                    port = 8883;
                }
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    factoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        factoryFactory.initialize(sslClientProps, null);
                    }
                    factory = factoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, this.clientId);
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                ((SSLNetworkModule)netModule).setSSLHostnameVerifier(options.getSSLHostnameVerifier());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 3: {
                if (port == -1) {
                    port = 80;
                }
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketNetworkModule(factory, address, host, port, this.clientId);
                ((WebSocketNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 4: {
                String[] enabledCiphers;
                if (port == -1) {
                    port = 443;
                }
                SSLSocketFactoryFactory wSSFactoryFactory = null;
                if (factory == null) {
                    wSSFactoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        wSSFactoryFactory.initialize(sslClientProps, null);
                    }
                    factory = wSSFactoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory, address, host, port, this.clientId);
                ((WebSocketSecureNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                if (wSSFactoryFactory == null || (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            default: {
                netModule = null;
            }
        }
        return netModule;
    }

    private String getHostName(String uri) {
        int portIndex = uri.indexOf(58);
        if (portIndex == -1) {
            portIndex = uri.indexOf(47);
        }
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(0, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        String methodName = "connect";
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        if (options == null) {
            options = new MqttConnectOptions();
        }
        this.connOpts = options;
        this.userContext = userContext;
        boolean automaticReconnect = options.isAutomaticReconnect();
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        this.comms.setReconnectCallback(new MqttReconnectCallback(automaticReconnect));
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback, this.reconnecting);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        if (this.mqttCallback instanceof MqttCallbackExtended) {
            connectActionListener.setMqttCallbackExtended((MqttCallbackExtended)this.mqttCallback);
        }
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "disconnect";
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect();
        this.comms.disconnect(disconnect, quiesceTimeout, token);
        return token;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(30000L, disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, boolean sendDisconnectPacket) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout, sendDisconnectPacket);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public String getCurrentServerURI() {
        return this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
    }

    protected MqttTopic getTopic(String topic) {
        MqttTopic.validate(topic, false);
        MqttTopic result = (MqttTopic)this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    public IMqttToken checkPing(Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "ping";
        MqttToken token = this.comms.checkForActivity();
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "subscribe";
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < topicFilters.length; ++i) {
            this.comms.removeMessageListener(topicFilters[i]);
        }
        StringBuffer subs = new StringBuffer();
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs.append(", ");
            }
            subs.append("topic=").append(topicFilters[i]).append(" qos=").append(qos[i]);
            MqttTopic.validate(topicFilters[i], true);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback, IMqttMessageListener[] messageListeners) throws MqttException {
        if (messageListeners.length != qos.length || qos.length != topicFilters.length) {
            throw new IllegalArgumentException();
        }
        IMqttToken token = this.subscribe(topicFilters, qos, userContext, callback);
        for (int i = 0; i < topicFilters.length; ++i) {
            this.comms.setMessageListener(topicFilters[i], messageListeners[i]);
        }
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, IMqttActionListener callback) throws MqttException {
        int i;
        String methodName = "unsubscribe";
        for (i = 0; i < topicFilters.length; ++i) {
            MqttTopic.validate(topicFilters[i], true);
        }
        for (i = 0; i < topicFilters.length; ++i) {
            this.comms.removeMessageListener(topicFilters[i]);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendNoWait(unregister, token);
        return token;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.mqttCallback = callback;
        this.comms.setCallback(callback);
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        this.comms.setManualAcks(manualAcks);
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.comms.messageArrivedComplete(messageId, qos);
    }

    public static String generateClientId() {
        return CLIENT_ID_PREFIX + System.nanoTime();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        String methodName = "publish";
        MqttTopic.validate(topic, false);
        MqttDeliveryToken token = new MqttDeliveryToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        return token;
    }

    public void reconnect() throws MqttException {
        String methodName = "reconnect";
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.stopReconnectCycle();
        this.attemptReconnect();
    }

    private void attemptReconnect() {
        String methodName = "attemptReconnect";
        try {
            this.connect(this.connOpts, this.userContext, new MqttReconnectActionListener("attemptReconnect"));
        }
        catch (MqttSecurityException mqttSecurityException) {
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    private void startReconnectCycle() {
        String methodName = "startReconnectCycle";
        this.reconnectTimer = new Timer("MQTT Reconnect: " + this.clientId);
        this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), reconnectDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnectCycle() {
        String methodName = "stopReconnectCycle";
        Object object = clientLock;
        synchronized (object) {
            if (this.connOpts.isAutomaticReconnect()) {
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                    this.reconnectTimer = null;
                }
                reconnectDelay = 1000;
            }
        }
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.comms.setDisconnectedMessageBuffer(new DisconnectedMessageBuffer(bufferOpts));
    }

    public int getBufferedMessageCount() {
        return this.comms.getBufferedMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.comms.getBufferedMessage(bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.comms.deleteBufferedMessage(bufferIndex);
    }

    public int getInFlightMessageCount() {
        return this.comms.getActualInFlight();
    }

    @Override
    public void close() throws MqttException {
        this.close(false);
    }

    public void close(boolean force) throws MqttException {
        String methodName = "close";
        this.comms.close(force);
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }

    class MqttReconnectActionListener
    implements IMqttActionListener {
        final String methodName;

        MqttReconnectActionListener(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
            MqttAsyncClient.this.comms.setRestingState(false);
            MqttAsyncClient.this.stopReconnectCycle();
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            if (reconnectDelay < 128000) {
                reconnectDelay = reconnectDelay * 2;
            }
            this.rescheduleReconnectCycle(reconnectDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rescheduleReconnectCycle(int delay) {
            String reschedulemethodName = this.methodName + ":rescheduleReconnectCycle";
            Object object = clientLock;
            synchronized (object) {
                if (MqttAsyncClient.this.connOpts.isAutomaticReconnect()) {
                    if (MqttAsyncClient.this.reconnectTimer != null) {
                        MqttAsyncClient.this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), delay);
                    } else {
                        reconnectDelay = delay;
                        MqttAsyncClient.this.startReconnectCycle();
                    }
                }
            }
        }
    }

    class MqttReconnectCallback
    implements MqttCallbackExtended {
        final boolean automaticReconnect;

        MqttReconnectCallback(boolean isAutomaticReconnect) {
            this.automaticReconnect = isAutomaticReconnect;
        }

        @Override
        public void connectionLost(Throwable cause) {
            if (this.automaticReconnect) {
                MqttAsyncClient.this.comms.setRestingState(true);
                MqttAsyncClient.this.reconnecting = true;
                MqttAsyncClient.this.startReconnectCycle();
            }
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) throws Exception {
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        @Override
        public void connectComplete(boolean reconnect, String serverURI) {
        }
    }

    private class ReconnectTask
    extends TimerTask {
        private static final String methodName = "ReconnectTask.run";

        private ReconnectTask() {
        }

        @Override
        public void run() {
            MqttAsyncClient.this.attemptReconnect();
        }
    }
}

