/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqtt_service;

import com.adups.mqtt_libs.mqtt_service.MqttAndroidClient;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.IMqttAsyncClient;
import com.adups.mqtt_libs.mqttv3.IMqttToken;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttSecurityException;
import com.adups.mqtt_libs.mqttv3.internal.wire.MqttWireMessage;

class MqttTokenAndroid
implements IMqttToken {
    private IMqttActionListener listener;
    private volatile boolean isComplete;
    private volatile MqttException lastException;
    private Object waitObject = new Object();
    private MqttAndroidClient client;
    private Object userContext;
    private String[] topics;
    private IMqttToken delegate;
    private MqttException pendingException;

    MqttTokenAndroid(MqttAndroidClient client, Object userContext, IMqttActionListener listener) {
        this(client, userContext, listener, null);
    }

    MqttTokenAndroid(MqttAndroidClient client, Object userContext, IMqttActionListener listener, String[] topics) {
        this.client = client;
        this.userContext = userContext;
        this.listener = listener;
        this.topics = topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() throws MqttException, MqttSecurityException {
        Object object = this.waitObject;
        synchronized (object) {
            try {
                this.waitObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.pendingException != null) {
            throw this.pendingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion(long timeout) throws MqttException, MqttSecurityException {
        Object object = this.waitObject;
        synchronized (object) {
            try {
                this.waitObject.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isComplete) {
                throw new MqttException(32000);
            }
            if (this.pendingException != null) {
                throw this.pendingException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyComplete() {
        Object object = this.waitObject;
        synchronized (object) {
            this.isComplete = true;
            this.waitObject.notifyAll();
            if (this.listener != null) {
                this.listener.onSuccess(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailure(Throwable exception) {
        Object object = this.waitObject;
        synchronized (object) {
            this.isComplete = true;
            this.pendingException = exception instanceof MqttException ? (MqttException)exception : new MqttException(exception);
            this.waitObject.notifyAll();
            if (exception instanceof MqttException) {
                this.lastException = (MqttException)exception;
            }
            if (this.listener != null) {
                this.listener.onFailure(this, exception);
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    @Override
    public MqttException getException() {
        return this.lastException;
    }

    void setException(MqttException exception) {
        this.lastException = exception;
    }

    @Override
    public IMqttAsyncClient getClient() {
        return this.client;
    }

    @Override
    public void setActionCallback(IMqttActionListener listener) {
        this.listener = listener;
    }

    @Override
    public IMqttActionListener getActionCallback() {
        return this.listener;
    }

    @Override
    public String[] getTopics() {
        return this.topics;
    }

    @Override
    public void setUserContext(Object userContext) {
        this.userContext = userContext;
    }

    @Override
    public Object getUserContext() {
        return this.userContext;
    }

    void setDelegate(IMqttToken delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getMessageId() {
        return this.delegate != null ? this.delegate.getMessageId() : 0;
    }

    @Override
    public MqttWireMessage getResponse() {
        return this.delegate.getResponse();
    }

    @Override
    public boolean getSessionPresent() {
        return this.delegate.getSessionPresent();
    }

    @Override
    public int[] getGrantedQos() {
        return this.delegate.getGrantedQos();
    }
}

