/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqtt_service;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import com.adups.mqtt_libs.mqtt_service.MqttDeliveryTokenAndroid;
import com.adups.mqtt_libs.mqtt_service.MqttService;
import com.adups.mqtt_libs.mqtt_service.MqttServiceBinder;
import com.adups.mqtt_libs.mqtt_service.MqttTokenAndroid;
import com.adups.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.adups.mqtt_libs.mqtt_service.ParcelableMqttMessage;
import com.adups.mqtt_libs.mqtt_service.Status;
import com.adups.mqtt_libs.mqttv3.DisconnectedBufferOptions;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.IMqttAsyncClient;
import com.adups.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.IMqttMessageListener;
import com.adups.mqtt_libs.mqttv3.IMqttToken;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttCallbackExtended;
import com.adups.mqtt_libs.mqttv3.MqttClientPersistence;
import com.adups.mqtt_libs.mqttv3.MqttConnectOptions;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttMessage;
import com.adups.mqtt_libs.mqttv3.MqttPersistenceException;
import com.adups.mqtt_libs.mqttv3.MqttSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MqttAndroidClient
extends BroadcastReceiver
implements IMqttAsyncClient {
    private static final String SERVICE_NAME = "com.adups.mqtt_libs.mqtt_service.MqttService";
    private static final int BIND_SERVICE_FLAG = 0;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private final MyServiceConnection serviceConnection = new MyServiceConnection();
    private MqttService mqttService;
    private String clientHandle;
    private Context myContext;
    private final SparseArray<IMqttToken> tokenMap = new SparseArray();
    private int tokenNumber = 0;
    private final String serverURI;
    private final String clientId;
    private MqttClientPersistence persistence = null;
    private MqttConnectOptions connectOptions;
    private IMqttToken connectToken;
    private MqttCallback callback;
    private MqttTraceHandler traceCallback;
    private final Ack messageAck;
    private boolean traceEnabled = false;
    private volatile boolean receiverRegistered = false;
    private volatile boolean bindedService = false;

    public MqttAndroidClient(Context context, String serverURI, String clientId) {
        this(context, serverURI, clientId, null, Ack.AUTO_ACK);
    }

    public MqttAndroidClient(Context ctx, String serverURI, String clientId, Ack ackType) {
        this(ctx, serverURI, clientId, null, ackType);
    }

    public MqttAndroidClient(Context ctx, String serverURI, String clientId, MqttClientPersistence persistence) {
        this(ctx, serverURI, clientId, persistence, Ack.AUTO_ACK);
    }

    public MqttAndroidClient(Context context, String serverURI, String clientId, MqttClientPersistence persistence, Ack ackType) {
        this.myContext = context;
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        this.messageAck = ackType;
    }

    @Override
    public boolean isConnected() {
        return this.clientHandle != null && this.mqttService != null && this.mqttService.isConnected(this.clientHandle);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    @Override
    public void close() {
        if (this.mqttService != null) {
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.close(this.clientHandle);
        }
    }

    @Override
    public IMqttToken connect() throws MqttException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        this.connectOptions = options;
        this.connectToken = token;
        if (this.mqttService == null) {
            IMqttActionListener listener;
            Intent serviceStartIntent = new Intent();
            serviceStartIntent.setClassName(this.myContext, SERVICE_NAME);
            ComponentName service = this.myContext.startService(serviceStartIntent);
            if (service == null && (listener = token.getActionCallback()) != null) {
                listener.onFailure(token, new RuntimeException("cannot start service com.adups.mqtt_libs.mqtt_service.MqttService"));
            }
            this.myContext.bindService(serviceStartIntent, (ServiceConnection)this.serviceConnection, 1);
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        } else {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MqttAndroidClient.this.doConnect();
                    if (!MqttAndroidClient.this.receiverRegistered) {
                        MqttAndroidClient.this.registerReceiver(MqttAndroidClient.this);
                    }
                }
            });
        }
        return token;
    }

    private void registerReceiver(BroadcastReceiver receiver) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("MqttService.callbackToActivity.v0");
        LocalBroadcastManager.getInstance((Context)this.myContext).registerReceiver(receiver, filter);
        this.receiverRegistered = true;
    }

    private void doConnect() {
        block3: {
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.setTraceEnabled(this.traceEnabled);
            this.mqttService.setTraceCallbackId(this.clientHandle);
            String activityToken = this.storeToken(this.connectToken);
            try {
                this.mqttService.connect(this.clientHandle, this.connectOptions, null, activityToken);
            }
            catch (MqttException e) {
                IMqttActionListener listener = this.connectToken.getActionCallback();
                if (listener == null) break block3;
                listener.onFailure(this.connectToken, e);
            }
        }
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, null, null);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, null, activityToken);
        return token;
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, null, null);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, quiesceTimeout, null, activityToken);
        return token;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, null, activityToken);
        return token;
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, quiesceTimeout, null, activityToken);
        return token;
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        MqttDeliveryTokenAndroid token = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        String activityToken = this.storeToken(token);
        IMqttDeliveryToken internalToken = this.mqttService.publish(this.clientHandle, topic, payload, qos, retained, null, activityToken);
        token.setDelegate(internalToken);
        return token;
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttDeliveryTokenAndroid token = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        String activityToken = this.storeToken(token);
        IMqttDeliveryToken internalToken = this.mqttService.publish(this.clientHandle, topic, message, null, activityToken);
        token.setDelegate(internalToken);
        return token;
    }

    @Override
    public IMqttToken subscribe(String topic, int qos) throws MqttException, MqttSecurityException {
        return this.subscribe(topic, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topic, int[] qos) throws MqttException, MqttSecurityException {
        return this.subscribe(topic, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String topic, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback, new String[]{topic});
        String activityToken = this.storeToken(token);
        this.mqttService.subscribe(this.clientHandle, topic, qos, null, activityToken);
        return token;
    }

    @Override
    public IMqttToken subscribe(String[] topic, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback, topic);
        String activityToken = this.storeToken(token);
        this.mqttService.subscribe(this.clientHandle, topic, qos, null, activityToken);
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(topicFilter, qos, null, null, messageListener);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback, IMqttMessageListener[] messageListeners) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback, topicFilters);
        String activityToken = this.storeToken(token);
        this.mqttService.subscribe(this.clientHandle, topicFilters, qos, null, activityToken, messageListeners);
        return null;
    }

    @Override
    public IMqttToken unsubscribe(String topic) throws MqttException {
        return this.unsubscribe(topic, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topic) throws MqttException {
        return this.unsubscribe(topic, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String topic, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.unsubscribe(this.clientHandle, topic, null, activityToken);
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String[] topic, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.unsubscribe(this.clientHandle, topic, null, activityToken);
        return token;
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.mqttService.getPendingDeliveryTokens(this.clientHandle);
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.callback = callback;
    }

    public void setTraceCallback(MqttTraceHandler traceCallback) {
        this.traceCallback = traceCallback;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        if (this.mqttService != null) {
            this.mqttService.setTraceEnabled(traceEnabled);
        }
    }

    public void onReceive(Context context, Intent intent) {
        Bundle data = intent.getExtras();
        String handleFromIntent = data.getString("MqttService.clientHandle");
        if (handleFromIntent == null || !handleFromIntent.equals(this.clientHandle)) {
            return;
        }
        String action = data.getString("MqttService.callbackAction");
        if ("connect".equals(action)) {
            this.connectAction(data);
        } else if ("connectExtended".equals(action)) {
            this.connectExtendedAction(data);
        } else if ("messageArrived".equals(action)) {
            this.messageArrivedAction(data);
        } else if ("subscribe".equals(action)) {
            this.subscribeAction(data);
        } else if ("unsubscribe".equals(action)) {
            this.unSubscribeAction(data);
        } else if ("send".equals(action)) {
            this.sendAction(data);
        } else if ("messageDelivered".equals(action)) {
            this.messageDeliveredAction(data);
        } else if ("onConnectionLost".equals(action)) {
            this.connectionLostAction(data);
        } else if ("disconnect".equals(action)) {
            this.disconnected(data);
        } else if ("trace".equals(action)) {
            this.traceAction(data);
        } else {
            this.mqttService.traceError("MqttService", "Callback action doesn't exist.");
        }
    }

    public boolean acknowledgeMessage(String messageId) {
        if (this.messageAck == Ack.MANUAL_ACK) {
            Status status = this.mqttService.acknowledgeMessageArrival(this.clientHandle, messageId);
            return status == Status.OK;
        }
        return false;
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        throw new UnsupportedOperationException();
    }

    private void connectAction(Bundle data) {
        IMqttToken token = this.connectToken;
        this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private void disconnected(Bundle data) {
        this.clientHandle = null;
        IMqttToken token = this.removeMqttToken(data);
        if (token != null) {
            ((MqttTokenAndroid)token).notifyComplete();
        }
        if (this.callback != null) {
            this.callback.connectionLost(null);
        }
    }

    private void connectionLostAction(Bundle data) {
        if (this.callback != null) {
            Exception reason = (Exception)data.getSerializable("MqttService.exception");
            this.callback.connectionLost(reason);
        }
    }

    private void connectExtendedAction(Bundle data) {
        if (this.callback instanceof MqttCallbackExtended) {
            boolean reconnect = data.getBoolean("MqttService.reconnect", false);
            String serverURI = data.getString("MqttService.serverURI");
            ((MqttCallbackExtended)this.callback).connectComplete(reconnect, serverURI);
        }
    }

    private void simpleAction(IMqttToken token, Bundle data) {
        if (token != null) {
            Status status = (Status)((Object)data.getSerializable("MqttService.callbackStatus"));
            if (status == Status.OK) {
                ((MqttTokenAndroid)token).notifyComplete();
            } else {
                Exception exceptionThrown = (Exception)data.getSerializable("MqttService.exception");
                ((MqttTokenAndroid)token).notifyFailure(exceptionThrown);
            }
        } else {
            this.mqttService.traceError("MqttService", "simpleAction : token is null");
        }
    }

    private void sendAction(Bundle data) {
        IMqttToken token = this.getMqttToken(data);
        this.simpleAction(token, data);
    }

    private void subscribeAction(Bundle data) {
        IMqttToken token = this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private void unSubscribeAction(Bundle data) {
        IMqttToken token = this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private void messageDeliveredAction(Bundle data) {
        Status status;
        IMqttToken token = this.removeMqttToken(data);
        if (token != null && this.callback != null && (status = (Status)((Object)data.getSerializable("MqttService.callbackStatus"))) == Status.OK && token instanceof IMqttDeliveryToken) {
            this.callback.deliveryComplete((IMqttDeliveryToken)token);
        }
    }

    private void messageArrivedAction(Bundle data) {
        if (this.callback != null) {
            String messageId = data.getString("MqttService.messageId");
            String destinationName = data.getString("MqttService.destinationName");
            ParcelableMqttMessage message = (ParcelableMqttMessage)data.getParcelable("MqttService.PARCEL");
            try {
                if (this.messageAck == Ack.AUTO_ACK) {
                    this.callback.messageArrived(destinationName, message);
                    this.mqttService.acknowledgeMessageArrival(this.clientHandle, messageId);
                } else {
                    message.messageId = messageId;
                    this.callback.messageArrived(destinationName, message);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void traceAction(Bundle data) {
        if (this.traceCallback != null) {
            String severity = data.getString("MqttService.traceSeverity");
            String message = data.getString("MqttService.errorMessage");
            String tag = data.getString("MqttService.traceTag");
            if ("debug".equals(severity)) {
                this.traceCallback.traceDebug(tag, message);
            } else if ("error".equals(severity)) {
                this.traceCallback.traceError(tag, message);
            } else {
                Exception e = (Exception)data.getSerializable("MqttService.exception");
                this.traceCallback.traceException(tag, message, e);
            }
        }
    }

    private synchronized String storeToken(IMqttToken token) {
        this.tokenMap.put(this.tokenNumber, (Object)token);
        return Integer.toString(this.tokenNumber++);
    }

    private synchronized IMqttToken removeMqttToken(Bundle data) {
        String activityToken = data.getString("MqttService.activityToken");
        if (activityToken != null) {
            int tokenNumber = Integer.parseInt(activityToken);
            IMqttToken token = (IMqttToken)this.tokenMap.get(tokenNumber);
            this.tokenMap.delete(tokenNumber);
            return token;
        }
        return null;
    }

    private synchronized IMqttToken getMqttToken(Bundle data) {
        String activityToken = data.getString("MqttService.activityToken");
        return (IMqttToken)this.tokenMap.get(Integer.parseInt(activityToken));
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.mqttService.setBufferOpts(this.clientHandle, bufferOpts);
    }

    public int getBufferedMessageCount() {
        return this.mqttService.getBufferedMessageCount(this.clientHandle);
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.mqttService.getBufferedMessage(this.clientHandle, bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.mqttService.deleteBufferedMessage(this.clientHandle, bufferIndex);
    }

    public SSLSocketFactory getSSLSocketFactory(InputStream keyStore, String password) throws MqttSecurityException {
        try {
            SSLContext ctx = null;
            SSLSocketFactory sslSockFactory = null;
            KeyStore ts = KeyStore.getInstance("BKS");
            ts.load(keyStore, password.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(ts);
            TrustManager[] tm = tmf.getTrustManagers();
            ctx = SSLContext.getInstance("TLSv1");
            ctx.init(null, tm, null);
            sslSockFactory = ctx.getSocketFactory();
            return sslSockFactory;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new MqttSecurityException(e);
        }
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResources() {
        if (this.myContext != null && this.receiverRegistered) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                LocalBroadcastManager.getInstance((Context)this.myContext).unregisterReceiver((BroadcastReceiver)this);
                this.receiverRegistered = false;
            }
            if (this.bindedService) {
                try {
                    this.myContext.unbindService((ServiceConnection)this.serviceConnection);
                    this.bindedService = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void startKeepConnect(long repeatTime, long triggerTime) {
        this.mqttService.startKeepConnect(repeatTime, triggerTime);
    }

    public void stopKeepConnect() {
        this.mqttService.stopKeepConnect();
    }

    public boolean isKeepConnect() {
        return this.clientHandle == null ? false : (this.mqttService == null ? false : this.mqttService.containClient(this.clientHandle));
    }

    public void registerResources(Context context) {
        if (context != null) {
            this.myContext = context;
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        }
    }

    private final class MyServiceConnection
    implements ServiceConnection {
        private MyServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder binder) {
            MqttAndroidClient.this.mqttService = ((MqttServiceBinder)binder).getService();
            MqttAndroidClient.this.bindedService = true;
            MqttAndroidClient.this.doConnect();
        }

        public void onServiceDisconnected(ComponentName name) {
            MqttAndroidClient.this.mqttService = null;
        }
    }

    public static enum Ack {
        AUTO_ACK,
        MANUAL_ACK;

    }
}

