/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.connect;

import android.content.Context;
import com.adups.mqtt_libs.connect.ConnectCommand;
import com.adups.mqtt_libs.connect.DisconnectCommand;
import com.adups.mqtt_libs.connect.PubCommand;
import com.adups.mqtt_libs.connect.SubCommand;
import com.adups.mqtt_libs.connect.UnsubCommand;
import com.adups.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.trace.Trace;

public class MqttManager {
    private static MqttManager instance = null;
    private static final String TAG = "ConnectManager";
    public static Context sCx;
    private ConnectCommand mConnect;
    private MqttCallback messageListener;
    private MqttTraceHandler mTraceListener;
    private boolean mTraceEnable;

    private MqttManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized MqttManager getInstance() {
        if (instance != null) return instance;
        Class<MqttManager> clazz = MqttManager.class;
        synchronized (MqttManager.class) {
            if (instance != null) return instance;
            instance = new MqttManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setContext(Context context) {
        sCx = context;
    }

    public void connect(ConnectCommand connect, IMqttActionListener listener) throws MqttException {
        if (null != this.messageListener) {
            connect.setMessageListener(this.messageListener);
        }
        if (null != this.mTraceListener) {
            connect.setTraceCallback(this.mTraceListener);
        }
        connect.setTraceEnabled(this.mTraceEnable);
        this.mConnect = connect;
        connect.execute(listener);
    }

    public void registerMessageListener(MqttCallback listener) {
        this.messageListener = listener;
    }

    public void registerTraceListener(MqttTraceHandler traceHandler) {
        this.mTraceListener = traceHandler;
    }

    public void setTraceEnable(boolean enable) {
        this.mTraceEnable = enable;
        if (null == this.mConnect) {
            return;
        }
        this.getConnect().setTraceEnabled(enable);
    }

    public void disConnect(DisconnectCommand command, IMqttActionListener listener) throws MqttException {
        command.execute(listener);
    }

    public void pub(PubCommand command, IMqttActionListener listener) throws MqttException {
        command.execute(listener);
    }

    public void sub(SubCommand command, IMqttActionListener listener) throws MqttException {
        command.execute(listener);
    }

    public void unSub(UnsubCommand command, IMqttActionListener listener) throws MqttException {
        command.execute(listener);
    }

    public ConnectCommand getConnect() {
        return this.mConnect;
    }

    public boolean isConneect() {
        if (this.getConnect() == null) {
            return false;
        }
        if (null == this.getConnect().getClient()) {
            return false;
        }
        try {
            return this.getConnect().getClient().isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void keepConnect(long repeatTime, long triggerTime) {
        if (null == this.getConnect()) {
            return;
        }
        if (null == this.getConnect().getClient()) {
            return;
        }
        try {
            this.getConnect().getClient().startKeepConnect(repeatTime, triggerTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isKeepConnect() {
        if (this.getConnect() == null) {
            return false;
        }
        if (null == this.getConnect().getClient()) {
            return false;
        }
        return this.getConnect().getClient().isKeepConnect();
    }

    public void stopKeepConnect() {
        if (this.isKeepConnect()) {
            Trace.d((String)TAG, (String)"stopKeepConnect() will stop keep-connect-service");
            this.getConnect().getClient().stopKeepConnect();
        }
    }
}

