/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.connect;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.adups.mqtt_libs.connect.Command;
import com.adups.mqtt_libs.connect.MqttManager;
import com.adups.mqtt_libs.mqtt_service.MqttAndroidClient;
import com.adups.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttConnectOptions;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttSecurityException;
import com.adups.trace.Trace;
import java.io.InputStream;

public class ConnectCommand
implements Command {
    private static final String TAG = "ConnectCommand";
    private String mServer;
    private int mPort;
    private String lastWillMsg;
    private String lastWillTopic;
    private int mTimeout;
    private int mKeepAlive;
    private String mUserName;
    private String mUserPassword;
    private boolean mCleanSession;
    private String mClientId;
    private String mSslKeyPath;
    private String mSslKeyPassword;
    private MqttAndroidClient client;
    private int lastWillQos;
    private boolean lastWillRetained;
    private MqttCallback mMessageListener;
    private boolean traceEnabled = false;
    private MqttTraceHandler mTraceCallback;
    private static ConnectCommand connectCommand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectCommand getInstance() {
        if (connectCommand != null) return connectCommand;
        Class<ConnectCommand> clazz = ConnectCommand.class;
        synchronized (ConnectCommand.class) {
            if (connectCommand != null) return connectCommand;
            connectCommand = new ConnectCommand();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectCommand;
        }
    }

    public ConnectCommand setClientId(String clientId) {
        this.mClientId = clientId;
        return this;
    }

    public ConnectCommand setServer(String server) {
        this.mServer = server;
        return this;
    }

    public ConnectCommand setPort(int port) {
        this.mPort = port;
        return this;
    }

    public ConnectCommand setLastWill(String msg, String topic, int qos, boolean retained) {
        this.lastWillMsg = msg;
        this.lastWillTopic = topic;
        this.lastWillQos = qos;
        this.lastWillRetained = retained;
        return this;
    }

    public ConnectCommand setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public ConnectCommand setKeepAlive(int keepAlive) {
        this.mKeepAlive = keepAlive;
        return this;
    }

    public ConnectCommand setCleanSession(boolean cleanSession) {
        this.mCleanSession = cleanSession;
        return this;
    }

    public ConnectCommand setUserNameAndPassword(String userName, String password) {
        this.mUserName = userName;
        this.mUserPassword = password;
        return this;
    }

    public MqttAndroidClient getClient() {
        return this.client;
    }

    public ConnectCommand setSsl(String sslKeyPath, String sslKeyPassword) {
        this.mSslKeyPath = sslKeyPath;
        this.mSslKeyPassword = sslKeyPassword;
        return this;
    }

    public ConnectCommand setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public ConnectCommand setTraceCallback(MqttTraceHandler traceCallback) {
        this.mTraceCallback = traceCallback;
        return this;
    }

    public void setMessageListener(MqttCallback listener) {
        this.mMessageListener = listener;
    }

    public void connect() {
    }

    private String getUri() {
        String uri = TextUtils.isEmpty((CharSequence)this.mSslKeyPath) ? "tcp://" : "ssl://";
        uri = uri + this.mServer + ":" + this.mPort;
        return uri;
    }

    private MqttAndroidClient createClient(Context context, String serverURI, String clientId) {
        MqttAndroidClient client = new MqttAndroidClient(context, serverURI, clientId);
        return client;
    }

    @Override
    public void execute(IMqttActionListener listener) throws MqttException {
        MqttConnectOptions conOpt = new MqttConnectOptions();
        String uri = this.getUri();
        if (null == this.client) {
            this.client = this.createClient(MqttManager.sCx, uri, this.mClientId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSslKeyPath)) {
            try {
                InputStream key = this.getClass().getResourceAsStream(this.mSslKeyPath);
                conOpt.setSocketFactory(this.client.getSSLSocketFactory(key, this.mSslKeyPassword));
            }
            catch (MqttSecurityException e) {
                Log.e((String)this.getClass().getCanonicalName(), (String)"MqttException Occured: ", (Throwable)e);
            }
        }
        conOpt.setCleanSession(this.mCleanSession);
        conOpt.setConnectionTimeout(this.mTimeout);
        conOpt.setKeepAliveInterval(this.mKeepAlive);
        if (!TextUtils.isEmpty((CharSequence)this.mUserName)) {
            conOpt.setUserName(this.mUserName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserPassword)) {
            conOpt.setPassword(this.mUserPassword.toCharArray());
        }
        boolean doConnect = true;
        if (!TextUtils.isEmpty((CharSequence)this.lastWillMsg) || !TextUtils.isEmpty((CharSequence)this.lastWillTopic)) {
            try {
                conOpt.setWill(this.lastWillTopic, this.lastWillMsg.getBytes(), this.lastWillQos, this.lastWillRetained);
            }
            catch (Exception e) {
                Trace.d((String)TAG, (String)("connect() Exception Occured\uff1a" + e.toString()));
                doConnect = false;
            }
        }
        this.client.setCallback(this.mMessageListener);
        if (this.traceEnabled) {
            this.client.setTraceCallback(this.mTraceCallback);
        }
        if (doConnect) {
            try {
                this.client.connect(conOpt, null, listener);
            }
            catch (MqttException e) {
                Trace.d((String)TAG, (String)("connect() MqttException Occured:" + e.toString()));
            }
        }
    }
}

