/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqtt_service;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import com.adups.mqtt_libs.mqtt_service.MqttService;
import com.adups.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.adups.mqtt_libs.mqtt_service.ParcelableMqttMessage;
import com.adups.mqtt_libs.mqtt_service.e;
import com.adups.mqtt_libs.mqtt_service.f;
import com.adups.mqtt_libs.mqtt_service.g;
import com.adups.mqtt_libs.mqtt_service.h;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.IMqttToken;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttMessage;
import com.adups.mqtt_libs.mqttv3.c;
import com.adups.mqtt_libs.mqttv3.d;
import com.adups.mqtt_libs.mqttv3.i;
import com.adups.trace.Trace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MqttAndroidClient
extends BroadcastReceiver
implements com.adups.mqtt_libs.mqttv3.a {
    private static final String SERVICE_NAME = MqttService.class.getName();
    private static final int BIND_SERVICE_FLAG = 0;
    private static ExecutorService pool = Executors.newCachedThreadPool();
    private b serviceConnection = new b();
    private MqttService mqttService;
    private String clientHandle;
    Context myContext;
    private SparseArray<IMqttToken> tokenMap = new SparseArray();
    private int tokenNumber = 0;
    private String serverURI;
    private String clientId;
    private c persistence = null;
    private d connectOptions;
    private IMqttToken connectToken;
    private MqttCallback callback;
    private MqttTraceHandler traceCallback;
    private a messageAck;
    private boolean traceEnabled = false;
    private volatile boolean registerReceiver = false;
    private volatile boolean bindedService = false;
    private static final String TAG = "MqttAndroidClient";
    private IntentFilter filter;

    public MqttAndroidClient(Context context, String string, String string2) {
        this(context, string, string2, null, a.a);
    }

    public MqttAndroidClient(Context context, String string, String string2, a a2) {
        this(context, string, string2, null, a2);
    }

    public MqttAndroidClient(Context context, String string, String string2, c c2) {
        this(context, string, string2, c2, a.a);
    }

    public MqttAndroidClient(Context context, String string, String string2, c c2, a a2) {
        this.myContext = context;
        this.serverURI = string;
        this.clientId = string2;
        this.persistence = c2;
        this.messageAck = a2;
    }

    public boolean isConnected() {
        return this.clientHandle == null ? false : (this.mqttService != null ? this.mqttService.isConnected(this.clientHandle) : false);
    }

    public boolean isKeepConnect() {
        return this.clientHandle == null ? false : (this.mqttService == null ? false : this.mqttService.containClient(this.clientHandle));
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        if (this.clientHandle == null) {
            this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
        }
        this.mqttService.close(this.clientHandle);
    }

    public IMqttToken connect() throws MqttException {
        return this.connect(null, null);
    }

    public IMqttToken connect(d d2) throws MqttException {
        return this.connect(d2, null, null);
    }

    public IMqttToken connect(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        return this.connect(new d(), object, iMqttActionListener);
    }

    public IMqttToken connect(d d2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        this.connectOptions = d2;
        this.connectToken = g2;
        if (this.mqttService == null) {
            IMqttActionListener iMqttActionListener2;
            Intent intent = new Intent();
            intent.setClassName(this.myContext, MqttService.class.getName());
            ComponentName componentName = this.myContext.startService(intent);
            if (componentName == null && (iMqttActionListener2 = g2.getActionCallback()) != null) {
                iMqttActionListener2.onFailure(g2, new RuntimeException(MqttService.class.getName()));
            }
            this.myContext.startService(intent);
            this.myContext.bindService(intent, (ServiceConnection)this.serviceConnection, 1);
            this.registerReceiver(this);
        } else {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MqttAndroidClient.this.doConnect();
                    MqttAndroidClient.this.registerReceiver(MqttAndroidClient.this);
                }
            });
        }
        return g2;
    }

    private void registerReceiver(BroadcastReceiver broadcastReceiver) {
        if (null == this.filter) {
            this.filter = new IntentFilter();
            this.filter.addAction("MqttService.callbackToActivity.v0");
            LocalBroadcastManager.getInstance((Context)this.myContext).registerReceiver(broadcastReceiver, this.filter);
            this.registerReceiver = true;
        }
    }

    private void doConnect() {
        block3: {
            Trace.d((String)TAG, (String)"doConnect() start.");
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.setTraceEnabled(this.traceEnabled);
            this.mqttService.setTraceCallbackId(this.clientHandle);
            String string = this.storeToken(this.connectToken);
            try {
                this.mqttService.connect(this.clientHandle, this.connectOptions, null, string);
            }
            catch (MqttException mqttException) {
                IMqttActionListener iMqttActionListener = this.connectToken.getActionCallback();
                if (iMqttActionListener == null) break block3;
                iMqttActionListener.onFailure(this.connectToken, mqttException);
            }
        }
    }

    public IMqttToken disconnect() throws MqttException {
        g g2 = new g(this, null, null);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, null, string);
        return g2;
    }

    public IMqttToken disconnect(long l2) throws MqttException {
        g g2 = new g(this, null, null);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, l2, null, string);
        return g2;
    }

    public IMqttToken disconnect(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, null, string);
        return g2;
    }

    public IMqttToken disconnect(long l2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string = this.storeToken(g2);
        this.mqttService.disconnect(this.clientHandle, l2, null, string);
        return g2;
    }

    public IMqttDeliveryToken publish(String string, byte[] byArray, int n2, boolean bl) throws MqttException, com.adups.mqtt_libs.mqttv3.g {
        return this.publish(string, byArray, n2, bl, null, null);
    }

    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage) throws MqttException, com.adups.mqtt_libs.mqttv3.g {
        return this.publish(string, mqttMessage, null, null);
    }

    public IMqttDeliveryToken publish(String string, byte[] byArray, int n2, boolean bl, Object object, IMqttActionListener iMqttActionListener) throws MqttException, com.adups.mqtt_libs.mqttv3.g {
        try {
            MqttMessage mqttMessage = new MqttMessage(byArray);
            mqttMessage.setQos(n2);
            mqttMessage.setRetained(bl);
            e e2 = new e(this, object, iMqttActionListener, mqttMessage);
            String string2 = this.storeToken(e2);
            IMqttDeliveryToken iMqttDeliveryToken = this.mqttService.publish(this.clientHandle, string, byArray, n2, bl, null, string2);
            e2.a(iMqttDeliveryToken);
            return e2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage, Object object, IMqttActionListener iMqttActionListener) throws MqttException, com.adups.mqtt_libs.mqttv3.g {
        e e2 = new e(this, object, iMqttActionListener, mqttMessage);
        String string2 = this.storeToken(e2);
        IMqttDeliveryToken iMqttDeliveryToken = this.mqttService.publish(this.clientHandle, string, mqttMessage, null, string2);
        e2.a(iMqttDeliveryToken);
        return e2;
    }

    public IMqttToken subscribe(String string, int n2) throws MqttException, i {
        return this.subscribe(string, n2, null, (IMqttActionListener)null);
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray) throws MqttException, i {
        return this.subscribe(stringArray, nArray, null, (IMqttActionListener)null);
    }

    public IMqttToken subscribe(String string, int n2, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener, new String[]{string});
        String string2 = this.storeToken(g2);
        this.mqttService.subscribe(this.clientHandle, string, n2, (String)null, string2);
        return g2;
    }

    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener, stringArray);
        String string = this.storeToken(g2);
        this.mqttService.subscribe(this.clientHandle, stringArray, nArray, (String)null, string);
        return g2;
    }

    public IMqttToken unsubscribe(String string) throws MqttException {
        return this.unsubscribe(string, null, (IMqttActionListener)null);
    }

    public IMqttToken unsubscribe(String[] stringArray) throws MqttException {
        return this.unsubscribe(stringArray, null, (IMqttActionListener)null);
    }

    public IMqttToken unsubscribe(String string, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string2 = this.storeToken(g2);
        this.mqttService.unsubscribe(this.clientHandle, string, (String)null, string2);
        return g2;
    }

    public IMqttToken unsubscribe(String[] stringArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        g g2 = new g(this, object, iMqttActionListener);
        String string = this.storeToken(g2);
        this.mqttService.unsubscribe(this.clientHandle, stringArray, (String)null, string);
        return g2;
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.mqttService.getPendingDeliveryTokens(this.clientHandle);
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback = mqttCallback;
    }

    public void setTraceCallback(MqttTraceHandler mqttTraceHandler) {
        this.traceCallback = mqttTraceHandler;
    }

    public void setTraceEnabled(boolean bl) {
        this.traceEnabled = bl;
        if (this.mqttService != null) {
            this.mqttService.setTraceEnabled(bl);
        }
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        String string = bundle.getString("MqttService.clientHandle");
        if (string != null && string.equals(this.clientHandle)) {
            String string2 = bundle.getString("MqttService.callbackAction");
            if ("connect".equals(string2)) {
                this.connectAction(bundle);
            } else if ("messageArrived".equals(string2)) {
                this.messageArrivedAction(bundle);
            } else if ("subscribe".equals(string2)) {
                this.subscribeAction(bundle);
            } else if ("unsubscribe".equals(string2)) {
                this.unSubscribeAction(bundle);
            } else if ("send".equals(string2)) {
                this.sendAction(bundle);
            } else if ("messageDelivered".equals(string2)) {
                this.messageDeliveredAction(bundle);
            } else if ("onConnectionLost".equals(string2)) {
                this.connectionLostAction(bundle);
            } else if ("disconnect".equals(string2)) {
                this.disconnected(bundle);
            } else if ("trace".equals(string2)) {
                this.traceAction(bundle);
            } else {
                this.mqttService.traceError("MqttService", "Callback action doesn't exist.");
            }
        }
    }

    public boolean acknowledgeMessage(String string) {
        if (this.messageAck == a.b) {
            h h2 = this.mqttService.acknowledgeMessageArrival(this.clientHandle, string);
            return h2 == h.a;
        }
        return false;
    }

    private void connectAction(Bundle bundle) {
        IMqttToken iMqttToken = this.connectToken;
        this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void disconnected(Bundle bundle) {
        this.clientHandle = null;
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        if (iMqttToken != null) {
            ((g)iMqttToken).a();
        }
        if (this.callback != null) {
            this.callback.connectionLost(null);
        }
    }

    private void connectionLostAction(Bundle bundle) {
        if (this.callback != null) {
            Exception exception = (Exception)bundle.getSerializable("MqttService.exception");
            this.callback.connectionLost(exception);
        }
    }

    private void simpleAction(IMqttToken iMqttToken, Bundle bundle) {
        if (iMqttToken != null) {
            h h2 = (h)((Object)bundle.getSerializable("MqttService.callbackStatus"));
            if (h2 == h.a) {
                ((g)iMqttToken).a();
            } else {
                Exception exception = (Exception)bundle.getSerializable("MqttService.exception");
                ((g)iMqttToken).a(exception);
            }
        } else {
            this.mqttService.traceError("MqttService", "simpleAction : token is null");
        }
    }

    private void sendAction(Bundle bundle) {
        IMqttToken iMqttToken = this.getMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void subscribeAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void unSubscribeAction(Bundle bundle) {
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        this.simpleAction(iMqttToken, bundle);
    }

    private void messageDeliveredAction(Bundle bundle) {
        h h2;
        IMqttToken iMqttToken = this.removeMqttToken(bundle);
        if (iMqttToken != null && this.callback != null && (h2 = (h)((Object)bundle.getSerializable("MqttService.callbackStatus"))) == h.a) {
            this.callback.deliveryComplete((IMqttDeliveryToken)iMqttToken);
        }
    }

    private void messageArrivedAction(Bundle bundle) {
        if (this.callback != null) {
            String string = bundle.getString("MqttService.messageId");
            String string2 = bundle.getString("MqttService.destinationName");
            ParcelableMqttMessage parcelableMqttMessage = (ParcelableMqttMessage)bundle.getParcelable("MqttService.PARCEL");
            try {
                if (this.messageAck == a.a) {
                    this.callback.messageArrived(string2, parcelableMqttMessage);
                    this.mqttService.acknowledgeMessageArrival(this.clientHandle, string);
                } else {
                    parcelableMqttMessage.a = string;
                    this.callback.messageArrived(string2, parcelableMqttMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void traceAction(Bundle bundle) {
        if (this.traceCallback != null) {
            String string = bundle.getString("MqttService.traceSeverity");
            String string2 = bundle.getString("MqttService.errorMessage");
            String string3 = bundle.getString("MqttService.traceTag");
            if ("debug".equals(string)) {
                this.traceCallback.traceDebug(string3, string2);
            } else if ("error".equals(string)) {
                this.traceCallback.traceError(string3, string2);
            } else {
                Exception exception = (Exception)bundle.getSerializable("MqttService.exception");
                this.traceCallback.traceException(string3, string2, exception);
            }
        }
    }

    private synchronized String storeToken(IMqttToken iMqttToken) {
        this.tokenMap.put(this.tokenNumber, (Object)iMqttToken);
        return Integer.toString(this.tokenNumber++);
    }

    private synchronized IMqttToken removeMqttToken(Bundle bundle) {
        String string = bundle.getString("MqttService.activityToken");
        if (string != null) {
            int n2 = Integer.parseInt(string);
            IMqttToken iMqttToken = (IMqttToken)this.tokenMap.get(n2);
            this.tokenMap.delete(n2);
            return iMqttToken;
        }
        return null;
    }

    private synchronized IMqttToken getMqttToken(Bundle bundle) {
        String string = bundle.getString("MqttService.activityToken");
        IMqttToken iMqttToken = (IMqttToken)this.tokenMap.get(Integer.parseInt(string));
        return iMqttToken;
    }

    public SSLSocketFactory getSSLSocketFactory(InputStream inputStream, String string) throws i {
        try {
            SSLContext sSLContext = null;
            SSLSocketFactory sSLSocketFactory = null;
            KeyStore keyStore = KeyStore.getInstance("BKS");
            keyStore.load(inputStream, string.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (KeyStoreException keyStoreException) {
            throw new i(keyStoreException);
        }
        catch (CertificateException certificateException) {
            throw new i(certificateException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new i(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new i(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new i(noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new i(keyManagementException);
        }
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long l2) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long l2, long l3) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void startKeepConnect(long l2, long l3) {
        this.mqttService.startKeepConnect(l2, l3);
    }

    public void stopKeepConnect() {
        this.mqttService.stopKeepConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResources() {
        if (this.myContext != null && this.registerReceiver) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                LocalBroadcastManager.getInstance((Context)this.myContext).unregisterReceiver((BroadcastReceiver)this);
                this.registerReceiver = false;
            }
            if (this.bindedService) {
                try {
                    this.myContext.unbindService((ServiceConnection)this.serviceConnection);
                    this.bindedService = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void registerResources(Context context) {
        if (context != null) {
            this.myContext = context;
            if (!this.registerReceiver) {
                this.registerReceiver(this);
            }
        }
    }

    public static enum a {
        a,
        b;

    }

    private final class b
    implements ServiceConnection {
        private b() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            MqttAndroidClient.this.mqttService = ((f)iBinder).a();
            MqttAndroidClient.this.bindedService = true;
            MqttAndroidClient.this.doConnect();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            MqttAndroidClient.this.mqttService = null;
        }
    }
}

