/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.connect;

import android.content.Context;
import com.adups.mqtt_libs.connect.ConnectCommand;
import com.adups.mqtt_libs.connect.DisconnectCommand;
import com.adups.mqtt_libs.connect.PubCommand;
import com.adups.mqtt_libs.connect.SubCommand;
import com.adups.mqtt_libs.connect.UnsubCommand;
import com.adups.mqtt_libs.mqtt_service.MqttTraceHandler;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.trace.Trace;

public class MqttManager {
    private static MqttManager instance = null;
    private static final String TAG = "ConnectManager";
    public static Context sCx;
    private ConnectCommand mConnect;
    private MqttCallback messageListener;
    private MqttTraceHandler mTraceListener;
    private boolean mTraceEnable;

    private MqttManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized MqttManager getInstance() {
        if (instance != null) return instance;
        Class<MqttManager> clazz = MqttManager.class;
        synchronized (MqttManager.class) {
            if (instance != null) return instance;
            instance = new MqttManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setContext(Context context) {
        sCx = context;
    }

    public void connect(ConnectCommand connectCommand, IMqttActionListener iMqttActionListener) throws MqttException {
        if (null != this.messageListener) {
            connectCommand.setMessageListener(this.messageListener);
        }
        if (null != this.mTraceListener) {
            connectCommand.setTraceCallback(this.mTraceListener);
        }
        connectCommand.setTraceEnabled(this.mTraceEnable);
        this.mConnect = connectCommand;
        connectCommand.execute(iMqttActionListener);
    }

    public void registerMessageListener(MqttCallback mqttCallback) {
        this.messageListener = mqttCallback;
    }

    public void registerTraceListener(MqttTraceHandler mqttTraceHandler) {
        this.mTraceListener = mqttTraceHandler;
    }

    public void setTraceEnable(boolean bl) {
        this.mTraceEnable = bl;
        if (null == this.mConnect) {
            return;
        }
        this.getConnect().setTraceEnabled(bl);
    }

    public void disConnect(DisconnectCommand disconnectCommand, IMqttActionListener iMqttActionListener) throws MqttException {
        disconnectCommand.execute(iMqttActionListener);
    }

    public void pub(PubCommand pubCommand, IMqttActionListener iMqttActionListener) throws MqttException {
        pubCommand.execute(iMqttActionListener);
    }

    public void sub(SubCommand subCommand, IMqttActionListener iMqttActionListener) throws MqttException {
        subCommand.execute(iMqttActionListener);
    }

    public void unSub(UnsubCommand unsubCommand, IMqttActionListener iMqttActionListener) throws MqttException {
        unsubCommand.execute(iMqttActionListener);
    }

    public ConnectCommand getConnect() {
        return this.mConnect;
    }

    public boolean isConneect() {
        if (this.getConnect() == null) {
            return false;
        }
        if (null == this.getConnect().getClient()) {
            return false;
        }
        try {
            return this.getConnect().getClient().isConnected();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void keepConnect(long l2, long l3) {
        if (null == this.getConnect()) {
            return;
        }
        if (null == this.getConnect().getClient()) {
            return;
        }
        try {
            this.getConnect().getClient().startKeepConnect(l2, l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isKeepConnect() {
        if (this.getConnect() == null) {
            return false;
        }
        if (null == this.getConnect().getClient()) {
            return false;
        }
        return this.getConnect().getClient().isKeepConnect();
    }

    public void stopKeepConnect() {
        if (this.isKeepConnect()) {
            Trace.d((String)TAG, (String)"stopKeepConnect() will stop keep-connect-service");
            this.getConnect().getClient().stopKeepConnect();
        }
    }
}

