/*
 * Decompiled with CFR 0.152.
 */
package com.adups.mqtt_libs.mqttv3;

import com.adups.mqtt_libs.mqttv3.a.k;

public class MqttException
extends Exception {
    private static final long serialVersionUID = 300L;
    public static final short REASON_CODE_CLIENT_EXCEPTION = 0;
    public static final short REASON_CODE_INVALID_PROTOCOL_VERSION = 1;
    public static final short REASON_CODE_INVALID_CLIENT_ID = 2;
    public static final short REASON_CODE_BROKER_UNAVAILABLE = 3;
    public static final short REASON_CODE_FAILED_AUTHENTICATION = 4;
    public static final short REASON_CODE_NOT_AUTHORIZED = 5;
    public static final short REASON_CODE_UNEXPECTED_ERROR = 6;
    public static final short REASON_CONNECT_NOT_REGISTER = 7;
    public static final short REASON_CODE_SUBSCRIBE_FAILED = 128;
    public static final short REASON_CODE_CLIENT_TIMEOUT = 32000;
    public static final short REASON_CODE_NO_MESSAGE_IDS_AVAILABLE = 32001;
    public static final short REASON_CODE_WRITE_TIMEOUT = 32002;
    public static final short REASON_CODE_CLIENT_CONNECTED = 32100;
    public static final short REASON_CODE_CLIENT_ALREADY_DISCONNECTED = 32101;
    public static final short REASON_CODE_CLIENT_DISCONNECTING = 32102;
    public static final short REASON_CODE_SERVER_CONNECT_ERROR = 32103;
    public static final short REASON_CODE_CLIENT_NOT_CONNECTED = 32104;
    public static final short REASON_CODE_SOCKET_FACTORY_MISMATCH = 32105;
    public static final short REASON_CODE_SSL_CONFIG_ERROR = 32106;
    public static final short REASON_CODE_CLIENT_DISCONNECT_PROHIBITED = 32107;
    public static final short REASON_CODE_INVALID_MESSAGE = 32108;
    public static final short REASON_CODE_CONNECTION_LOST = 32109;
    public static final short REASON_CODE_CONNECT_IN_PROGRESS = 32110;
    public static final short REASON_CODE_CLIENT_CLOSED = 32111;
    public static final short REASON_CODE_TOKEN_INUSE = 32201;
    public static final short REASON_CODE_MAX_INFLIGHT = 32202;
    private int reasonCode;
    private Throwable cause;

    public MqttException(int n2) {
        this.reasonCode = n2;
    }

    public MqttException(Throwable throwable) {
        this.reasonCode = 0;
        this.cause = throwable;
    }

    public MqttException(int n2, Throwable throwable) {
        this.reasonCode = n2;
        this.cause = throwable;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        return k.a(this.reasonCode);
    }

    @Override
    public String toString() {
        String string = this.getMessage() + " (" + this.reasonCode + ")";
        if (this.cause != null) {
            string = string + " - " + this.cause.toString();
        }
        return string;
    }

    public static String getErrorMessage(int n2) {
        switch (n2) {
            case 1: {
                return "Invalid protocol version";
            }
            case 2: {
                return "Invalid client ID";
            }
            case 3: {
                return "Broker unavailable";
            }
            case 4: {
                return "Bad user name or password";
            }
            case 5: {
                return "Not authorized to connect";
            }
            case 6: {
                return "Unexpected error";
            }
            case 32000: {
                return "Timed out waiting for a response from the server";
            }
            case 32001: {
                return "Internal error, caused by no new message IDs being available";
            }
            case 32002: {
                return "Timed out while waiting to write messages to the server";
            }
            case 32100: {
                return "Client is connected";
            }
            case 32101: {
                return "Client is disconnected";
            }
            case 32102: {
                return "Client is currently disconnecting";
            }
            case 32103: {
                return "Unable to connect to server";
            }
            case 32104: {
                return "Client is not connected";
            }
            case 32105: {
                return "The specified SocketFactory type does not match the broker URI";
            }
            case 32106: {
                return "SSL configuration error";
            }
            case 32107: {
                return "Disconnecting is not allowed from a callback method";
            }
            case 32108: {
                return "Unrecognized packet";
            }
            case 32109: {
                return "Connection lost";
            }
            case 32110: {
                return "Connect already in progress";
            }
            case 32111: {
                return "Client is closed";
            }
            case 32200: {
                return "Persistence already in use";
            }
            case 32201: {
                return "Token already in use";
            }
            case 32202: {
                return "Too many publishes in progress";
            }
        }
        return "Unexpected error";
    }
}

