/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.policy;

import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.StatFs;
import android.util.Pair;
import com.abupdate.iot_libs.constant.OtaConstants;
import com.abupdate.iot_libs.info.PolicyMapInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.IParsePolicyListener;
import com.abupdate.iot_libs.policy.PolicyConfig;
import com.abupdate.iot_libs.utils.c;
import com.abupdate.iot_libs.utils.i;
import com.abupdate.trace.Trace;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

public class PolicyManager {
    private static final String TAG = "PolicyManager";
    public static PolicyManager INSTANCE = new PolicyManager();

    private PolicyManager() {
    }

    private boolean getInfoByKey(String string) {
        try {
            PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get(string);
            return policyMapInfo != null && "true".equals(policyMapInfo.key_value);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private long getStorageSpace(String string) {
        Trace.d((String)TAG, (String)("getStorageSpace() [path] " + string));
        String string2 = new File(string).getParentFile().getAbsolutePath();
        if (c.a(string2)) {
            long l;
            long l2;
            StatFs statFs;
            string = statFs;
            statFs = new StatFs(string2);
            if (Build.VERSION.SDK_INT >= 18) {
                String string3 = string;
                l2 = string3.getBlockSizeLong();
                l = string3.getAvailableBlocksLong();
            } else {
                String string4 = string;
                l2 = string4.getBlockSize();
                l = string4.getBlockCount();
            }
            return l2 * l;
        }
        throw new IllegalArgumentException("Invalid path:" + string);
    }

    public boolean is_request_wifi() {
        if (!PolicyConfig.getInstance().wifi) {
            return false;
        }
        Object object = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_wifi");
        if (object != null) {
            return object.doParse();
        }
        object = VersionInfo.getInstance().policyHashMap.get("download_wifi");
        if (object != null) {
            if ("required".equals(((PolicyMapInfo)object).key_value)) {
                return true;
            }
            Trace.d((String)TAG, (String)"is_request_wifi()");
        }
        return false;
    }

    public boolean is_storage_space_enough(String string) {
        if (!PolicyConfig.getInstance().storage_size) {
            return true;
        }
        Object object = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_storageSize");
        if (object != null) {
            return object.doParse();
        }
        object = VersionInfo.getInstance().policyHashMap.get("download_storageSize");
        if (object != null) {
            long l;
            Object object2;
            try {
                object2 = object;
                l = objectArray2.getStorageSpace(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            int n = 0;
            objectArray2[n] = ((PolicyMapInfo)object).key_value;
            n = 1;
            objectArray[n] = l;
            objectArray[2] = string;
            Trace.i((String)TAG, (String)String.format("is_storage_space_enough() need_size = %s,free_size = %s,path = %s", objectArray));
            return Long.parseLong(((PolicyMapInfo)object2).key_value) <= l;
        }
        return true;
    }

    public String get_storage_path() {
        if (!PolicyConfig.getInstance().storage_path) {
            return null;
        }
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("download_storagePath");
        if (policyMapInfo != null) {
            return policyMapInfo.key_value;
        }
        return null;
    }

    public boolean is_battery_enough(Context context) {
        if (!PolicyConfig.getInstance().battery) {
            return true;
        }
        Object object = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_battery");
        if (object != null) {
            return object.doParse();
        }
        object = VersionInfo.getInstance().policyHashMap.get("install_battery");
        if (object != null) {
            IntentFilter intentFilter;
            Context context2 = context;
            context = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            int n = context2.registerReceiver(null, (IntentFilter)context).getIntExtra("level", -1);
            Trace.d((String)TAG, (String)("batteryLevel mobile = " + n + "  config = " + ((PolicyMapInfo)object).key_value));
            try {
                return n >= Integer.parseInt(((PolicyMapInfo)object).key_value);
            }
            catch (Exception exception) {
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return true;
    }

    public boolean is_force_install() {
        if (!PolicyConfig.getInstance().install_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_force");
        if (iParsePolicyListener != null) {
            return iParsePolicyListener.doParse();
        }
        return (this = this.getForceInstallTime()) != null && i.a(new SimpleDateFormat("HH:mm").format(new Date()), (Date)this.first, (Date)this.second);
    }

    public int get_check_cycle() {
        block6: {
            if (!PolicyConfig.getInstance().check_cycle) {
                return -1;
            }
            try {
                PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("check_cycle");
                if (policyMapInfo == null) break block6;
            }
            catch (Exception exception) {
                return -1;
            }
            try {
                int n = Integer.parseInt(policyMapInfo.key_value);
                if (n <= 60) {
                    n = 60;
                }
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -2;
            }
        }
        return -1;
    }

    public int get_remind_cycle() {
        block6: {
            if (!PolicyConfig.getInstance().remind_cycle) {
                return -1;
            }
            try {
                PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("check_remind");
                if (policyMapInfo == null) break block6;
            }
            catch (Exception exception) {
                return -1;
            }
            try {
                int n = Integer.parseInt(policyMapInfo.key_value);
                if (n <= 60) {
                    n = 60;
                }
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -2;
            }
        }
        return -1;
    }

    public boolean isDownloadForce() {
        if (!PolicyConfig.getInstance().download_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_forceDownload");
        if (iParsePolicyListener != null) {
            return iParsePolicyListener.doParse();
        }
        return this.getInfoByKey("download_forceDownload");
    }

    public boolean isRebootUpdateForce() {
        if (!PolicyConfig.getInstance().reboot_update_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_rebootUpgrade");
        if (iParsePolicyListener != null) {
            return iParsePolicyListener.doParse();
        }
        return this.getInfoByKey("install_rebootUpgrade");
    }

    public boolean isGetToInstallFreeTime() {
        if (!PolicyConfig.getInstance().install_free_time) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_freeInstall");
        if (iParsePolicyListener != null) {
            return iParsePolicyListener.doParse();
        }
        return (this = this.getInstallFreeTime()) != null && i.a(new SimpleDateFormat("HH:mm").format(new Date()), (Date)this.first, (Date)this.second);
    }

    public Pair<Date, Date> getInstallFreeTime() {
        if (!PolicyConfig.getInstance().install_free_time) {
            return null;
        }
        return this.getTimeInterval(OtaConstants.IntervalTimePolicy.type_install_free_time);
    }

    public Pair<Date, Date> getForceInstallTime() {
        if (!PolicyConfig.getInstance().install_force) {
            return null;
        }
        return this.getTimeInterval(OtaConstants.IntervalTimePolicy.type_install_force);
    }

    public Pair<Date, Date> getTimeInterval(OtaConstants.IntervalTimePolicy object) {
        block9: {
            Object object2 = VersionInfo.getInstance().policyHashMap.get(((OtaConstants.IntervalTimePolicy)((Object)object)).getType());
            if (object2 != null) {
                SimpleDateFormat simpleDateFormat;
                JSONObject jSONObject = new JSONObject(((PolicyMapInfo)object2).key_value);
                JSONObject jSONObject2 = jSONObject;
                object2 = jSONObject.getString("from");
                object = jSONObject2.getString("to");
                SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
                Object object3 = object;
                simpleDateFormat2("HH:mm");
                object2 = simpleDateFormat2.parse((String)object2);
                object = simpleDateFormat.parse((String)object3);
                if (((Date)object2).getTime() == ((Date)object).getTime()) break block9;
                try {
                    return new Pair(object2, object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public String displayPolicy() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (VersionInfo.getInstance().policyHashMap != null) {
            for (Map.Entry<String, PolicyMapInfo> entry : VersionInfo.getInstance().policyHashMap.entrySet()) {
                stringBuilder2.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
        } else {
            stringBuilder2.append("null");
        }
        return stringBuilder2.toString();
    }
}

