/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.inter;

import android.content.Context;
import android.content.Intent;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.info.PushMessageInfo;
import com.abupdate.iot_libs.inter.ILoginCallback;
import com.abupdate.iot_libs.inter.ILogoutCallback;
import com.abupdate.iot_libs.inter.IReportDeviceStatusCallback;
import com.abupdate.iot_libs.inter.TimeoutCallback;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.d;
import com.abupdate.iot_libs.utils.h;
import com.abupdate.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.MqttMessage;
import com.abupdate.trace.Trace;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageListener
implements MqttCallback {
    private static final String TAG = "MessageListener";
    private static final String LOGOUT_RESPONSE = "logout/response";
    private static final String LOGIN_RESPONSE = "login/response";
    private static final String REPORT_DEVICE_STATUS_RESPONSE = "update/response";
    private static final String PUSH_NOTIFY = "notify";
    public static final int DISCONNECTED_OK = -1;
    private static final int RESPONSE_TIMEOUT = 5000;
    private static MessageListener messageListener;
    private Context mCx;
    private ILoginCallback mILoginCallback;
    private ILogoutCallback mILogoutCallback;
    private IReportDeviceStatusCallback mIReportDeviceStatusCallback;
    private boolean timeout = true;
    private ConnectionLostListener mConnectionLostListener;
    private State currentState = State.Null;

    private MessageListener() {
        this.mCx = OtaAgentPolicy.sCx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageListener getInstance() {
        if (messageListener != null) return messageListener;
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            if (messageListener != null) return messageListener;
            messageListener = new MessageListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return messageListener;
        }
    }

    private String getReply(String string) {
        block4: {
            JSONObject jSONObject;
            MessageListener messageListener = jSONObject;
            if (!new JSONObject(string).has("replyno")) break block4;
            try {
                return messageListener.getString("replyno");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStart() {
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            h.a().a(new TimeoutCallback(){

                @Override
                public void onTimeout() {
                    if (MessageListener.this.timeout) {
                        if (MessageListener.this.currentState == State.Login) {
                            MessageListener.this.mILoginCallback.onLoginTimeout();
                        }
                        if (MessageListener.this.currentState == State.Logout) {
                            MessageListener.this.mILogoutCallback.onLogoutTimeout();
                        }
                        if (MessageListener.this.currentState == State.ReportDeviceInfo) {
                            MessageListener.this.mIReportDeviceStatusCallback.onReportFail(32000);
                        }
                        MessageListener.this.setCurrentState(State.Null);
                    }
                }
            });
            return;
        }
    }

    private void setCurrentState(State state) {
        MessageListener messageListener = this;
        messageListener.timeout = true;
        messageListener.currentState = state;
    }

    public void connectionLost(Throwable throwable) {
        Trace.d((String)TAG, (String)"connectionLost() ");
        if (this.mConnectionLostListener != null) {
            int n = throwable != null && throwable instanceof MqttException ? ((MqttException)throwable).getReasonCode() : (throwable == null ? -1 : 6);
            this.mConnectionLostListener.onConnectLost(n);
        }
    }

    public void messageArrived(String string, MqttMessage object) throws Exception {
        String string2;
        String string3 = string2;
        string2 = new String(object.getPayload());
        Trace.d((String)TAG, (String)("messageArrived() :" + string));
        Trace.d((String)TAG, (String)("messageArrived() :" + string3));
        if (((MessageListener)((Object)string4)).currentState == State.Null && !string.endsWith(PUSH_NOTIFY)) {
            Trace.d((String)TAG, (String)"messageArrived() state is null");
            return;
        }
        if (string.endsWith(LOGIN_RESPONSE)) {
            string = ((MessageListener)((Object)string4)).getReply(string3);
            if (b.c().a(1000, string)) {
                ((MessageListener)((Object)string4)).timeout = false;
                int n = d.b(string3);
                if (d.b(n)) {
                    Trace.d((String)TAG, (String)"messageArrived() login response success!");
                    ((MessageListener)((Object)string4)).mILoginCallback.onLoginSuccess();
                    b.c().a(b.a.d);
                } else {
                    Trace.d((String)TAG, (String)"messageArrived() login response failed!");
                    ((MessageListener)((Object)string4)).mILoginCallback.onLoginFail(n);
                }
            }
        } else if (string.endsWith(LOGOUT_RESPONSE)) {
            string = ((MessageListener)((Object)string4)).getReply(string3);
            if (b.c().a(1001, string)) {
                Trace.d((String)TAG, (String)"messageArrived() logout response success!");
                ((MessageListener)((Object)string4)).timeout = false;
                int n = d.b(string3);
                if (d.b(n)) {
                    ((MessageListener)((Object)string4)).mILogoutCallback.onLogoutSuccess();
                    b.c().a(b.a.e);
                } else {
                    ((MessageListener)((Object)string4)).mILogoutCallback.onLogoutFail(n);
                }
            }
        } else if (string.endsWith(REPORT_DEVICE_STATUS_RESPONSE)) {
            string = ((MessageListener)((Object)string4)).getReply(string3);
            if (b.c().a(1002, string)) {
                Trace.d((String)TAG, (String)"messageArrived() report device info success");
                ((MessageListener)((Object)string4)).timeout = false;
                int n = d.b(string3);
                if (d.b(n)) {
                    ((MessageListener)((Object)string4)).mIReportDeviceStatusCallback.onReportSuccess();
                } else {
                    ((MessageListener)((Object)string4)).mIReportDeviceStatusCallback.onReportFail(n);
                }
            }
        } else if (string.endsWith(PUSH_NOTIFY)) {
            JSONObject jSONObject;
            string = jSONObject;
            if (new JSONObject(string3).has("body")) {
                if ((string = string.getJSONObject("body")).has("content")) {
                    Intent intent;
                    object = string.getString("content");
                    string3 = intent;
                    new Intent().setAction("action_fota_notify");
                    string3.putExtra("key_fota_notify", (String)object);
                    ((MessageListener)((Object)string4)).mCx.sendBroadcast((Intent)string3, "permission.com.abupdate.fota.update");
                }
                if (string.has("msgId")) {
                    MessageListener messageListener = string4;
                    String string4 = string.getString("msgId");
                    ReportManager.getInstance(messageListener.mCx).savePushResponseData(new PushMessageInfo(string4));
                    OtaService.startByAction("action_report");
                }
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void setLoginListener(ILoginCallback iLoginCallback) {
        MessageListener messageListener = this;
        messageListener.mILoginCallback = iLoginCallback;
        messageListener.setCurrentState(State.Login);
        messageListener.timeStart();
    }

    public void setLogoutListener(ILogoutCallback iLogoutCallback) {
        MessageListener messageListener = this;
        messageListener.mILogoutCallback = iLogoutCallback;
        messageListener.setCurrentState(State.Logout);
        messageListener.timeStart();
    }

    public void setReportDeviceStatusListener(IReportDeviceStatusCallback iReportDeviceStatusCallback) {
        MessageListener messageListener = this;
        messageListener.mIReportDeviceStatusCallback = iReportDeviceStatusCallback;
        messageListener.setCurrentState(State.ReportDeviceInfo);
        messageListener.timeStart();
    }

    public void setConnectionLostListener(ConnectionLostListener connectionLostListener) {
        this.mConnectionLostListener = connectionLostListener;
    }

    public static interface ConnectionLostListener {
        public void onConnectLost(int var1);
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State Null;
        public static final /* enum */ State Login;
        public static final /* enum */ State Logout;
        public static final /* enum */ State ReportDeviceInfo;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        static {
            State state;
            State state2;
            State state3;
            State state4;
            State state5 = state4;
            Null = new State();
            State state6 = state3;
            Login = new State();
            State state7 = state2;
            Logout = new State();
            State state8 = state;
            ReportDeviceInfo = new State();
            $VALUES = new State[]{state5, state6, state7, state8};
        }
    }
}

