package com.abupdate.iot_libs.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import com.abupdate.iot_libs.constant.OtaConstants;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.trace.Trace;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Method;

public class DeviceInfo {

    private static final String TAG = "DeviceInfo";

    public static final String KEY_MID_BACK = "key_mid_back";

    /**
     * 设备唯一标示码
     */
    public String mid;

    /**
     * 项目唯一标识码
     */
    public String productId;

    /**
     * 项目加密码
     */
    public String productSecret;

    /**
     * 设备版本号
     */
    public String version;
    /**
     * 厂商信息，广升提供
     */
    public String oem;
    /**
     * 设备型号，同一个厂商下面不允许出现相同型号的设备。oem+ models组成一个项目
     */
    public String models;
    /**
     * 芯片平台信息，如MTK6582、SPRD8830、MSM9x15，广升给出平台列表
     */
    public String platform;
    /**
     * 设备类型，如phone、box、pad、mifi等，广升给出类型列表
     */
    public String deviceType;

    /**
     * 设备的鉴权码
     */
    public String authentication = "";

    public static Context mContext;


    public static DeviceInfo mInstance;

    public static DeviceInfo getInstance() {
        if (mInstance == null) {
            synchronized (DeviceInfo.class) {
                if (mInstance == null) {
                    mInstance = new DeviceInfo();
                }
            }
        }
        return mInstance;
    }

    public static void initContext(Context context) {
        mContext = context;
    }

    /**
     * 初始化设备信息
     * @throws FotaException
     */
    public void init() throws FotaException {
        Trace.d(TAG, "%s%s%s", OtaConstants.SINGLE_LINE, "init info", OtaConstants.SINGLE_LINE);
        try {
            ApplicationInfo applicationInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), PackageManager.GET_META_DATA);
            String id = applicationInfo.metaData.getString("fota_configuration_product_id");
            String secret = applicationInfo.metaData.getString("fota_configuration_product_secret");

            if (TextUtils.isEmpty(id) || TextUtils.isEmpty(secret) || !id.startsWith("string/") || !secret.startsWith("string/")) {
                throw new FotaException(FotaException.REASON_CODE_MANIFEST_META_DATA_ERROR);
            }
            productId = id.replace("string/", "").trim();
            productSecret = secret.replace("string/", "").trim();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            throw new FotaException(e);
        } catch (NullPointerException e) {
            e.printStackTrace();
            throw new FotaException(FotaException.REASON_CODE_MANIFEST_META_DATA_ERROR, e);
        }
        try {
            ClassLoader cl = mContext.getClassLoader();
            Class SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[1];
            paramTypes[0] = String.class;

            Method get = SystemProperties.getMethod("get", paramTypes);

            this.version = (String) get.invoke(SystemProperties, new Object[]{"ro.fota.version"});
            this.oem = (String) get.invoke(SystemProperties, new Object[]{"ro.fota.oem"});
            this.models = (String) get.invoke(SystemProperties, new Object[]{"ro.fota.device"});
            this.platform = (String) get.invoke(SystemProperties, new Object[]{"ro.fota.platform"});
            this.deviceType = (String) get.invoke(SystemProperties, new Object[]{"ro.fota.type"});

        } catch (Exception e) {
            throw new FotaException(FotaException.REASON_CODE_DEVICE_PARAMETERS, e);
        }
        Trace.d(TAG, String.format("productId:%s,product_secret:%s,version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", productId, productSecret, version, oem, models, platform, deviceType));
    }

    /**
     * 设置设备mid
     *
     * @param mid
     */
    public void initInfo(String mid) {
        Trace.d(TAG, "set mid:"+mid);
        this.mid = mid;
        SPFTool.putString(KEY_MID_BACK,mid);
    }

    /**
     * 方便测试时调用
     *
     * @param version
     * @param oem
     * @param models
     * @param platform
     * @param deviceType
     * @return
     */
    public void initOtherInfo(String version, String oem, String models, String platform, String deviceType,String productId,String product_secret) throws FotaException {
        Trace.d(TAG, "%s%s%s", OtaConstants.SINGLE_LINE, "init other info", OtaConstants.SINGLE_LINE);
        this.productId = productId;
        this.productSecret = product_secret;
        this.oem = oem;
        this.models = models;
        this.platform = platform;
        this.deviceType = deviceType;
        this.version = version;
        Trace.d(TAG, String.format("productId:%s,product_secret:%s,version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", productId, product_secret, version, oem, models, platform, deviceType));
    }

    public boolean isValid() {
        boolean valid = true;
        if (TextUtils.isEmpty(mid)) {
            Trace.d(TAG, "isValid() mid = null");
            valid = false;
        }
        if (TextUtils.isEmpty(oem)) {
            Trace.d(TAG, "isValid() oem = null");
            valid = false;
        }
        if (TextUtils.isEmpty(models)) {
            Trace.d(TAG, "isValid() models = null");
            valid = false;
        }
        if (TextUtils.isEmpty(platform)) {
            Trace.d(TAG, "isValid() platform = null");
            valid = false;
        }
        if (TextUtils.isEmpty(deviceType)) {
            Trace.d(TAG, "isValid() deviceType = null");
            valid = false;
        }
        if (TextUtils.isEmpty(productSecret)) {
            Trace.d(TAG, "isValid() product_secret = null");
            valid = false;
        }
        if (TextUtils.isEmpty(productId)) {
            Trace.d(TAG, "isValid() product id = null");
            valid = false;
        }
        return valid;
    }

    @Override
    public String toString() {
        JSONObject object = new JSONObject();
        try {
            object.put("mid",mid);
            object.put("version",version);
            object.put("oem",oem);
            object.put("models",models);
            object.put("platform",platform);
            object.put("deviceType",deviceType);
            object.put("productId",productId);
            object.put("productSecret",productSecret);
        } catch (JSONException e) {
            e.printStackTrace();
        }
//        return "{" + "\n" +
//                "mid=" + "'" + mid + '\'' + "\n" +
//                "oem=" + "'" + oem + '\'' + "\n" +
//                "models=" + "'" + models + '\'' + "\n" +
//                "platform=" + "'" + platform + '\'' + "\n" +
//                "deviceType=" + "'" + deviceType + '\'' + "\n" +
//                "product secret=" + "'" + product_secret + '\'' + "\n" +
//                "product id=" + "'" + productId + '\'' + "\n" +
//                '}';
        return object.toString();
    }

}
