/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.abupdate.iot_libs.MqttAgentPolicy;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.engine.LogManager;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.UpgradeParamInfo;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.g;
import com.abupdate.trace.Trace;
import java.io.File;

public class UpgradeReceiver
extends BroadcastReceiver {
    private Context a;

    public void onReceive(Context context, Intent intent) {
        this.a = context;
        if (null == OtaAgentPolicy.sCx) {
            SPFTool.initContext(this.a);
        }
        String string = intent.getAction();
        Trace.d((String)"UpgradeReceiver", (String)("action: " + string));
        this.a(string);
    }

    private void a(String string) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            this.b();
        } else if ("android.intent.action.BOOT_COMPLETED".equals(string)) {
            this.a();
        }
    }

    private void a() {
        SPFTool.putBoolean("key_should_report", true);
        String string = SPFTool.getString("key_version_name", "");
        String string2 = SPFTool.getString("KEY_DELTAID", "");
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            String string3;
            SPFTool.putString("key_version_name", "");
            SPFTool.putString("KEY_DELTAID", "");
            Trace.i((String)"UpgradeReceiver", (String)("mobile version:" + DeviceInfo.getInstance().version + " update version " + string));
            boolean bl = string.equals(DeviceInfo.getInstance().version);
            Intent intent = new Intent("action_fota_update_result");
            intent.putExtra("key_fota_update_result", bl);
            intent.addFlags(32);
            this.a.sendBroadcast(intent, "permission.com.glutrac.dynasynq.abupdate.fota.update");
            if (bl) {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() update success!");
                string3 = SPFTool.getString("key_update_file_path", "");
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    new File(string3).delete();
                }
            } else {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() update failed!");
            }
            string3 = TextUtils.isEmpty((CharSequence)DeviceInfo.getInstance().mid) ? SPFTool.getString("key_mid_back", "abupdate-MID-ERROR-COLLECT") : DeviceInfo.getInstance().mid;
            UpgradeParamInfo upgradeParamInfo = new UpgradeParamInfo(string3, string2, String.valueOf(bl ? 1 : 99));
            ReportManager.getInstance(this.a).saveReportData(upgradeParamInfo);
            if (!bl) {
                LogManager.getInstance().saveRecoveryLog(string2);
            }
            if (g.a(OtaAgentPolicy.sCx) || g.a(null)) {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() boot complete upgrade report");
                this.c();
            }
        }
    }

    private void b() {
        if (Build.VERSION.SDK_INT < 21 && g.a(null)) {
            Trace.d((String)"UpgradeReceiver", (String)("network_process() should_report = " + SPFTool.getBoolean("key_should_report", false)));
            if (SPFTool.getBoolean("key_should_report", false)) {
                this.c();
            }
            if (System.currentTimeMillis() - SPFTool.getLong("spf_static_check_version_cycle", -1L) >= 259200000L) {
                OtaService.startByAction("action_static_check_version");
                SPFTool.putLong("spf_static_check_version_cycle", System.currentTimeMillis());
            }
            if (SPFTool.getBoolean("config_mqtt_connect", false) && !MqttAgentPolicy.isConnected()) {
                MqttAgentPolicy.connect();
            }
        }
    }

    private void c() {
        if (ReportManager.getInstance(this.a).queryReport() == 0) {
            SPFTool.putBoolean("key_should_report", false);
            Trace.d((String)"UpgradeReceiver", (String)"report() do not have data to be reported!");
            return;
        }
        OtaService.startByAction("action_report");
    }
}

