/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.info;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.trace.Trace;

public class ProductInfo {
    private static final String TAG = "ProductInfo";
    private static ProductInfo mInstance;
    public String productId;
    public String productSecret;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProductInfo getInstance() {
        if (mInstance != null) return mInstance;
        Class<ProductInfo> clazz = ProductInfo.class;
        synchronized (ProductInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ProductInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private void initFromLocal() {
        ProductInfo productInfo = this;
        productInfo.productId = SPFTool.getString(SPFTool.KEY_PRODUCT_ID, "");
        productInfo.productSecret = SPFTool.getString("key_product_secret", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws FotaException {
        try {
            Object object = OtaAgentPolicy.sCx.getPackageManager().getApplicationInfo(OtaAgentPolicy.sCx.getPackageName(), 128);
            Object object2 = null;
            Object object3 = null;
            if (object != null && ((ApplicationInfo)object).metaData != null) {
                ApplicationInfo applicationInfo = object;
                object2 = applicationInfo.metaData.get("fota_configuration_product_id");
                object3 = applicationInfo.metaData.get("fota_configuration_product_secret");
            }
            if (object2 == null && object3 == null) {
                this.initFromLocal();
                return;
            }
            object = (String)object2;
            object2 = (String)object3;
            if (TextUtils.isEmpty((CharSequence)object)) throw new FotaException(203);
            if (TextUtils.isEmpty((CharSequence)object2)) throw new FotaException(203);
            if (!((String)object).startsWith("string/")) throw new FotaException(203);
            if (!((String)object2).startsWith("string/")) throw new FotaException(203);
            this.productId = ((String)object).replace("string/", "").trim();
            this.productSecret = ((String)object2).replace("string/", "").trim();
            return;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new FotaException(203, (Throwable)nullPointerException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new FotaException(nameNotFoundException);
        }
    }

    public boolean isProductValid() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.productSecret)) {
            Trace.d((String)TAG, (String)"isValid() product_secret = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() product id = null");
            bl = false;
        }
        return bl;
    }

    public void setAndStoreProductInfo(String string, String string2) {
        SPFTool.putString(SPFTool.KEY_PRODUCT_ID, string);
        SPFTool.putString("key_product_secret", string2);
        ProductInfo.getInstance().productId = string;
        ProductInfo.getInstance().productSecret = string2;
    }

    public void reset() {
        ProductInfo productInfo = this;
        Trace.d((String)TAG, (String)"product info reset");
        productInfo.productId = "";
        productInfo.productSecret = "";
        SPFTool.putString(SPFTool.KEY_PRODUCT_ID, "");
        SPFTool.putString("key_product_secret", "");
    }
}

