/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Pair;
import com.abupdate.http_libs.engine.HttpManager;
import com.abupdate.iot_download_libs.DLManager;
import com.abupdate.iot_download_libs.DownConfig;
import com.abupdate.iot_libs.MqttAgentPolicy;
import com.abupdate.iot_libs.constant.SDKConfig;
import com.abupdate.iot_libs.engine.b;
import com.abupdate.iot_libs.engine.c;
import com.abupdate.iot_libs.engine.d;
import com.abupdate.iot_libs.info.CustomDeviceInfo;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.ProductInfo;
import com.abupdate.iot_libs.info.RegisterInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.ICheckVersionCallback;
import com.abupdate.iot_libs.inter.IDownSimpleListener;
import com.abupdate.iot_libs.inter.IDownloadListener;
import com.abupdate.iot_libs.inter.IRebootUpgradeCallBack;
import com.abupdate.iot_libs.inter.IRegisterListener;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.service.JobSchedulerService;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.a;
import com.abupdate.iot_libs.utils.j;
import com.abupdate.trace.Trace;
import java.io.File;

public class OtaAgentPolicy {
    public static Context sCx;
    public static Builder config;
    private static final String TAG = "OtaAgentPolicy";

    private static void initFota(Context context) throws FotaException {
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        objectArray[0] = "--------------------------";
        objectArray[1] = "init Fota";
        objectArray[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])object);
        com.abupdate.iot_libs.engine.a.a().a(context);
        SDKConfig.gen();
        OtaAgentPolicy.verifyManifest(context);
        if (OtaAgentPolicy.config.customDeviceInfo == null) {
            DeviceInfo.getInstance().init();
            ProductInfo.getInstance().init();
        } else {
            CustomDeviceInfo customDeviceInfo = OtaAgentPolicy.config.customDeviceInfo;
            object = customDeviceInfo.version;
            String string = customDeviceInfo.oem;
            String string2 = customDeviceInfo.models;
            String string3 = customDeviceInfo.platform;
            String string4 = customDeviceInfo.deviceType;
            DeviceInfo.getInstance().initOtherInfo((String)object, string, string2, string3, string4);
            if (!TextUtils.isEmpty((CharSequence)OtaAgentPolicy.config.customDeviceInfo.productId) && !TextUtils.isEmpty((CharSequence)OtaAgentPolicy.config.customDeviceInfo.product_secret)) {
                ProductInfo.getInstance().productSecret = OtaAgentPolicy.config.customDeviceInfo.product_secret;
                ProductInfo.getInstance().productId = OtaAgentPolicy.config.customDeviceInfo.productId;
            } else {
                ProductInfo.getInstance().init();
            }
        }
        RegisterInfo.getInstance().init();
        MqttAgentPolicy.initMqtt();
        a.a();
        HttpManager.build((Context)context).setRedirectTimes(0).setRetryTimes(3).create();
        if (Build.VERSION.SDK_INT >= 21) {
            OtaAgentPolicy.startJobService();
        }
    }

    @RequiresApi(api=21)
    private static void startJobService() {
        ComponentName componentName;
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent(sCx, JobSchedulerService.class);
        sCx.startService(intent2);
        intent2 = componentName;
        componentName = new ComponentName(sCx, JobSchedulerService.class);
        ((JobScheduler)sCx.getSystemService("jobscheduler")).schedule(new JobInfo.Builder(888, (ComponentName)intent2).setPeriodic(86400000L).setRequiredNetworkType(1).setPersisted(true).build());
    }

    public static void registerAsync(IRegisterListener objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[3];
        objectArray = objectArray3;
        objectArray3[0] = "--------------------------";
        objectArray3[1] = "register";
        objectArray3[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray);
        c.a((IRegisterListener)objectArray2);
        OtaService.startByAction("action_register");
    }

    public static VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    public static void checkVersionAsync(ICheckVersionCallback objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[3];
        objectArray = objectArray3;
        objectArray3[0] = "--------------------------";
        objectArray3[1] = "check version";
        objectArray3[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray);
        c.a((ICheckVersionCallback)objectArray2);
        OtaService.startByAction("action_check_version");
    }

    public static Pair<Integer, VersionInfo> checkVersionExecute() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "--------------------------";
        objectArray[1] = "check version";
        objectArray[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray2);
        int n = d.e().b();
        return new Pair((Object)n, (Object)VersionInfo.getInstance());
    }

    public static void downloadAsync(IDownloadListener objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[3];
        objectArray = objectArray3;
        objectArray3[0] = "--------------------------";
        objectArray3[1] = "downloadEnqueue";
        objectArray3[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray);
        c.a((IDownloadListener)objectArray2);
        OtaService.startByAction("action_download");
    }

    public static boolean downloadExecute(IDownSimpleListener iDownSimpleListener) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "--------------------------";
        objectArray[1] = "downloadExecute";
        objectArray[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray2);
        return d.e().a(iDownSimpleListener);
    }

    public static boolean downloadExecute(IDownSimpleListener iDownSimpleListener, boolean bl) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "--------------------------";
        objectArray[1] = "downloadExecute";
        objectArray[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray2);
        return d.e().a(iDownSimpleListener, bl);
    }

    public static void downloadCancel() {
        Trace.d((String)TAG, (String)"downloadCancel().");
        OtaService.setDownloadCancel();
    }

    public static void rebootUpgrade(IRebootUpgradeCallBack objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[3];
        objectArray = objectArray3;
        objectArray3[0] = "--------------------------";
        objectArray3[1] = "reboot update";
        objectArray3[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray);
        OtaService.startByAction("action_update");
        c.a((IRebootUpgradeCallBack)objectArray2);
    }

    public static void rebootLocalUpgrade(String string, IRebootUpgradeCallBack objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[3];
        objectArray = objectArray3;
        objectArray3[0] = "--------------------------";
        objectArray3[1] = "reboot local update";
        objectArray3[2] = "--------------------------";
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])objectArray);
        OtaService.startByAction("action_update", string);
        c.a((IRebootUpgradeCallBack)objectArray2);
    }

    private static boolean verifyManifest(Context context) {
        if (b.a(context)) {
            return true;
        }
        throw new RuntimeException("AndroidManifest element and permissions is lack");
    }

    public static Builder init(Context context) {
        config = new Builder();
        sCx = context;
        SPFTool.initContext(sCx);
        OtaService.initContext(sCx);
        DLManager.getInstance().setContext(sCx);
        return config;
    }

    public static Builder getConfig() {
        return config;
    }

    public static class Builder {
        public String updatePath;
        public String tracePath;
        public boolean showTrace = true;
        public CustomDeviceInfo customDeviceInfo;
        public String mid;
        public boolean reportLog = true;

        public Builder setUpdatePath(String string) {
            Trace.d((String)OtaAgentPolicy.TAG, (String)("setUpdatePath() :" + string));
            if (com.abupdate.iot_libs.utils.c.a(new File(string).getParentFile().getAbsolutePath())) {
                this.updatePath = string;
            } else {
                Trace.e((String)OtaAgentPolicy.TAG, (String)"setUpdatePath() path is invalid ! set path fail");
            }
            return this;
        }

        public Builder setTracePath(String string) {
            Trace.d((String)OtaAgentPolicy.TAG, (String)("setTracePath() path:" + string));
            if (com.abupdate.iot_libs.utils.c.a(new File(string).getParentFile().getAbsolutePath())) {
                this.tracePath = string;
            } else {
                Trace.d((String)OtaAgentPolicy.TAG, (String)"setTracePath() path is invalid ! set path fail");
            }
            return this;
        }

        public Builder showTrace(boolean bl) {
            this.showTrace = bl;
            return this;
        }

        public Builder isReportLog(boolean bl) {
            this.reportLog = bl;
            return this;
        }

        public Builder setMid(String string) {
            this.mid = string;
            return this;
        }

        public Builder setCustomDeviceInfo(CustomDeviceInfo customDeviceInfo) {
            this.customDeviceInfo = customDeviceInfo;
            return this;
        }

        public void commit() throws FotaException {
            CustomDeviceInfo customDeviceInfo;
            if (!(!TextUtils.isEmpty((CharSequence)this.updatePath) && com.abupdate.iot_libs.utils.c.a(new File(this.updatePath).getParentFile().getAbsolutePath()))) {
                this.updatePath = sCx.getFilesDir() + File.separator + "update.zip";
            }
            if (!(!TextUtils.isEmpty((CharSequence)this.tracePath) && com.abupdate.iot_libs.utils.c.a(new File(this.tracePath).getParentFile().getAbsolutePath()))) {
                this.tracePath = j.b(sCx);
            }
            Trace.setLevel((int)(this.showTrace ? 3 : 7));
            Builder builder = this;
            Trace.setLog_path((String)builder.tracePath);
            Trace.setShowPosition((boolean)true);
            DownConfig.RETRY_TIMES_MAX = 3;
            if (TextUtils.isEmpty((CharSequence)builder.mid) && ((customDeviceInfo = this.customDeviceInfo) == null || TextUtils.isEmpty((CharSequence)customDeviceInfo.mid))) {
                throw new RuntimeException("mid can not be null");
            }
            customDeviceInfo = this.customDeviceInfo;
            if (customDeviceInfo != null && !TextUtils.isEmpty((CharSequence)customDeviceInfo.mid)) {
                DeviceInfo.getInstance().initInfo(this.customDeviceInfo.mid);
            } else {
                DeviceInfo.getInstance().initInfo(this.mid);
            }
            OtaAgentPolicy.initFota(sCx);
        }
    }
}

